/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.api;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndex;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexWithBuddyBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;

public abstract class AbstractLSMWithBuddyDiskComponent
extends AbstractLSMWithBloomFilterDiskComponent {
    public AbstractLSMWithBuddyDiskComponent(AbstractLSMIndex lsmIndex, IMetadataPageManager mdPageManager, ILSMComponentFilter filter) {
        super(lsmIndex, mdPageManager, filter);
    }

    public abstract AbstractTreeIndex getBuddyIndex();

    @Override
    public void markAsValid(boolean persist, IPageWriteFailureCallback callback) throws HyracksDataException {
        super.markAsValid(persist, callback);
        ComponentUtils.markAsValid((ITreeIndex)this.getBuddyIndex(), persist, callback);
    }

    @Override
    public void activate(boolean createNewComponent) throws HyracksDataException {
        super.activate(createNewComponent);
        if (createNewComponent) {
            this.getBuddyIndex().create();
        }
        this.getBuddyIndex().activate();
    }

    @Override
    public void destroy() throws HyracksDataException {
        super.destroy();
        this.getBuddyIndex().destroy();
    }

    @Override
    public void deactivate() throws HyracksDataException {
        super.deactivate();
        this.getBuddyIndex().deactivate();
    }

    @Override
    protected void purge() throws HyracksDataException {
        super.purge();
        this.getBuddyIndex().purge();
    }

    @Override
    public void validate() throws HyracksDataException {
        super.validate();
        this.getBuddyIndex().validate();
    }

    @Override
    protected IChainedComponentBulkLoader createIndexBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, IPageWriteCallback callback) throws HyracksDataException {
        IIndexBulkLoader indexBulkLoader = this.getIndex().createBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, callback);
        IIndexBulkLoader buddyBulkLoader = this.getBuddyIndex().createBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, callback);
        return new IndexWithBuddyBulkLoader(indexBulkLoader, buddyBulkLoader);
    }
}

