/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractAsynchronousScheduler;

public class AsynchronousScheduler
extends AbstractAsynchronousScheduler {
    public static final ILSMIOOperationSchedulerFactory FACTORY = new ILSMIOOperationSchedulerFactory(){

        @Override
        public ILSMIOOperationScheduler createIoScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback, int maxNumRunningFlushes, int maxNumScheduledMerges, int maxNumRunningMerges) {
            return new AsynchronousScheduler(threadFactory, callback, maxNumRunningFlushes, maxNumRunningMerges);
        }

        @Override
        public String getName() {
            return "async";
        }
    };
    private final int maxNumRunningMerges;
    private int numRunningMerges = 0;

    public AsynchronousScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback, int maxNumRunningFlushes, int maxNumRunningMerges) {
        super(threadFactory, callback, maxNumRunningFlushes);
        this.maxNumRunningMerges = maxNumRunningMerges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scheduleMerge(ILSMIOOperation operation) {
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            if (this.numRunningMerges >= this.maxNumRunningMerges) {
                this.waitingMergeOperations.add(operation);
            } else {
                this.doScheduleMerge(operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completeMerge(ILSMIOOperation operation) {
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            --this.numRunningMerges;
            if (!this.waitingMergeOperations.isEmpty() && this.numRunningMerges < this.maxNumRunningMerges) {
                this.doScheduleMerge((ILSMIOOperation)this.waitingMergeOperations.poll());
            }
        }
    }

    private void doScheduleMerge(ILSMIOOperation operation) {
        ++this.numRunningMerges;
        this.executor.submit(operation);
    }
}

