/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StaticResourceServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();

    public StaticResourceServlet(ConcurrentMap<String, Object> ctx, String[] paths) {
        super(ctx, paths);
    }

    @Override
    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        String resourcePath = request.getHttpRequest().uri();
        this.deliverResource(resourcePath, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverResource(String resourcePath, IServletResponse response) throws IOException {
        block15: {
            response.setStatus(HttpResponseStatus.OK);
            try (InputStream is = StaticResourceServlet.class.getResourceAsStream(resourcePath);){
                if (is == null) {
                    response.setStatus(HttpResponseStatus.NOT_FOUND);
                    return;
                }
                String extension = StaticResourceServlet.extension(resourcePath);
                String mime = HttpUtil.mime(extension);
                if (mime == null) {
                    response.setStatus(HttpResponseStatus.BAD_REQUEST);
                    break block15;
                }
                OutputStream out = response.outputStream();
                HttpUtil.setContentType(response, mime);
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)out);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARN, "Failure copying response", (Throwable)e);
                }
                finally {
                    if (out != null) {
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
    }

    public static String extension(String path) {
        int i = path.lastIndexOf(46);
        return i < 1 ? "" : path.substring(i);
    }
}

