/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class BitValuePositionFlagTypeComputer
extends AbstractResultTypeComputer {
    public static final BitValuePositionFlagTypeComputer INSTANCE_SET_CLEAR = new BitValuePositionFlagTypeComputer(2, true, BuiltinType.AINT64);
    public static final BitValuePositionFlagTypeComputer INSTANCE_SHIFT_WITH_FLAG = new BitValuePositionFlagTypeComputer(2, false, BuiltinType.AINT64);
    public static final BitValuePositionFlagTypeComputer INSTANCE_SHIFT_WITHOUT_FLAG = new BitValuePositionFlagTypeComputer(3, false, BuiltinType.AINT64);
    public static final BitValuePositionFlagTypeComputer INSTANCE_TEST_WITH_FLAG = new BitValuePositionFlagTypeComputer(2, true, BuiltinType.ABOOLEAN);
    public static final BitValuePositionFlagTypeComputer INSTANCE_TEST_WITHOUT_FLAG = new BitValuePositionFlagTypeComputer(3, true, BuiltinType.ABOOLEAN);
    private final int numberOfArguments;
    private final boolean secondArgCanBeArray;
    private final IAType returnType;

    private BitValuePositionFlagTypeComputer(int numberOfArguments, boolean secondArgCanBeArray, IAType returnType) {
        this.numberOfArguments = numberOfArguments;
        this.secondArgCanBeArray = secondArgCanBeArray;
        this.returnType = returnType;
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        boolean isReturnNullable = false;
        IAType firstArgument = strippedInputTypes[0];
        IAType secondArgument = strippedInputTypes[1];
        switch (firstArgument.getTypeTag()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case ANY: {
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                isReturnNullable = true;
                break;
            }
            default: {
                return BuiltinType.ANULL;
            }
        }
        block4 : switch (secondArgument.getTypeTag()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case ANY: {
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                isReturnNullable = true;
                break;
            }
            case ARRAY: {
                if (!this.secondArgCanBeArray) {
                    return BuiltinType.ANULL;
                }
                AOrderedListType listType = (AOrderedListType)secondArgument;
                IAType itemType = listType.getItemType();
                switch (itemType.getTypeTag()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: {
                        break block4;
                    }
                    case ANY: 
                    case FLOAT: 
                    case DOUBLE: {
                        isReturnNullable = true;
                        break block4;
                    }
                }
                return BuiltinType.ANULL;
            }
            default: {
                return BuiltinType.ANULL;
            }
        }
        if (this.numberOfArguments == 3 && strippedInputTypes.length >= 3) {
            IAType thirdArgument = strippedInputTypes[2];
            switch (thirdArgument.getTypeTag()) {
                case ANY: 
                case BOOLEAN: {
                    break;
                }
                default: {
                    return BuiltinType.ANULL;
                }
            }
        }
        return isReturnNullable ? AUnionType.createNullableType(this.returnType) : this.returnType;
    }
}

