/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.aggregates.std.AbstractAggregateFunction;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractUnionMbrAggregateFunction
extends AbstractAggregateFunction {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private IPointable inputVal = new VoidPointable();
    private final IScalarEvaluator eval;
    protected final IEvaluatorContext context;
    protected double currentMinX;
    protected double currentMinY;
    protected double currentMaxX;
    protected double currentMaxY;
    protected final AMutablePoint[] aPoint = new AMutablePoint[]{new AMutablePoint(0.0, 0.0), new AMutablePoint(0.0, 0.0)};
    protected final AMutableRectangle aRect = new AMutableRectangle((APoint)this.aPoint[0], (APoint)this.aPoint[1]);
    private ISerializerDeserializer<ARectangle> rectangleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ARECTANGLE);

    public AbstractUnionMbrAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
        super(sourceLoc);
        this.eval = args[0].createScalarEvaluator(context);
        this.context = context;
    }

    public void init() throws HyracksDataException {
        this.currentMinX = Double.POSITIVE_INFINITY;
        this.currentMinY = Double.POSITIVE_INFINITY;
        this.currentMaxX = Double.NEGATIVE_INFINITY;
        this.currentMaxY = Double.NEGATIVE_INFINITY;
    }

    public void step(IFrameTupleReference tuple) throws HyracksDataException {
        this.eval.evaluate(tuple, this.inputVal);
        byte[] data = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        int len = this.inputVal.getLength();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.inputVal.getByteArray()[this.inputVal.getStartOffset()]);
        if (typeTag == ATypeTag.NULL || typeTag == ATypeTag.MISSING) {
            this.processNull(typeTag);
        } else if (typeTag == ATypeTag.RECTANGLE) {
            double minX = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
            double minY = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
            double maxX = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
            double maxY = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
            this.currentMinX = Math.min(this.currentMinX, minX);
            this.currentMinY = Math.min(this.currentMinY, minY);
            this.currentMaxX = Math.max(this.currentMaxX, maxX);
            this.currentMaxY = Math.max(this.currentMaxY, maxY);
        }
    }

    public void finish(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            this.aPoint[0].setValue(this.currentMinX, this.currentMinY);
            this.aPoint[1].setValue(this.currentMaxX, this.currentMaxY);
            this.aRect.setValue((APoint)this.aPoint[0], (APoint)this.aPoint[1]);
            this.rectangleSerde.serialize((Object)this.aRect, this.resultStorage.getDataOutput());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    public void finishPartial(IPointable result) throws HyracksDataException {
        if (!this.isValidCoordinates(this.currentMinX, this.currentMinY, this.currentMaxX, this.currentMaxY)) {
            this.currentMinX = 0.0;
            this.currentMinY = 0.0;
            this.currentMaxX = 0.0;
            this.currentMaxY = 0.0;
        }
        this.finish(result);
    }

    protected void processNull(ATypeTag typeTag) throws UnsupportedItemTypeException {
        throw new UnsupportedItemTypeException(this.sourceLoc, BuiltinFunctions.UNION_MBR, typeTag.serialize());
    }

    private boolean isValidCoordinates(double minX, double minY, double maxX, double maxY) {
        return minX != Double.POSITIVE_INFINITY && minY != Double.POSITIVE_INFINITY && maxX != Double.NEGATIVE_INFINITY && maxY != Double.NEGATIVE_INFINITY;
    }
}

