/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.util.StringUtil;

public final class NumberUtils {
    public static final UTF8StringPointable POSITIVE_INF = UTF8StringPointable.generateUTF8Pointable((String)"INF");
    public static final UTF8StringPointable NEGATIVE_INF = UTF8StringPointable.generateUTF8Pointable((String)"-INF");
    public static final UTF8StringPointable NAN = UTF8StringPointable.generateUTF8Pointable((String)"NaN");
    public static final long NAN_BITS = Double.doubleToLongBits(Double.NaN);
    public static final long POSITIVE_ZERO_BITS = Double.doubleToLongBits(0.0);
    public static final long NEGATIVE_ZERO_BITS = Double.doubleToLongBits(-0.0);

    public static boolean parseDouble(UTF8StringPointable textPtr, AMutableDouble result) {
        double v;
        if (POSITIVE_INF.compareTo((IPointable)textPtr) == 0) {
            v = Double.POSITIVE_INFINITY;
        } else if (NEGATIVE_INF.compareTo((IPointable)textPtr) == 0) {
            v = Double.NEGATIVE_INFINITY;
        } else if (NAN.compareTo((IPointable)textPtr) == 0) {
            v = Double.NaN;
        } else {
            try {
                v = Double.parseDouble(textPtr.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        result.setValue(v);
        return true;
    }

    public static boolean parseFloat(UTF8StringPointable textPtr, AMutableFloat result) {
        float v;
        if (POSITIVE_INF.compareTo((IPointable)textPtr) == 0) {
            v = Float.POSITIVE_INFINITY;
        } else if (NEGATIVE_INF.compareTo((IPointable)textPtr) == 0) {
            v = Float.NEGATIVE_INFINITY;
        } else if (NAN.compareTo((IPointable)textPtr) == 0) {
            v = Float.NaN;
        } else {
            try {
                v = Float.parseFloat(textPtr.toString());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        result.setValue(v);
        return true;
    }

    public static boolean parseInt64(UTF8StringPointable textPtr, AMutableInt64 result, MutableBoolean maybeNumeric) {
        byte[] bytes = textPtr.getByteArray();
        int offset = textPtr.getCharStartOffset();
        int end = textPtr.getStartOffset() + textPtr.getLength();
        return NumberUtils.parseInt64(bytes, offset, end, StringUtil.getByteArrayAsCharAccessor(), result, maybeNumeric);
    }

    public static <T> boolean parseInt64(T input, int begin, int end, StringUtil.ICharAccessor<T> charAccessor, AMutableInt64 result, MutableBoolean maybeNumeric) {
        if (maybeNumeric != null) {
            maybeNumeric.setFalse();
        }
        int offset = begin;
        long value = 0L;
        boolean positive = true;
        long limit = -9223372036854775807L;
        char c = charAccessor.charAt(input, offset);
        if (c == '+') {
            ++offset;
        } else if (c == '-') {
            ++offset;
            positive = false;
            limit = Long.MIN_VALUE;
        }
        while (offset < end) {
            c = charAccessor.charAt(input, offset);
            if (c < '0' || c > '9') {
                if (c == 'i' && charAccessor.charAt(input, offset + 1) == '6' && charAccessor.charAt(input, offset + 2) == '4' && offset + 3 == end) break;
                if (maybeNumeric != null) {
                    maybeNumeric.setValue(NumberUtils.isNumericNonDigitOrSignChar(c));
                }
                return false;
            }
            int digit = c - 48;
            if ((value *= 10L) < limit + (long)digit) {
                return false;
            }
            value -= (long)digit;
            ++offset;
        }
        if (value > 0L) {
            return false;
        }
        if (value < 0L && positive) {
            value *= -1L;
        }
        result.setValue(value);
        return true;
    }

    public static boolean parseInt32(UTF8StringPointable textPtr, AMutableInt32 result, MutableBoolean maybeNumeric) {
        if (maybeNumeric != null) {
            maybeNumeric.setFalse();
        }
        byte[] bytes = textPtr.getByteArray();
        int offset = textPtr.getCharStartOffset();
        int value = 0;
        boolean positive = true;
        int limit = -2147483647;
        if (bytes[offset] == 43) {
            ++offset;
        } else if (bytes[offset] == 45) {
            ++offset;
            positive = false;
            limit = Integer.MIN_VALUE;
        }
        int end = textPtr.getStartOffset() + textPtr.getLength();
        while (offset < end) {
            if (bytes[offset] < 48 || bytes[offset] > 57) {
                if (bytes[offset] == 105 && bytes[offset + 1] == 51 && bytes[offset + 2] == 50 && offset + 3 == end) break;
                if (maybeNumeric != null) {
                    maybeNumeric.setValue(NumberUtils.isNumericNonDigitOrSignChar(bytes[offset]));
                }
                return false;
            }
            int digit = bytes[offset] - 48;
            if ((value *= 10) < limit + digit) {
                return false;
            }
            value -= digit;
            ++offset;
        }
        if (value > 0) {
            return false;
        }
        if (value < 0 && positive) {
            value *= -1;
        }
        result.setValue(value);
        return true;
    }

    public static boolean parseInt16(UTF8StringPointable textPtr, AMutableInt16 result, MutableBoolean maybeNumeric) {
        if (maybeNumeric != null) {
            maybeNumeric.setFalse();
        }
        byte[] bytes = textPtr.getByteArray();
        int offset = textPtr.getCharStartOffset();
        int value = 0;
        boolean positive = true;
        int limit = -32767;
        if (bytes[offset] == 43) {
            ++offset;
        } else if (bytes[offset] == 45) {
            ++offset;
            positive = false;
            limit = Short.MIN_VALUE;
        }
        int end = textPtr.getStartOffset() + textPtr.getLength();
        while (offset < end) {
            if (bytes[offset] < 48 || bytes[offset] > 57) {
                if (bytes[offset] == 105 && bytes[offset + 1] == 49 && bytes[offset + 2] == 54 && offset + 3 == end) break;
                if (maybeNumeric != null) {
                    maybeNumeric.setValue(NumberUtils.isNumericNonDigitOrSignChar(bytes[offset]));
                }
                return false;
            }
            value = (short)(value * 10);
            int digit = bytes[offset] - 48;
            if (value < limit + digit) {
                return false;
            }
            value = (short)(value - digit);
            ++offset;
        }
        if (value > 0) {
            return false;
        }
        if (value < 0 && positive) {
            value = (short)(value * -1);
        }
        result.setValue((short)value);
        return true;
    }

    public static boolean parseInt8(UTF8StringPointable textPtr, AMutableInt8 result, MutableBoolean maybeNumeric) {
        if (maybeNumeric != null) {
            maybeNumeric.setFalse();
        }
        byte[] bytes = textPtr.getByteArray();
        int offset = textPtr.getCharStartOffset();
        int value = 0;
        boolean positive = true;
        int limit = -127;
        if (bytes[offset] == 43) {
            ++offset;
        } else if (bytes[offset] == 45) {
            ++offset;
            positive = false;
            limit = -128;
        }
        int end = textPtr.getStartOffset() + textPtr.getLength();
        while (offset < end) {
            if (bytes[offset] < 48 || bytes[offset] > 57) {
                if (bytes[offset] == 105 && bytes[offset + 1] == 56 && offset + 2 == end) break;
                if (maybeNumeric != null) {
                    maybeNumeric.setValue(NumberUtils.isNumericNonDigitOrSignChar(bytes[offset]));
                }
                return false;
            }
            value = (byte)(value * 10);
            int digit = bytes[offset] - 48;
            if (value < limit + digit) {
                return false;
            }
            value = (byte)(value - digit);
            ++offset;
        }
        if (value > 0) {
            return false;
        }
        if (value < 0 && positive) {
            value = (byte)(value * -1);
        }
        result.setValue((byte)value);
        return true;
    }

    private NumberUtils() {
    }

    public static boolean isSameTypeNumericStrings(String value1, String value2) {
        if (NumberUtils.isNumericString(value1) && NumberUtils.isNumericString(value2)) {
            return NumberUtils.isIntegerNumericString(value1) == NumberUtils.isIntegerNumericString(value2);
        }
        return false;
    }

    public static boolean isNumericString(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public static boolean isIntegerNumericString(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private static boolean isNumericNonDigitOrSignChar(char v) {
        switch (v) {
            case '.': 
            case 'E': 
            case 'I': 
            case 'N': 
            case 'e': {
                return true;
            }
        }
        return false;
    }

    private static boolean isNumericNonDigitOrSignChar(byte v) {
        return NumberUtils.isNumericNonDigitOrSignChar((char)v);
    }
}

