/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

abstract class AbstractCurrentTemporalValueEval
extends AbstractScalarEval {
    protected final IEvaluatorContext ctx;
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final GregorianCalendarSystem cal = GregorianCalendarSystem.getInstance();
    private long jobStartTime = Long.MIN_VALUE;
    private ZoneId jobStartTimeZoneId;
    private ZoneRules jobStartTimeZoneRules;

    AbstractCurrentTemporalValueEval(IEvaluatorContext ctx, SourceLocation sourceLoc, FunctionIdentifier funcId) {
        super(sourceLoc, funcId);
        this.ctx = ctx;
    }

    protected final long getSystemCurrentTimeAsAdjustedChronon() throws HyracksDataException {
        return this.getChrononAdjusted(System.currentTimeMillis());
    }

    protected final long getJobStartTimeAsAdjustedChronon() throws HyracksDataException {
        return this.getChrononAdjusted(this.getJobStartTime());
    }

    private long getJobStartTime() throws HyracksDataException {
        if (this.jobStartTime == Long.MIN_VALUE) {
            IHyracksTaskContext taskCtx = this.ctx.getTaskContext();
            if (taskCtx == null) {
                throw new HyracksDataException(ErrorCode.ILLEGAL_STATE, this.srcLoc, new Serializable[]{"job-start-time"});
            }
            this.jobStartTime = taskCtx.getJobletContext().getJobStartTime();
        }
        return this.jobStartTime;
    }

    private void ensureJobStartTimeZone() throws HyracksDataException {
        if (this.jobStartTimeZoneId == null) {
            IHyracksTaskContext taskCtx = this.ctx.getTaskContext();
            if (taskCtx == null) {
                throw new HyracksDataException(ErrorCode.ILLEGAL_STATE, this.srcLoc, new Serializable[]{"job-start-timezone"});
            }
            try {
                this.jobStartTimeZoneId = ZoneId.of(taskCtx.getJobletContext().getJobStartTimeZoneId());
                this.jobStartTimeZoneRules = this.jobStartTimeZoneId.getRules();
            }
            catch (DateTimeException e) {
                throw new HyracksDataException(ErrorCode.ILLEGAL_STATE, (Throwable)e, this.srcLoc, new Serializable[]{"job-start-timezone"});
            }
        }
    }

    private long getChrononAdjusted(long chronon) throws HyracksDataException {
        this.ensureJobStartTimeZone();
        ZoneOffset tzOffset = this.jobStartTimeZoneRules.getOffset(Instant.ofEpochMilli(chronon));
        return this.cal.adjustChrononByTimezone(chronon, (int)(-TimeUnit.SECONDS.toMillis(tzOffset.getTotalSeconds())));
    }
}

