/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.projection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.types.visitor.SimpleStringBuilderForIATypeVisitor;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;

public class DataProjectionInfo
implements IProjectionInfo<ARecordType> {
    public static final ARecordType ALL_FIELDS_TYPE = DataProjectionInfo.createType("");
    public static final ARecordType EMPTY_TYPE = DataProjectionInfo.createType("{}");
    private final ARecordType root;
    private final Map<String, FunctionCallInformation> functionCallInfoMap;

    public DataProjectionInfo(ARecordType root, Map<String, FunctionCallInformation> sourceInformationMap) {
        this.root = root;
        this.functionCallInfoMap = sourceInformationMap;
    }

    private DataProjectionInfo(DataProjectionInfo other) {
        this.root = other.root == ALL_FIELDS_TYPE ? ALL_FIELDS_TYPE : (other.root == EMPTY_TYPE ? EMPTY_TYPE : other.root.deepCopy(other.root));
        this.functionCallInfoMap = new HashMap<String, FunctionCallInformation>(other.functionCallInfoMap);
    }

    public ARecordType getProjectionInfo() {
        return this.root;
    }

    public DataProjectionInfo createCopy() {
        return new DataProjectionInfo(this);
    }

    public Map<String, FunctionCallInformation> getFunctionCallInfoMap() {
        return this.functionCallInfoMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProjectionInfo otherInfo = (DataProjectionInfo)o;
        return this.root.deepEqual((IAObject)otherInfo.root) && Objects.equals(this.functionCallInfoMap, otherInfo.functionCallInfoMap);
    }

    public String toString() {
        if (this.root == ALL_FIELDS_TYPE || this.root == EMPTY_TYPE) {
            return this.root.getTypeName();
        }
        StringBuilder builder = new StringBuilder();
        SimpleStringBuilderForIATypeVisitor visitor = new SimpleStringBuilderForIATypeVisitor();
        this.root.accept((IATypeVisitor)visitor, (Object)builder);
        return builder.toString();
    }

    public static void writeTypeField(ARecordType expectedRecordType, DataOutput output) throws IOException {
        byte[] recordTypeBytes = SerializationUtils.serialize((Serializable)expectedRecordType);
        output.writeInt(recordTypeBytes.length);
        output.write(recordTypeBytes);
    }

    public static ARecordType createTypeField(DataInput input) throws IOException {
        int length = input.readInt();
        byte[] recordTypeBytes = new byte[length];
        input.readFully(recordTypeBytes, 0, length);
        return (ARecordType)SerializationUtils.deserialize((byte[])recordTypeBytes);
    }

    public static void writeFunctionCallInformationMapField(Map<String, FunctionCallInformation> functionCallInfoMap, DataOutput output) throws IOException {
        output.writeInt(functionCallInfoMap.size());
        for (Map.Entry<String, FunctionCallInformation> info : functionCallInfoMap.entrySet()) {
            output.writeUTF(info.getKey());
            info.getValue().writeFields(output);
        }
    }

    public static Map<String, FunctionCallInformation> createFunctionCallInformationMap(DataInput input) throws IOException {
        int size = input.readInt();
        HashMap<String, FunctionCallInformation> functionCallInfoMap = new HashMap<String, FunctionCallInformation>();
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            FunctionCallInformation functionCallInfo = FunctionCallInformation.create(input);
            functionCallInfoMap.put(key, functionCallInfo);
        }
        return functionCallInfoMap;
    }

    private static ARecordType createType(String typeName) {
        return new ARecordType(typeName, new String[0], new IAType[0], true);
    }
}

