/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LsmResource;
import org.apache.hyracks.storage.am.lsm.rtree.utils.LSMRTreeUtils;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IStorageManager;

public class LSMRTreeLocalResource
extends LsmResource {
    private static final long serialVersionUID = 1L;
    protected final IBinaryComparatorFactory[] btreeCmpFactories;
    protected final IPrimitiveValueProviderFactory[] valueProviderFactories;
    protected final RTreePolicyType rtreePolicyType;
    protected final ILinearizeComparatorFactory linearizeCmpFactory;
    protected final int[] rtreeFields;
    protected final int[] buddyBTreeFields;
    protected final boolean isPointMBR;
    protected final double bloomFilterFalsePositiveRate;

    public LSMRTreeLocalResource(String path, IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] rtreeCmpFactories, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory, IVirtualBufferCacheProvider vbcProvider, ILSMIOOperationSchedulerProvider ioSchedulerProvider, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, boolean durable, IBinaryComparatorFactory[] btreeCmpFactories, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, ILinearizeComparatorFactory linearizeCmpFactory, int[] rtreeFields, int[] buddyBTreeFields, boolean isPointMBR, double bloomFilterFalsePositiveRate, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        super(path, storageManager, typeTraits, rtreeCmpFactories, filterTypeTraits, filterCmpFactories, filterFields, opTrackerProvider, ioOpCallbackFactory, pageWriteCallbackFactory, metadataPageManagerFactory, vbcProvider, ioSchedulerProvider, mergePolicyFactory, mergePolicyProperties, durable, nullTypeTraits, nullIntrospector);
        this.btreeCmpFactories = btreeCmpFactories;
        this.valueProviderFactories = valueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
        this.linearizeCmpFactory = linearizeCmpFactory;
        this.rtreeFields = rtreeFields;
        this.buddyBTreeFields = buddyBTreeFields;
        this.isPointMBR = isPointMBR;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
    }

    protected LSMRTreeLocalResource(IPersistedResourceRegistry registry, JsonNode json, IBinaryComparatorFactory[] btreeCmpFactories, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, ILinearizeComparatorFactory linearizeCmpFactory, int[] rtreeFields, int[] buddyBTreeFields, boolean isPointMBR, double bloomFilterFalsePositiveRate) throws HyracksDataException {
        super(registry, json);
        this.btreeCmpFactories = btreeCmpFactories;
        this.valueProviderFactories = valueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
        this.linearizeCmpFactory = linearizeCmpFactory;
        this.rtreeFields = rtreeFields;
        this.buddyBTreeFields = buddyBTreeFields;
        this.isPointMBR = isPointMBR;
        this.bloomFilterFalsePositiveRate = bloomFilterFalsePositiveRate;
    }

    public IIndex createInstance(INCServiceContext ncServiceCtx) throws HyracksDataException {
        IIOManager ioManager = ncServiceCtx.getIoManager();
        FileReference fileRef = ioManager.resolve(this.path);
        List virtualBufferCaches = this.vbcProvider.getVirtualBufferCaches(ncServiceCtx, fileRef);
        this.ioOpCallbackFactory.initialize(ncServiceCtx, (IResource)this);
        this.pageWriteCallbackFactory.initialize(ncServiceCtx, (IResource)this);
        return LSMRTreeUtils.createLSMTree(ioManager, virtualBufferCaches, fileRef, this.storageManager.getBufferCache(ncServiceCtx), this.typeTraits, this.cmpFactories, this.btreeCmpFactories, this.valueProviderFactories, this.rtreePolicyType, this.bloomFilterFalsePositiveRate, this.mergePolicyFactory.createMergePolicy(this.mergePolicyProperties, ncServiceCtx), this.opTrackerProvider.getOperationTracker(ncServiceCtx, (IResource)this), this.ioSchedulerProvider.getIoScheduler(ncServiceCtx), this.ioOpCallbackFactory, this.pageWriteCallbackFactory, this.linearizeCmpFactory, this.rtreeFields, this.buddyBTreeFields, this.filterTypeTraits, this.filterCmpFactories, this.filterFields, this.durable, this.isPointMBR, this.metadataPageManagerFactory, this.nullTypeTraits, this.nullIntrospector);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode jsonObject = registry.getClassIdentifier(((Object)((Object)this)).getClass(), 1L);
        super.appendToJson(jsonObject, registry);
        return jsonObject;
    }

    protected void appendToJson(ObjectNode json, IPersistedResourceRegistry registry) throws HyracksDataException {
        super.appendToJson(json, registry);
        ArrayNode btreeCmpFactoriesArray = OBJECT_MAPPER.createArrayNode();
        for (IBinaryComparatorFactory factory : this.btreeCmpFactories) {
            btreeCmpFactoriesArray.add(factory.toJson(registry));
        }
        json.set("btreeCmpFactories", (JsonNode)btreeCmpFactoriesArray);
        json.set("linearizeCmpFactory", this.linearizeCmpFactory.toJson(registry));
        ArrayNode valueProviderFactoriesArray = OBJECT_MAPPER.createArrayNode();
        for (IPrimitiveValueProviderFactory factory : this.valueProviderFactories) {
            valueProviderFactoriesArray.add(factory.toJson(registry));
        }
        json.set("valueProviderFactories", (JsonNode)valueProviderFactoriesArray);
        json.set("rtreePolicyType", this.rtreePolicyType.toJson(registry));
        json.putPOJO("rtreeFields", (Object)this.rtreeFields);
        json.putPOJO("buddyBTreeFields", (Object)this.buddyBTreeFields);
        json.put("isPointMBR", this.isPointMBR);
        json.put("bloomFilterFalsePositiveRate", this.bloomFilterFalsePositiveRate);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        int[] buddyBTreeFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("buddyBTreeFields"), int[].class);
        int[] rtreeFields = (int[])OBJECT_MAPPER.convertValue((Object)json.get("rtreeFields"), int[].class);
        double bloomFilterFalsePositiveRate = json.get("bloomFilterFalsePositiveRate").asDouble();
        boolean isPointMBR = json.get("isPointMBR").asBoolean();
        RTreePolicyType rtreePolicyType = (RTreePolicyType)registry.deserialize(json.get("rtreePolicyType"));
        ILinearizeComparatorFactory linearizeCmpFactory = (ILinearizeComparatorFactory)registry.deserialize(json.get("linearizeCmpFactory"));
        ArrayList<IBinaryComparatorFactory> btreeCmpFactoriesList = new ArrayList<IBinaryComparatorFactory>();
        ArrayNode jsonBtreeCmpFactories = (ArrayNode)json.get("btreeCmpFactories");
        for (JsonNode cf : jsonBtreeCmpFactories) {
            btreeCmpFactoriesList.add((IBinaryComparatorFactory)registry.deserialize(cf));
        }
        IBinaryComparatorFactory[] btreeCmpFactories = btreeCmpFactoriesList.toArray(new IBinaryComparatorFactory[0]);
        ArrayList<IPrimitiveValueProviderFactory> valueProviderFactoriesList = new ArrayList<IPrimitiveValueProviderFactory>();
        ArrayNode jsonValueProviderFactories = (ArrayNode)json.get("valueProviderFactories");
        for (JsonNode cf : jsonValueProviderFactories) {
            valueProviderFactoriesList.add((IPrimitiveValueProviderFactory)registry.deserialize(cf));
        }
        IPrimitiveValueProviderFactory[] valueProviderFactories = valueProviderFactoriesList.toArray(new IPrimitiveValueProviderFactory[0]);
        return new LSMRTreeLocalResource(registry, json, btreeCmpFactories, valueProviderFactories, rtreePolicyType, linearizeCmpFactory, rtreeFields, buddyBTreeFields, isPointMBR, bloomFilterFalsePositiveRate);
    }
}

