/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AesCtrCryptoCodec
extends CryptoCodec {
    protected static final CipherSuite SUITE = CipherSuite.AES_CTR_NOPADDING;
    private static final int AES_BLOCK_SIZE = SUITE.getAlgorithmBlockSize();

    @Override
    public CipherSuite getCipherSuite() {
        return SUITE;
    }

    @Override
    public void calculateIV(byte[] initIV, long counter, byte[] IV) {
        Preconditions.checkArgument(initIV.length == AES_BLOCK_SIZE);
        Preconditions.checkArgument(IV.length == AES_BLOCK_SIZE);
        int i = IV.length;
        int j = 0;
        int sum = 0;
        while (i-- > 0) {
            sum = (initIV[i] & 0xFF) + (sum >>> 8);
            if (j++ < 8) {
                sum += (byte)counter & 0xFF;
                counter >>>= 8;
            }
            IV[i] = (byte)sum;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

