/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.FlatLedgerManagerFactory;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LedgerManagerFactory {
    static final Logger LOG = LoggerFactory.getLogger(LedgerManagerFactory.class);
    static final int V1 = 1;

    public abstract int getCurrentVersion();

    public abstract LedgerManagerFactory initialize(AbstractConfiguration var1, ZooKeeper var2, int var3) throws IOException;

    public abstract void uninitialize() throws IOException;

    public abstract LedgerIdGenerator newLedgerIdGenerator();

    public abstract LedgerManager newLedgerManager();

    public abstract LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws KeeperException, InterruptedException, ReplicationException.CompatibilityException;

    public static LedgerManagerFactory newLedgerManagerFactory(AbstractConfiguration conf, ZooKeeper zk) throws IOException, KeeperException, InterruptedException {
        Class<? extends LedgerManagerFactory> factoryClass;
        try {
            factoryClass = conf.getLedgerManagerFactoryClass();
        }
        catch (Exception e) {
            throw new IOException("Failed to get ledger manager factory class from configuration : ", e);
        }
        String ledgerRootPath = conf.getZkLedgersRootPath();
        if (null == ledgerRootPath || ledgerRootPath.length() == 0) {
            throw new IOException("Empty Ledger Root Path.");
        }
        if (zk == null) {
            return new FlatLedgerManagerFactory().initialize(conf, null, 1);
        }
        LedgerLayout layout = LedgerLayout.readLayout(zk, ledgerRootPath);
        if (layout == null) {
            LedgerManagerFactory lmFactory = LedgerManagerFactory.createNewLMFactory(conf, zk, factoryClass);
            return lmFactory.initialize(conf, zk, lmFactory.getCurrentVersion());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("read ledger layout {}", (Object)layout);
        }
        if (layout.getLayoutFormatVersion() <= 1) {
            LedgerManagerFactory lmFactory;
            String lmType = conf.getLedgerManagerType();
            if (lmType != null && !layout.getManagerFactoryClass().equals(lmType)) {
                throw new IOException("Configured layout " + lmType + " does not match existing layout " + layout.getManagerFactoryClass());
            }
            if ("flat".equals(layout.getManagerFactoryClass())) {
                lmFactory = new FlatLedgerManagerFactory();
            } else if ("hierarchical".equals(layout.getManagerFactoryClass())) {
                lmFactory = new HierarchicalLedgerManagerFactory();
            } else {
                throw new IOException("Unknown ledger manager type: " + lmType);
            }
            return ((LedgerManagerFactory)lmFactory).initialize(conf, zk, layout.getManagerVersion());
        }
        if (factoryClass != null && !layout.getManagerFactoryClass().equals(factoryClass.getName()) && conf.getProperty("ledgerManagerFactoryDisableClassCheck") == null) {
            throw new IOException("Configured layout " + factoryClass.getName() + " does not match existing layout " + layout.getManagerFactoryClass());
        }
        if (factoryClass == null) {
            try {
                Class<?> theCls = Class.forName(layout.getManagerFactoryClass());
                if (!LedgerManagerFactory.class.isAssignableFrom(theCls)) {
                    throw new IOException("Wrong ledger manager factory " + layout.getManagerFactoryClass());
                }
                factoryClass = theCls.asSubclass(LedgerManagerFactory.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Failed to instantiate ledger manager factory " + layout.getManagerFactoryClass());
            }
        }
        LedgerManagerFactory lmFactory = ReflectionUtils.newInstance(factoryClass);
        return lmFactory.initialize(conf, zk, layout.getManagerVersion());
    }

    private static LedgerManagerFactory createNewLMFactory(AbstractConfiguration conf, ZooKeeper zk, Class<? extends LedgerManagerFactory> factoryClass) throws IOException, KeeperException, InterruptedException {
        LedgerManagerFactory lmFactory;
        block11: {
            String ledgerRootPath = conf.getZkLedgersRootPath();
            if (factoryClass == null) {
                String lmType = conf.getLedgerManagerType();
                if (lmType == null) {
                    factoryClass = FlatLedgerManagerFactory.class;
                } else if ("flat".equals(lmType)) {
                    factoryClass = FlatLedgerManagerFactory.class;
                } else if ("hierarchical".equals(lmType)) {
                    factoryClass = HierarchicalLedgerManagerFactory.class;
                } else if ("longhierarchical".equals(lmType)) {
                    factoryClass = LongHierarchicalLedgerManagerFactory.class;
                } else {
                    throw new IOException("Unknown ledger manager type: " + lmType);
                }
            }
            lmFactory = ReflectionUtils.newInstance(factoryClass);
            LedgerLayout layout = new LedgerLayout(factoryClass.getName(), lmFactory.getCurrentVersion());
            List<ACL> zkAcls = ZkUtils.getACLs(conf);
            try {
                layout.store(zk, ledgerRootPath, zkAcls);
            }
            catch (KeeperException.NodeExistsException nee) {
                LedgerLayout layout2 = LedgerLayout.readLayout(zk, ledgerRootPath);
                if (layout2.equals(layout)) break block11;
                throw new IOException("Contention writing to layout to zookeeper,  other layout " + layout2 + " is incompatible with our layout " + layout);
            }
        }
        return lmFactory;
    }

    public void format(AbstractConfiguration conf, ZooKeeper zk) throws InterruptedException, KeeperException, IOException {
        Class<? extends LedgerManagerFactory> factoryClass;
        try {
            factoryClass = conf.getLedgerManagerFactoryClass();
        }
        catch (ConfigurationException e) {
            throw new IOException("Failed to get ledger manager factory class from configuration : ", e);
        }
        LedgerLayout layout = LedgerLayout.readLayout(zk, conf.getZkLedgersRootPath());
        layout.delete(zk, conf.getZkLedgersRootPath());
        LedgerManagerFactory.createNewLMFactory(conf, zk, factoryClass);
    }
}

