/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import bk-shade.com.google.common.collect.Sets;
import bk-shade.com.google.proto_2.6.1.ByteString;
import bk-shade.com.google.proto_2.6.1.ExtensionRegistry;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.bookkeeper.auth.BookKeeperPrincipal;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.AuthHandler;
import org.apache.bookkeeper.proto.BookieProtoEncoding;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.ClientConnectionPeer;
import org.apache.bookkeeper.proto.LocalBookiesRegistry;
import org.apache.bookkeeper.proto.PerChannelBookieClientPool;
import org.apache.bookkeeper.proto.ReadLastConfirmedAndEntryContext;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PerChannelBookieClient
extends ChannelInboundHandlerAdapter {
    static final Logger LOG = LoggerFactory.getLogger(PerChannelBookieClient.class);
    private static final Set<Integer> expectedBkOperationErrors = Collections.unmodifiableSet(Sets.newHashSet(-8, -13, -7, -101, -20, -22, -104));
    public static final AtomicLong txnIdGenerator = new AtomicLong(0L);
    final BookieSocketAddress addr;
    final EventLoopGroup eventLoopGroup;
    final OrderedSafeExecutor executor;
    final HashedWheelTimer requestTimer;
    final int addEntryTimeout;
    final int readEntryTimeout;
    final int maxFrameSize;
    final int getBookieInfoTimeout;
    final int startTLSTimeout;
    private final ConcurrentHashMap<CompletionKey, CompletionValue> completionObjects = new ConcurrentHashMap();
    private final StatsLogger statsLogger;
    private final OpStatsLogger readEntryOpLogger;
    private final OpStatsLogger readTimeoutOpLogger;
    private final OpStatsLogger addEntryOpLogger;
    private final OpStatsLogger writeLacOpLogger;
    private final OpStatsLogger readLacOpLogger;
    private final OpStatsLogger addTimeoutOpLogger;
    private final OpStatsLogger writeLacTimeoutOpLogger;
    private final OpStatsLogger readLacTimeoutOpLogger;
    private final OpStatsLogger getBookieInfoOpLogger;
    private final OpStatsLogger getBookieInfoTimeoutOpLogger;
    private final OpStatsLogger startTLSOpLogger;
    private final boolean useV2WireProtocol;
    private volatile Queue<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>> pendingOps = new ArrayDeque<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>>();
    volatile Channel channel = null;
    private final ClientConnectionPeer connectionPeer;
    private volatile BookKeeperPrincipal authorizedId = BookKeeperPrincipal.ANONYMOUS;
    volatile ConnectionState state;
    final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final ClientConfiguration conf;
    private final PerChannelBookieClientPool pcbcPool;
    private final ClientAuthProvider.Factory authProviderFactory;
    private final ExtensionRegistry extRegistry;
    private final SecurityHandlerFactory shFactory;

    public PerChannelBookieClient(OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr) throws SecurityException {
        this(new ClientConfiguration(), executor, eventLoopGroup, addr, null, (StatsLogger)NullStatsLogger.INSTANCE, null, null, null);
    }

    public PerChannelBookieClient(OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr, ClientAuthProvider.Factory authProviderFactory, ExtensionRegistry extRegistry) throws SecurityException {
        this(new ClientConfiguration(), executor, eventLoopGroup, addr, null, (StatsLogger)NullStatsLogger.INSTANCE, authProviderFactory, extRegistry, null);
    }

    public PerChannelBookieClient(ClientConfiguration conf, OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr, HashedWheelTimer requestTimer, StatsLogger parentStatsLogger, ClientAuthProvider.Factory authProviderFactory, ExtensionRegistry extRegistry, PerChannelBookieClientPool pcbcPool) throws SecurityException {
        this(conf, executor, eventLoopGroup, addr, null, (StatsLogger)NullStatsLogger.INSTANCE, authProviderFactory, extRegistry, pcbcPool, null);
    }

    public PerChannelBookieClient(ClientConfiguration conf, OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr, HashedWheelTimer requestTimer, StatsLogger parentStatsLogger, ClientAuthProvider.Factory authProviderFactory, ExtensionRegistry extRegistry, PerChannelBookieClientPool pcbcPool, SecurityHandlerFactory shFactory) throws SecurityException {
        this.maxFrameSize = conf.getNettyMaxFrameSizeBytes();
        this.conf = conf;
        this.addr = addr;
        this.executor = executor;
        this.eventLoopGroup = LocalBookiesRegistry.isLocalBookie(addr) ? new DefaultEventLoopGroup() : eventLoopGroup;
        this.state = ConnectionState.DISCONNECTED;
        this.requestTimer = requestTimer;
        this.addEntryTimeout = conf.getAddEntryTimeout();
        this.readEntryTimeout = conf.getReadEntryTimeout();
        this.getBookieInfoTimeout = conf.getBookieInfoTimeout();
        this.startTLSTimeout = conf.getStartTLSTimeout();
        this.useV2WireProtocol = conf.getUseV2WireProtocol();
        this.authProviderFactory = authProviderFactory;
        this.extRegistry = extRegistry;
        this.shFactory = shFactory;
        if (shFactory != null) {
            shFactory.init(SecurityHandlerFactory.NodeType.Client, conf);
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(addr.getHostName().replace('.', '_').replace('-', '_')).append("_").append(addr.getPort());
        this.statsLogger = parentStatsLogger.scope("per_channel_bookie_client").scope(nameBuilder.toString());
        this.readEntryOpLogger = this.statsLogger.getOpStatsLogger("READ_ENTRY");
        this.addEntryOpLogger = this.statsLogger.getOpStatsLogger("ADD_ENTRY");
        this.writeLacOpLogger = this.statsLogger.getOpStatsLogger("WRITE_LAC");
        this.readLacOpLogger = this.statsLogger.getOpStatsLogger("READ_LAC");
        this.getBookieInfoOpLogger = this.statsLogger.getOpStatsLogger("GET_BOOKIE_INFO");
        this.readTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_READ_ENTRY");
        this.addTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_ADD_ENTRY");
        this.writeLacTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_WRITE_LAC");
        this.readLacTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_READ_LAC");
        this.getBookieInfoTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_GET_BOOKIE_INFO");
        this.startTLSOpLogger = this.statsLogger.getOpStatsLogger("START_TLS");
        this.pcbcPool = pcbcPool;
        this.connectionPeer = new ClientConnectionPeer(){

            @Override
            public SocketAddress getRemoteAddr() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null) {
                    return c.remoteAddress();
                }
                return null;
            }

            @Override
            public Collection<Object> getProtocolPrincipals() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c == null) {
                    return Collections.emptyList();
                }
                SslHandler ssl = (SslHandler)c.pipeline().get(SslHandler.class);
                if (ssl == null) {
                    return Collections.emptyList();
                }
                try {
                    Certificate[] certificates = ssl.engine().getSession().getPeerCertificates();
                    if (certificates == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<Object> result = new ArrayList<Object>();
                    result.addAll(Arrays.asList(certificates));
                    return result;
                }
                catch (SSLPeerUnverifiedException err) {
                    return Collections.emptyList();
                }
            }

            @Override
            public void disconnect() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null) {
                    c.close();
                }
                LOG.info("authplugin disconnected channel {}", (Object)PerChannelBookieClient.this.channel);
            }

            @Override
            public void setAuthorizedId(BookKeeperPrincipal principal) {
                PerChannelBookieClient.this.authorizedId = principal;
                LOG.info("connection {} authenticated as {}", (Object)PerChannelBookieClient.this.channel, (Object)principal);
            }

            @Override
            public BookKeeperPrincipal getAuthorizedId() {
                return PerChannelBookieClient.this.authorizedId;
            }

            @Override
            public boolean isSecure() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c == null) {
                    return false;
                }
                return c.pipeline().get(SslHandler.class) != null;
            }
        };
    }

    private void completeOperation(BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> op, int rc) {
        this.closeLock.readLock().lock();
        try {
            if (ConnectionState.CLOSED == this.state) {
                op.operationComplete(-19, this);
            } else {
                op.operationComplete(rc, this);
            }
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    protected ChannelFuture connect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting to bookie: {}", (Object)this.addr);
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.eventLoopGroup);
        if (this.eventLoopGroup instanceof EpollEventLoopGroup) {
            bootstrap.channel(EpollSocketChannel.class);
        } else if (this.eventLoopGroup instanceof DefaultEventLoopGroup) {
            bootstrap.channel(LocalChannel.class);
        } else {
            bootstrap.channel(NioSocketChannel.class);
        }
        Object allocator = this.conf.isNettyUsePooledBuffers() ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        bootstrap.option(ChannelOption.ALLOCATOR, allocator);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.conf.getClientConnectTimeoutMillis());
        bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.conf.getClientWriteBufferLowWaterMark(), this.conf.getClientWriteBufferHighWaterMark()));
        if (!(this.eventLoopGroup instanceof DefaultEventLoopGroup)) {
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.conf.getClientTcpNoDelay());
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.conf.getClientSockKeepalive());
            if (this.conf.getClientSendBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.conf.getClientSendBufferSize());
            }
            if (this.conf.getClientReceiveBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.conf.getClientReceiveBufferSize());
            }
        }
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("lengthbasedframedecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(PerChannelBookieClient.this.maxFrameSize, 0, 4, 0, 4));
                pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("bookieProtoEncoder", (ChannelHandler)new BookieProtoEncoding.RequestEncoder(PerChannelBookieClient.this.extRegistry));
                pipeline.addLast("bookieProtoDecoder", (ChannelHandler)new BookieProtoEncoding.ResponseDecoder(PerChannelBookieClient.this.extRegistry));
                pipeline.addLast("authHandler", (ChannelHandler)new AuthHandler.ClientSideHandler(PerChannelBookieClient.this.authProviderFactory, txnIdGenerator, PerChannelBookieClient.this.connectionPeer));
                pipeline.addLast("mainhandler", (ChannelHandler)PerChannelBookieClient.this);
            }
        });
        InetSocketAddress bookieAddr = this.addr.getSocketAddress();
        if (this.eventLoopGroup instanceof DefaultEventLoopGroup) {
            bookieAddr = this.addr.getLocalAddress();
        }
        ChannelFuture future = bootstrap.connect((SocketAddress)bookieAddr);
        future.addListener((GenericFutureListener)new ConnectionFutureListener());
        return future;
    }

    void cleanDisconnectAndClose() {
        this.disconnect();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectIfNeededAndDoOp(BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> op) {
        boolean completeOpNow = false;
        int opRc = 0;
        if (this.channel != null && this.state == ConnectionState.CONNECTED) {
            completeOpNow = true;
        } else {
            PerChannelBookieClient perChannelBookieClient = this;
            synchronized (perChannelBookieClient) {
                if (this.channel != null && this.state == ConnectionState.CONNECTED) {
                    completeOpNow = true;
                    opRc = 0;
                } else if (this.state == ConnectionState.CLOSED) {
                    completeOpNow = true;
                    opRc = -8;
                } else {
                    this.pendingOps.add(op);
                    if (this.state == ConnectionState.CONNECTING || this.state == ConnectionState.START_TLS) {
                        return;
                    }
                    this.state = ConnectionState.CONNECTING;
                }
            }
            if (!completeOpNow) {
                this.connect();
            }
        }
        if (completeOpNow) {
            this.completeOperation(op, opRc);
        }
    }

    void writeLac(final long ledgerId, byte[] masterKey, long lac, ByteBuf toSend, BookkeeperInternalCallbacks.WriteLacCallback cb, Object ctx) {
        long txnId = this.getTxnId();
        final V3CompletionKey completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.WRITE_LAC);
        this.completionObjects.put(completionKey, new WriteLacCompletion(this.writeLacOpLogger, cb, ctx, lac, this.scheduleTimeout(completionKey, this.addEntryTimeout)));
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.WRITE_LAC).setTxnId(txnId);
        BookkeeperProtocol.WriteLacRequest.Builder writeLacBuilder = BookkeeperProtocol.WriteLacRequest.newBuilder().setLedgerId(ledgerId).setLac(lac).setMasterKey(ByteString.copyFrom(masterKey)).setBody(ByteString.copyFrom(toSend.nioBuffer()));
        BookkeeperProtocol.Request writeLacRequest = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setWriteLacRequest(writeLacBuilder).build();
        final Channel c = this.channel;
        if (c == null) {
            this.errorOutWriteLacKey(completionKey);
            return;
        }
        try {
            ChannelFuture future = c.writeAndFlush((Object)writeLacRequest);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully wrote request for writeLac LedgerId: {} bookie: {}", (Object)ledgerId, (Object)c.remoteAddress());
                        }
                    } else {
                        if (!(future.cause() instanceof ClosedChannelException)) {
                            LOG.warn("Writing Lac(lid={} to channel {} failed : ", new Object[]{ledgerId, c, future.cause()});
                        }
                        PerChannelBookieClient.this.errorOutWriteLacKey(completionKey);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("writeLac operation failed", e);
            this.errorOutWriteLacKey(completionKey);
        }
    }

    void addEntry(final long ledgerId, byte[] masterKey, final long entryId, ByteBuf toSend, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, int options) {
        Object request = null;
        CompletionKey completion = null;
        if (this.useV2WireProtocol) {
            completion = new V2CompletionKey(ledgerId, entryId, BookkeeperProtocol.OperationType.ADD_ENTRY);
            request = new BookieProtocol.AddRequest(2, ledgerId, entryId, (short)options, masterKey, toSend);
        } else {
            long txnId = this.getTxnId();
            completion = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.ADD_ENTRY);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).setTxnId(txnId);
            byte[] toSendArray = new byte[toSend.readableBytes()];
            toSend.getBytes(toSend.readerIndex(), toSendArray);
            BookkeeperProtocol.AddRequest.Builder addBuilder = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(ledgerId).setEntryId(entryId).setMasterKey(ByteString.copyFrom(masterKey)).setBody(ByteString.copyFrom(toSendArray));
            if (((short)options & 2) == 2) {
                addBuilder.setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD);
            }
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setAddRequest(addBuilder).build();
        }
        BookieProtocol.AddRequest addRequest = request;
        final CompletionKey completionKey = completion;
        this.completionObjects.put(completionKey, new AddCompletion(this, this.addEntryOpLogger, cb, ctx, ledgerId, entryId, this.scheduleTimeout(completion, this.addEntryTimeout)));
        final int entrySize = toSend.readableBytes();
        final Channel c = this.channel;
        if (c == null) {
            this.errorOutAddKey(completionKey);
            toSend.release();
            return;
        }
        try {
            ChannelFuture future = c.writeAndFlush((Object)addRequest);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully wrote request for adding entry: " + entryId + " ledger-id: " + ledgerId + " bookie: " + c.remoteAddress() + " entry length: " + entrySize);
                        }
                    } else {
                        if (!(future.cause() instanceof ClosedChannelException)) {
                            LOG.warn("Writing addEntry(lid={}, eid={}) to channel {} failed : ", new Object[]{ledgerId, entryId, c, future.cause()});
                        }
                        PerChannelBookieClient.this.errorOutAddKey(completionKey);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Add entry operation failed", e);
            this.errorOutAddKey(completionKey);
        }
    }

    public void readEntryAndFenceLedger(final long ledgerId, byte[] masterKey, final long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        Object request = null;
        CompletionKey completion = null;
        if (this.useV2WireProtocol) {
            completion = new V2CompletionKey(ledgerId, entryId, BookkeeperProtocol.OperationType.READ_ENTRY);
            request = new BookieProtocol.ReadRequest(2, ledgerId, entryId, 1, masterKey);
        } else {
            long txnId = this.getTxnId();
            completion = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.READ_ENTRY);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.READ_ENTRY).setTxnId(txnId);
            BookkeeperProtocol.ReadRequest.Builder readBuilder = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(ledgerId).setEntryId(entryId).setMasterKey(ByteString.copyFrom(masterKey)).setFlag(BookkeeperProtocol.ReadRequest.Flag.FENCE_LEDGER);
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setReadRequest(readBuilder).build();
        }
        final CompletionKey completionKey = completion;
        if (this.completionObjects.putIfAbsent(completionKey, new ReadCompletion(this, this.readEntryOpLogger, cb, ctx, ledgerId, entryId, this.scheduleTimeout(completionKey, this.readEntryTimeout))) != null) {
            cb.readEntryComplete(-8, ledgerId, entryId, null, ctx);
            return;
        }
        final Channel c = this.channel;
        if (c == null) {
            this.errorOutReadKey(completionKey);
            return;
        }
        final Object readRequest = request;
        try {
            ChannelFuture future = c.writeAndFlush(readRequest);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully wrote request {} to {}", readRequest, (Object)c.remoteAddress());
                        }
                    } else {
                        if (!(future.cause() instanceof ClosedChannelException)) {
                            LOG.warn("Writing readEntryAndFenceLedger(lid={}, eid={}) to channel {} failed : ", new Object[]{ledgerId, entryId, c, future.cause()});
                        }
                        PerChannelBookieClient.this.errorOutReadKey(completionKey);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Read entry operation {} failed", (Object)completionKey, (Object)e);
            this.errorOutReadKey(completionKey);
        }
    }

    public void readLac(final long ledgerId, BookkeeperInternalCallbacks.ReadLacCallback cb, Object ctx) {
        Object request = null;
        CompletionKey completion = null;
        if (this.useV2WireProtocol) {
            request = new BookieProtocol.ReadRequest(2, ledgerId, 0L, 0);
            completion = new V2CompletionKey(ledgerId, 0L, BookkeeperProtocol.OperationType.READ_LAC);
        } else {
            long txnId = this.getTxnId();
            completion = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.READ_LAC);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.READ_LAC).setTxnId(txnId);
            BookkeeperProtocol.ReadLacRequest.Builder readLacBuilder = BookkeeperProtocol.ReadLacRequest.newBuilder().setLedgerId(ledgerId);
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setReadLacRequest(readLacBuilder).build();
        }
        final BookieProtocol.ReadRequest readLacRequest = request;
        final CompletionKey completionKey = completion;
        this.completionObjects.put(completionKey, new ReadLacCompletion(this.readLacOpLogger, cb, ctx, ledgerId, this.scheduleTimeout(completionKey, this.readEntryTimeout)));
        final Channel c = this.channel;
        if (c == null) {
            this.errorOutReadLacKey(completionKey);
            return;
        }
        try {
            ChannelFuture future = c.writeAndFlush((Object)readLacRequest);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Succssfully wrote request {} to {}", readLacRequest, (Object)c.remoteAddress());
                        }
                    } else {
                        if (!(future.cause() instanceof ClosedChannelException)) {
                            LOG.warn("Writing readLac(lid = {}) to channel {} failed : ", new Object[]{ledgerId, c, future.cause()});
                        }
                        PerChannelBookieClient.this.errorOutReadLacKey(completionKey);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Read LAC operation {} failed", (Object)readLacRequest, (Object)e);
            this.errorOutReadLacKey(completionKey);
        }
    }

    public void readEntryWaitForLACUpdate(long ledgerId, long entryId, long previousLAC, long timeOutInMillis, boolean piggyBackEntry, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        this.readEntryInternal(ledgerId, entryId, previousLAC, timeOutInMillis, piggyBackEntry, cb, ctx);
    }

    public void readEntry(long ledgerId, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        this.readEntryInternal(ledgerId, entryId, null, null, false, cb, ctx);
    }

    private void readEntryInternal(final long ledgerId, final long entryId, Long previousLAC, Long timeOutInMillis, boolean piggyBackEntry, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        Object request = null;
        CompletionKey completion = null;
        if (this.useV2WireProtocol) {
            request = new BookieProtocol.ReadRequest(2, ledgerId, entryId, 0);
            completion = new V2CompletionKey(ledgerId, entryId, BookkeeperProtocol.OperationType.READ_ENTRY);
        } else {
            long txnId = this.getTxnId();
            completion = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.READ_ENTRY);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.READ_ENTRY).setTxnId(txnId);
            BookkeeperProtocol.ReadRequest.Builder readBuilder = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(ledgerId).setEntryId(entryId);
            if (null != previousLAC) {
                readBuilder = readBuilder.setPreviousLAC(previousLAC);
            }
            if (null != timeOutInMillis) {
                if (null == previousLAC) {
                    cb.readEntryComplete(-14, ledgerId, entryId, null, ctx);
                    return;
                }
                readBuilder = readBuilder.setTimeOut(timeOutInMillis);
            }
            if (piggyBackEntry) {
                if (null == previousLAC) {
                    cb.readEntryComplete(-14, ledgerId, entryId, null, ctx);
                    return;
                }
                readBuilder = readBuilder.setFlag(BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK);
            }
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setReadRequest(readBuilder).build();
        }
        final BookieProtocol.ReadRequest readRequest = request;
        final CompletionKey completionKey = completion;
        this.completionObjects.put(completionKey, new ReadCompletion(this, this.readEntryOpLogger, cb, ctx, ledgerId, entryId, this.scheduleTimeout(completionKey, this.readEntryTimeout)));
        final Channel c = this.channel;
        if (c == null) {
            this.errorOutReadKey(completionKey);
            return;
        }
        try {
            ChannelFuture future = c.writeAndFlush((Object)readRequest);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully wrote request {} to {}", readRequest, (Object)c.remoteAddress());
                        }
                    } else {
                        if (!(future.cause() instanceof ClosedChannelException)) {
                            LOG.warn("Writing readEntry(lid={}, eid={}) to channel {} failed : ", new Object[]{ledgerId, entryId, c, future.cause()});
                        }
                        PerChannelBookieClient.this.errorOutReadKey(completionKey);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Read entry operation {} failed", (Object)readRequest, (Object)e);
            this.errorOutReadKey(completionKey);
        }
    }

    public void getBookieInfo(final long requested, BookkeeperInternalCallbacks.GetBookieInfoCallback cb, Object ctx) {
        long txnId = this.getTxnId();
        final V3CompletionKey completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.GET_BOOKIE_INFO);
        this.completionObjects.put(completionKey, new GetBookieInfoCompletion(this, this.getBookieInfoOpLogger, cb, ctx, this.scheduleTimeout(completionKey, this.getBookieInfoTimeout)));
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.GET_BOOKIE_INFO).setTxnId(txnId);
        BookkeeperProtocol.GetBookieInfoRequest.Builder getBookieInfoBuilder = BookkeeperProtocol.GetBookieInfoRequest.newBuilder().setRequested(requested);
        final BookkeeperProtocol.Request getBookieInfoRequest = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setGetBookieInfoRequest(getBookieInfoBuilder).build();
        final Channel c = this.channel;
        if (c == null) {
            this.errorOutGetBookieInfoKey(completionKey);
            return;
        }
        try {
            ChannelFuture future = c.writeAndFlush((Object)getBookieInfoRequest);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully wrote request {} to {}", (Object)getBookieInfoRequest, (Object)c.remoteAddress());
                        }
                    } else {
                        if (!(future.cause() instanceof ClosedChannelException)) {
                            LOG.warn("Writing GetBookieInfoRequest(flags={}) to channel {} failed : ", new Object[]{requested, c, future.cause()});
                        }
                        PerChannelBookieClient.this.errorOutGetBookieInfoKey(completionKey);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Get metadata operation {} failed", (Object)getBookieInfoRequest, (Object)e);
            this.errorOutGetBookieInfoKey(completionKey);
        }
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean wait) {
        LOG.info("Disconnecting the per channel bookie client for {}", (Object)this.addr);
        this.closeInternal(false, wait);
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean wait) {
        LOG.info("Closing the per channel bookie client for {}", (Object)this.addr);
        this.closeLock.writeLock().lock();
        try {
            if (ConnectionState.CLOSED == this.state) {
                return;
            }
            this.state = ConnectionState.CLOSED;
            this.errorOutOutstandingEntries(-19);
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.closeInternal(true, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean permanent, boolean wait) {
        Channel toClose = null;
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            if (permanent) {
                this.state = ConnectionState.CLOSED;
            } else if (this.state != ConnectionState.CLOSED) {
                this.state = ConnectionState.DISCONNECTED;
            }
            toClose = this.channel;
            this.channel = null;
        }
        if (toClose != null) {
            ChannelFuture cf = this.closeChannel(toClose);
            if (wait) {
                cf.awaitUninterruptibly();
            }
        }
    }

    private ChannelFuture closeChannel(Channel c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing channel {}", (Object)c);
        }
        return c.close();
    }

    void errorStartTLS(int rc) {
        this.failTLS(rc);
    }

    void errorOutReadKey(CompletionKey key) {
        this.errorOutReadKey(key, -8);
    }

    void errorOutReadKey(final CompletionKey key, final int rc) {
        ReadCompletion readCompletion;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing completion key: {}", (Object)key);
        }
        if (null == (readCompletion = (ReadCompletion)this.completionObjects.remove(key))) {
            return;
        }
        this.executor.submitOrdered(readCompletion.ledgerId, new SafeRunnable(){

            @Override
            public void safeRun() {
                String bAddress = "null";
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null && c.remoteAddress() != null) {
                    bAddress = c.remoteAddress().toString();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not write request for reading entry: {} ledger-id: {} bookie: {} rc: {}", new Object[]{readCompletion.entryId, readCompletion.ledgerId, bAddress, rc});
                }
                readCompletion.cb.readEntryComplete(rc, readCompletion.ledgerId, readCompletion.entryId, null, readCompletion.ctx);
            }

            public String toString() {
                return String.format("ErrorOutReadKey(%s)", key);
            }
        });
    }

    void errorOutWriteLacKey(CompletionKey key) {
        this.errorOutWriteLacKey(key, -8);
    }

    void errorOutWriteLacKey(CompletionKey key, final int rc) {
        WriteLacCompletion writeLacCompletion;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing completion key: {}", (Object)key);
        }
        if (null == (writeLacCompletion = (WriteLacCompletion)this.completionObjects.remove(key))) {
            return;
        }
        this.executor.submitOrdered(writeLacCompletion.ledgerId, new SafeRunnable(){

            @Override
            public void safeRun() {
                String bAddress = "null";
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null) {
                    bAddress = c.remoteAddress().toString();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not write request writeLac for ledgerId: {} bookie: {}", (Object)writeLacCompletion.ledgerId, (Object)bAddress);
                }
                writeLacCompletion.cb.writeLacComplete(rc, writeLacCompletion.ledgerId, PerChannelBookieClient.this.addr, writeLacCompletion.ctx);
            }
        });
    }

    void errorOutReadLacKey(CompletionKey key) {
        this.errorOutReadLacKey(key, -8);
    }

    void errorOutReadLacKey(CompletionKey key, final int rc) {
        ReadLacCompletion readLacCompletion;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing completion key: {}", (Object)key);
        }
        if (null == (readLacCompletion = (ReadLacCompletion)this.completionObjects.remove(key))) {
            return;
        }
        this.executor.submitOrdered(readLacCompletion.ledgerId, new SafeRunnable(){

            @Override
            public void safeRun() {
                String bAddress = "null";
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null) {
                    bAddress = c.remoteAddress().toString();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not write request readLac for ledgerId: {} bookie: {}", (Object)readLacCompletion.ledgerId, (Object)bAddress);
                }
                readLacCompletion.cb.readLacComplete(rc, readLacCompletion.ledgerId, null, null, readLacCompletion.ctx);
            }
        });
    }

    void errorOutAddKey(CompletionKey key) {
        this.errorOutAddKey(key, -8);
    }

    void errorOutAddKey(final CompletionKey key, final int rc) {
        final AddCompletion addCompletion = (AddCompletion)this.completionObjects.remove(key);
        if (null == addCompletion) {
            return;
        }
        this.executor.submitOrdered(addCompletion.ledgerId, new SafeRunnable(){

            @Override
            public void safeRun() {
                String bAddress = "null";
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null && c.remoteAddress() != null) {
                    bAddress = c.remoteAddress().toString();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not write request for adding entry: {} ledger-id: {} bookie: {} rc: {}", new Object[]{addCompletion.entryId, addCompletion.ledgerId, bAddress, rc});
                }
                addCompletion.cb.writeComplete(rc, addCompletion.ledgerId, addCompletion.entryId, PerChannelBookieClient.this.addr, addCompletion.ctx);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invoked callback method: {}", (Object)addCompletion.entryId);
                }
            }

            public String toString() {
                return String.format("ErrorOutAddKey(%s)", key);
            }
        });
    }

    void errorOutGetBookieInfoKey(CompletionKey key) {
        this.errorOutGetBookieInfoKey(key, -8);
    }

    void errorOutGetBookieInfoKey(CompletionKey key, final int rc) {
        final GetBookieInfoCompletion getBookieInfoCompletion = (GetBookieInfoCompletion)this.completionObjects.remove(key);
        if (null == getBookieInfoCompletion) {
            return;
        }
        this.executor.submit(new SafeRunnable(){

            @Override
            public void safeRun() {
                String bAddress = "null";
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null) {
                    bAddress = c.remoteAddress().toString();
                }
                LOG.debug("Could not write getBookieInfo request for bookie: {}", new Object[]{bAddress});
                getBookieInfoCompletion.cb.getBookieInfoComplete(rc, new BookieInfoReader.BookieInfo(), getBookieInfoCompletion.ctx);
            }
        });
    }

    void errorOutOutstandingEntries(int rc) {
        for (CompletionKey key : this.completionObjects.keySet()) {
            switch (key.operationType) {
                case ADD_ENTRY: {
                    this.errorOutAddKey(key, rc);
                    break;
                }
                case READ_ENTRY: {
                    this.errorOutReadKey(key, rc);
                    break;
                }
                case GET_BOOKIE_INFO: {
                    this.errorOutGetBookieInfoKey(key, rc);
                    break;
                }
                case START_TLS: {
                    this.errorStartTLS(rc);
                    break;
                }
            }
        }
    }

    void recordError() {
        if (this.pcbcPool != null) {
            this.pcbcPool.recordError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("Disconnected from bookie channel {}", (Object)ctx.channel());
        if (ctx.channel() != null) {
            this.closeChannel(ctx.channel());
        }
        this.errorOutOutstandingEntries(-8);
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            if (this.channel == ctx.channel() && this.state != ConnectionState.CLOSED) {
                this.state = ConnectionState.DISCONNECTED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof CorruptedFrameException || cause instanceof TooLongFrameException) {
            LOG.error("Corrupted frame received from bookie: {}", (Object)ctx.channel().remoteAddress());
            ctx.close();
            return;
        }
        if (cause instanceof AuthHandler.AuthenticationException) {
            LOG.error("Error authenticating connection", cause);
            this.errorOutOutstandingEntries(-102);
            Channel c = ctx.channel();
            if (c != null) {
                this.closeChannel(c);
            }
            return;
        }
        if (cause instanceof IOException) {
            ctx.close();
            return;
        }
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            if (this.state == ConnectionState.CLOSED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unexpected exception caught by bookie client channel handler, but the client is closed, so it isn't important", cause);
                }
            } else {
                LOG.error("Unexpected exception caught by bookie client channel handler", cause);
            }
        }
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof BookieProtocol.Response) {
            BookieProtocol.Response response = (BookieProtocol.Response)msg;
            this.readV2Response(response);
        } else if (msg instanceof BookkeeperProtocol.Response) {
            BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)msg;
            this.readV3Response(response);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readV2Response(final BookieProtocol.Response response) {
        final long ledgerId = response.ledgerId;
        final long entryId = response.entryId;
        final BookkeeperProtocol.OperationType operationType = this.getOperationType(response.getOpCode());
        final BookkeeperProtocol.StatusCode status = this.getStatusCodeFromErrorCode(response.errorCode);
        final CompletionValue completionValue = this.completionObjects.remove(new V2CompletionKey(ledgerId, entryId, operationType));
        if (null == completionValue) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unexpected response received from bookie : " + this.addr + " for type : " + operationType + " and ledger:entry : " + ledgerId + ":" + entryId);
            }
        } else {
            long orderingKey = completionValue.ledgerId;
            this.executor.submitOrdered(orderingKey, new SafeRunnable(){

                @Override
                public void safeRun() {
                    switch (operationType) {
                        case ADD_ENTRY: {
                            PerChannelBookieClient.this.handleAddResponse(ledgerId, entryId, status, completionValue);
                            break;
                        }
                        case READ_ENTRY: {
                            BookieProtocol.ReadResponse readResponse = (BookieProtocol.ReadResponse)response;
                            ByteBuf data = null;
                            if (readResponse.hasData()) {
                                data = readResponse.getData();
                            }
                            PerChannelBookieClient.this.handleReadResponse(ledgerId, entryId, status, data, -1L, -1L, completionValue);
                            break;
                        }
                        default: {
                            LOG.error("Unexpected response, type:{} received from bookie:{}, ignoring", (Object)operationType, (Object)PerChannelBookieClient.this.addr);
                        }
                    }
                }
            });
        }
    }

    private BookkeeperProtocol.StatusCode getStatusCodeFromErrorCode(int errorCode) {
        switch (errorCode) {
            case 0: {
                return BookkeeperProtocol.StatusCode.EOK;
            }
            case 1: {
                return BookkeeperProtocol.StatusCode.ENOLEDGER;
            }
            case 2: {
                return BookkeeperProtocol.StatusCode.ENOENTRY;
            }
            case 100: {
                return BookkeeperProtocol.StatusCode.EBADREQ;
            }
            case 101: {
                return BookkeeperProtocol.StatusCode.EIO;
            }
            case 102: {
                return BookkeeperProtocol.StatusCode.EUA;
            }
            case 103: {
                return BookkeeperProtocol.StatusCode.EBADVERSION;
            }
            case 104: {
                return BookkeeperProtocol.StatusCode.EFENCED;
            }
            case 105: {
                return BookkeeperProtocol.StatusCode.EREADONLY;
            }
        }
        throw new IllegalArgumentException("Invalid error code: " + errorCode);
    }

    private BookkeeperProtocol.OperationType getOperationType(byte opCode) {
        switch (opCode) {
            case 1: {
                return BookkeeperProtocol.OperationType.ADD_ENTRY;
            }
            case 2: {
                return BookkeeperProtocol.OperationType.READ_ENTRY;
            }
            case 3: {
                return BookkeeperProtocol.OperationType.AUTH;
            }
            case 4: {
                return BookkeeperProtocol.OperationType.READ_LAC;
            }
            case 5: {
                return BookkeeperProtocol.OperationType.WRITE_LAC;
            }
            case 6: {
                return BookkeeperProtocol.OperationType.GET_BOOKIE_INFO;
            }
        }
        throw new IllegalArgumentException("Invalid operation type");
    }

    private void readV3Response(final BookkeeperProtocol.Response response) {
        final BookkeeperProtocol.BKPacketHeader header = response.getHeader();
        final CompletionValue completionValue = this.completionObjects.remove(this.newCompletionKey(header.getTxnId(), header.getOperation()));
        if (null == completionValue) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unexpected response received from bookie : " + this.addr + " for type : " + header.getOperation() + " and txnId : " + header.getTxnId());
            }
        } else {
            long orderingKey = completionValue.ledgerId;
            this.executor.submitOrdered(orderingKey, new SafeRunnable(){

                @Override
                public void safeRun() {
                    BookkeeperProtocol.OperationType type = header.getOperation();
                    switch (type) {
                        case ADD_ENTRY: {
                            BookkeeperProtocol.AddResponse addResponse = response.getAddResponse();
                            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? addResponse.getStatus() : response.getStatus();
                            PerChannelBookieClient.this.handleAddResponse(addResponse.getLedgerId(), addResponse.getEntryId(), status, completionValue);
                            break;
                        }
                        case READ_ENTRY: {
                            BookkeeperProtocol.ReadResponse readResponse = response.getReadResponse();
                            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? readResponse.getStatus() : response.getStatus();
                            ByteBuf buffer = Unpooled.EMPTY_BUFFER;
                            if (readResponse.hasBody()) {
                                buffer = Unpooled.wrappedBuffer((ByteBuffer)readResponse.getBody().asReadOnlyByteBuffer());
                            }
                            long maxLAC = -1L;
                            if (readResponse.hasMaxLAC()) {
                                maxLAC = readResponse.getMaxLAC();
                            }
                            long lacUpdateTimestamp = -1L;
                            if (readResponse.hasLacUpdateTimestamp()) {
                                lacUpdateTimestamp = readResponse.getLacUpdateTimestamp();
                            }
                            PerChannelBookieClient.this.handleReadResponse(readResponse.getLedgerId(), readResponse.getEntryId(), status, buffer, maxLAC, lacUpdateTimestamp, completionValue);
                            break;
                        }
                        case WRITE_LAC: {
                            BookkeeperProtocol.WriteLacResponse writeLacResponse = response.getWriteLacResponse();
                            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? writeLacResponse.getStatus() : response.getStatus();
                            PerChannelBookieClient.this.handleWriteLacResponse(writeLacResponse.getLedgerId(), status, completionValue);
                            break;
                        }
                        case READ_LAC: {
                            BookkeeperProtocol.StatusCode status;
                            BookkeeperProtocol.ReadLacResponse readLacResponse = response.getReadLacResponse();
                            ByteBuf lacBuffer = Unpooled.EMPTY_BUFFER;
                            ByteBuf lastEntryBuffer = Unpooled.EMPTY_BUFFER;
                            BookkeeperProtocol.StatusCode statusCode = status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? readLacResponse.getStatus() : response.getStatus();
                            if (readLacResponse.hasLacBody()) {
                                lacBuffer = Unpooled.wrappedBuffer((ByteBuffer)readLacResponse.getLacBody().asReadOnlyByteBuffer());
                            }
                            if (readLacResponse.hasLastEntryBody()) {
                                lastEntryBuffer = Unpooled.wrappedBuffer((ByteBuffer)readLacResponse.getLastEntryBody().asReadOnlyByteBuffer());
                            }
                            PerChannelBookieClient.this.handleReadLacResponse(readLacResponse.getLedgerId(), status, lacBuffer, lastEntryBuffer, completionValue);
                            break;
                        }
                        case GET_BOOKIE_INFO: {
                            BookkeeperProtocol.GetBookieInfoResponse getBookieInfoResponse = response.getGetBookieInfoResponse();
                            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? getBookieInfoResponse.getStatus() : response.getStatus();
                            PerChannelBookieClient.this.handleGetBookieInfoResponse(getBookieInfoResponse.getFreeDiskSpace(), getBookieInfoResponse.getTotalDiskCapacity(), status, completionValue);
                            break;
                        }
                        case START_TLS: {
                            BookkeeperProtocol.StatusCode status = response.getStatus();
                            PerChannelBookieClient.this.handleStartTLSResponse(status, completionValue);
                            break;
                        }
                        default: {
                            LOG.error("Unexpected response, type:{} received from bookie:{}, ignoring", (Object)type, (Object)PerChannelBookieClient.this.addr);
                        }
                    }
                }

                public String toString() {
                    return String.format("HandleResponse(Txn=%d, Type=%s, Entry=(%d, %d))", header.getTxnId(), header.getOperation(), completionValue.ledgerId, completionValue.entryId);
                }
            });
        }
    }

    void handleStartTLSResponse(BookkeeperProtocol.StatusCode status, CompletionValue completionValue) {
        StartTLSCompletion tlsCompletion = (StartTLSCompletion)completionValue;
        Integer rcToRet = this.statusCodeToExceptionCode(status);
        if (null == rcToRet) {
            LOG.error("START_TLS failed on bookie:{}", (Object)this.addr);
            rcToRet = -24;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Received START_TLS response from {} rc: {}", (Object)this.addr, (Object)rcToRet);
        }
        tlsCompletion.cb.startTLSComplete(rcToRet, tlsCompletion.ctx);
        if (this.state != ConnectionState.START_TLS) {
            LOG.error("Connection state changed before TLS response received");
            this.failTLS(-8);
        } else if (status != BookkeeperProtocol.StatusCode.EOK) {
            LOG.error("Client received error {} during TLS negotiation", (Object)status);
            this.failTLS(-24);
        } else {
            PerChannelBookieClient parentObj = this;
            SslHandler handler = parentObj.shFactory.newTLSHandler();
            this.channel.pipeline().addFirst(parentObj.shFactory.getHandlerName(), (ChannelHandler)handler);
            handler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(Future<Channel> future) throws Exception {
                    Queue oldPendingOps;
                    int rc;
                    PerChannelBookieClient perChannelBookieClient = PerChannelBookieClient.this;
                    synchronized (perChannelBookieClient) {
                        if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTING) {
                            LOG.error("Connection state changed before TLS handshake completed {}/{}", (Object)PerChannelBookieClient.this.addr, (Object)PerChannelBookieClient.this.state);
                            rc = -8;
                            PerChannelBookieClient.this.closeChannel((Channel)future.get());
                            PerChannelBookieClient.this.channel = null;
                            if (PerChannelBookieClient.this.state != ConnectionState.CLOSED) {
                                PerChannelBookieClient.this.state = ConnectionState.DISCONNECTED;
                            }
                        } else if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.START_TLS) {
                            rc = 0;
                            LOG.info("Successfully connected to bookie using TLS: " + PerChannelBookieClient.this.addr);
                            PerChannelBookieClient.this.state = ConnectionState.CONNECTED;
                            AuthHandler.ClientSideHandler authHandler = (AuthHandler.ClientSideHandler)((Channel)future.get()).pipeline().get(AuthHandler.ClientSideHandler.class);
                            authHandler.authProvider.onProtocolUpgrade();
                        } else if (future.isSuccess() && (PerChannelBookieClient.this.state == ConnectionState.CLOSED || PerChannelBookieClient.this.state == ConnectionState.DISCONNECTED)) {
                            LOG.warn("Closed before TLS handshake completed, clean up: {}, current state {}", future.get(), (Object)PerChannelBookieClient.this.state);
                            PerChannelBookieClient.this.closeChannel((Channel)future.get());
                            rc = -8;
                            PerChannelBookieClient.this.channel = null;
                        } else {
                            if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTED) {
                                LOG.debug("Already connected with another channel({}), so close the new channel({})", (Object)PerChannelBookieClient.this.channel, future.get());
                                PerChannelBookieClient.this.closeChannel((Channel)future.get());
                                return;
                            }
                            LOG.error("TLS handshake failed with bookie: {}/{}, current state {} : ", new Object[]{future.get(), PerChannelBookieClient.this.addr, PerChannelBookieClient.this.state, future.cause()});
                            rc = -24;
                            PerChannelBookieClient.this.closeChannel((Channel)future.get());
                            PerChannelBookieClient.this.channel = null;
                            if (PerChannelBookieClient.this.state != ConnectionState.CLOSED) {
                                PerChannelBookieClient.this.state = ConnectionState.DISCONNECTED;
                            }
                        }
                        oldPendingOps = PerChannelBookieClient.this.pendingOps;
                        PerChannelBookieClient.this.pendingOps = new ArrayDeque();
                    }
                    for (BookkeeperInternalCallbacks.GenericCallback pendingOp : oldPendingOps) {
                        pendingOp.operationComplete(rc, PerChannelBookieClient.this);
                    }
                }
            });
        }
    }

    void handleWriteLacResponse(long ledgerId, BookkeeperProtocol.StatusCode status, CompletionValue completionValue) {
        Integer rcToRet;
        WriteLacCompletion plc = (WriteLacCompletion)completionValue;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got response for writeLac request from bookie: " + this.addr + " for ledger: " + ledgerId + " rc: " + status);
        }
        if (null == (rcToRet = this.statusCodeToExceptionCode(status))) {
            LOG.error("writeLac for ledger: " + ledgerId + " failed on bookie: " + this.addr + " with code:" + status);
            rcToRet = -12;
        }
        plc.cb.writeLacComplete(rcToRet, ledgerId, this.addr, plc.ctx);
    }

    void handleAddResponse(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, CompletionValue completionValue) {
        Integer rcToRet;
        AddCompletion ac = (AddCompletion)completionValue;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got response for add request from bookie: " + this.addr + " for ledger: " + ledgerId + " entry: " + entryId + " rc: " + status);
        }
        if (null == (rcToRet = this.statusCodeToExceptionCode(status))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Add for ledger: " + ledgerId + ", entry: " + entryId + " failed on bookie: " + this.addr + " with code:" + status);
            }
            rcToRet = -12;
        }
        ac.cb.writeComplete(rcToRet, ledgerId, entryId, this.addr, ac.ctx);
    }

    void handleReadLacResponse(long ledgerId, BookkeeperProtocol.StatusCode status, ByteBuf lacBuffer, ByteBuf lastEntryBuffer, CompletionValue completionValue) {
        Integer rcToRet;
        ReadLacCompletion glac = (ReadLacCompletion)completionValue;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got response for readLac request from bookie: " + this.addr + " for ledger: " + ledgerId + " rc: " + status);
        }
        if (null == (rcToRet = this.statusCodeToExceptionCode(status))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("readLac for ledger: " + ledgerId + " failed on bookie: " + this.addr + " with code:" + status);
            }
            rcToRet = -1;
        }
        glac.cb.readLacComplete(rcToRet, ledgerId, lacBuffer.slice(), lastEntryBuffer.slice(), glac.ctx);
    }

    void handleReadResponse(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, ByteBuf buffer, long maxLAC, long lacUpdateTimestamp, CompletionValue completionValue) {
        Integer rcToRet;
        ReadCompletion rc = (ReadCompletion)completionValue;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got response for read request from bookie: " + this.addr + " for ledger: " + ledgerId + " entry: " + entryId + " rc: " + rc + " entry length: " + buffer.readableBytes());
        }
        if (null == (rcToRet = this.statusCodeToExceptionCode(status))) {
            LOG.error("Read entry for ledger:{}, entry:{} failed on bookie:{} with code:{}", new Object[]{ledgerId, entryId, this.addr, status});
            rcToRet = -1;
        }
        if (buffer != null) {
            buffer = buffer.slice();
        }
        if (maxLAC > -1L && rc.ctx instanceof BookkeeperInternalCallbacks.ReadEntryCallbackCtx) {
            ((BookkeeperInternalCallbacks.ReadEntryCallbackCtx)rc.ctx).setLastAddConfirmed(maxLAC);
        }
        if (lacUpdateTimestamp > -1L && rc.ctx instanceof ReadLastConfirmedAndEntryContext) {
            ((ReadLastConfirmedAndEntryContext)rc.ctx).setLacUpdateTimestamp(lacUpdateTimestamp);
        }
        rc.cb.readEntryComplete(rcToRet, ledgerId, entryId, buffer, rc.ctx);
    }

    void handleGetBookieInfoResponse(long freeDiskSpace, long totalDiskCapacity, BookkeeperProtocol.StatusCode status, CompletionValue completionValue) {
        Integer rcToRet;
        GetBookieInfoCompletion rc = (GetBookieInfoCompletion)completionValue;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got response for read metadata request from bookie: {} rc {}", (Object)this.addr, (Object)rc);
        }
        if (null == (rcToRet = this.statusCodeToExceptionCode(status))) {
            LOG.error("Read metadata failed on bookie:{} with code:{}", new Object[]{this.addr, status});
            rcToRet = -1;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response received from bookie info read: freeDiskSpace=" + freeDiskSpace + " totalDiskSpace:" + totalDiskCapacity);
        }
        rc.cb.getBookieInfoComplete(rcToRet, new BookieInfoReader.BookieInfo(totalDiskCapacity, freeDiskSpace), rc.ctx);
    }

    CompletionKey newCompletionKey(long txnId, BookkeeperProtocol.OperationType operationType) {
        return new V3CompletionKey(txnId, operationType);
    }

    Timeout scheduleTimeout(CompletionKey key, long timeout) {
        if (null != this.requestTimer) {
            return this.requestTimer.newTimeout((TimerTask)key, timeout, TimeUnit.SECONDS);
        }
        return null;
    }

    private Integer statusCodeToExceptionCode(BookkeeperProtocol.StatusCode status) {
        Integer rcToRet = null;
        switch (status) {
            case EOK: {
                rcToRet = 0;
                break;
            }
            case ENOENTRY: {
                rcToRet = -13;
                break;
            }
            case ENOLEDGER: {
                rcToRet = -7;
                break;
            }
            case EBADVERSION: {
                rcToRet = -16;
                break;
            }
            case EUA: {
                rcToRet = -102;
                break;
            }
            case EFENCED: {
                rcToRet = -101;
                break;
            }
            case EREADONLY: {
                rcToRet = -104;
                break;
            }
        }
        return rcToRet;
    }

    private long getTxnId() {
        return txnIdGenerator.incrementAndGet();
    }

    private void initiateTLS() {
        LOG.info("Initializing TLS to {}", (Object)this.channel);
        assert (this.state == ConnectionState.CONNECTING);
        long txnId = this.getTxnId();
        V3CompletionKey completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.START_TLS);
        this.completionObjects.put(completionKey, new StartTLSCompletion(this, this.startTLSOpLogger, null, null, this.scheduleTimeout(completionKey, this.startTLSTimeout)));
        BookkeeperProtocol.Request.Builder h = BookkeeperProtocol.Request.newBuilder();
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.START_TLS).setTxnId(txnId);
        h.setHeader(headerBuilder.build());
        h.setStartTLSRequest(BookkeeperProtocol.StartTLSRequest.newBuilder().build());
        this.state = ConnectionState.START_TLS;
        this.channel.writeAndFlush((Object)h.build()).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    LOG.error("Failed to send START_TLS request");
                    PerChannelBookieClient.this.failTLS(-24);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failTLS(int rc) {
        Queue<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>> oldPendingOps;
        LOG.error("TLS failure on: {}, rc: {}", (Object)this.channel, (Object)rc);
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            this.disconnect();
            oldPendingOps = this.pendingOps;
            this.pendingOps = new ArrayDeque<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>>();
        }
        for (BookkeeperInternalCallbacks.GenericCallback genericCallback : oldPendingOps) {
            genericCallback.operationComplete(rc, null);
        }
    }

    public class ConnectionFutureListener
    implements ChannelFutureListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            Queue oldPendingOps;
            int rc;
            LOG.debug("Channel connected ({}) {}", (Object)future.isSuccess(), (Object)future.channel());
            PerChannelBookieClient perChannelBookieClient = PerChannelBookieClient.this;
            synchronized (perChannelBookieClient) {
                if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTING) {
                    LOG.info("Successfully connected to bookie: {}", (Object)future.channel());
                    rc = 0;
                    PerChannelBookieClient.this.channel = future.channel();
                    if (PerChannelBookieClient.this.shFactory != null) {
                        PerChannelBookieClient.this.initiateTLS();
                        return;
                    }
                    LOG.info("Successfully connected to bookie: " + PerChannelBookieClient.this.addr);
                    PerChannelBookieClient.this.state = ConnectionState.CONNECTED;
                } else if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.START_TLS) {
                    rc = 0;
                    LOG.info("Successfully connected to bookie using TLS: " + PerChannelBookieClient.this.addr);
                    PerChannelBookieClient.this.state = ConnectionState.CONNECTED;
                    AuthHandler.ClientSideHandler authHandler = (AuthHandler.ClientSideHandler)future.channel().pipeline().get(AuthHandler.ClientSideHandler.class);
                    authHandler.authProvider.onProtocolUpgrade();
                } else if (future.isSuccess() && (PerChannelBookieClient.this.state == ConnectionState.CLOSED || PerChannelBookieClient.this.state == ConnectionState.DISCONNECTED)) {
                    LOG.warn("Closed before connection completed, clean up: {}, current state {}", (Object)future.channel(), (Object)PerChannelBookieClient.this.state);
                    PerChannelBookieClient.this.closeChannel(future.channel());
                    rc = -8;
                    PerChannelBookieClient.this.channel = null;
                } else {
                    if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTED) {
                        LOG.debug("Already connected with another channel({}), so close the new channel({})", (Object)PerChannelBookieClient.this.channel, (Object)future.channel());
                        PerChannelBookieClient.this.closeChannel(future.channel());
                        return;
                    }
                    LOG.error("Could not connect to bookie: {}/{}, current state {} : ", new Object[]{future.channel(), PerChannelBookieClient.this.addr, PerChannelBookieClient.this.state, future.cause()});
                    rc = -8;
                    PerChannelBookieClient.this.closeChannel(future.channel());
                    PerChannelBookieClient.this.channel = null;
                    if (PerChannelBookieClient.this.state != ConnectionState.CLOSED) {
                        PerChannelBookieClient.this.state = ConnectionState.DISCONNECTED;
                    }
                }
                oldPendingOps = PerChannelBookieClient.this.pendingOps;
                PerChannelBookieClient.this.pendingOps = new ArrayDeque();
            }
            for (BookkeeperInternalCallbacks.GenericCallback pendingOp : oldPendingOps) {
                pendingOp.operationComplete(rc, PerChannelBookieClient.this);
            }
        }
    }

    private class V2CompletionKey
    extends CompletionKey {
        final long ledgerId;
        final long entryId;

        public V2CompletionKey(long ledgerId, long entryId, BookkeeperProtocol.OperationType operationType) {
            super(0L, operationType);
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof V2CompletionKey)) {
                return false;
            }
            V2CompletionKey that = (V2CompletionKey)object;
            return this.entryId == that.entryId && this.ledgerId == that.ledgerId;
        }

        public int hashCode() {
            return Objects.hash(this.ledgerId, this.entryId);
        }

        public String toString() {
            return String.format("%d:%d %s", this.ledgerId, this.entryId, this.operationType);
        }
    }

    abstract class CompletionKey
    implements TimerTask {
        final long txnId;
        final BookkeeperProtocol.OperationType operationType;
        final long requestAt;

        CompletionKey(long txnId, BookkeeperProtocol.OperationType operationType) {
            this.txnId = txnId;
            this.operationType = operationType;
            this.requestAt = MathUtils.nowInNano();
        }

        private long elapsedTime() {
            return MathUtils.elapsedNanos(this.requestAt);
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (BookkeeperProtocol.OperationType.ADD_ENTRY == this.operationType) {
                PerChannelBookieClient.this.errorOutAddKey(this, -23);
                PerChannelBookieClient.this.addTimeoutOpLogger.registerSuccessfulEvent(this.elapsedTime(), TimeUnit.NANOSECONDS);
            } else if (BookkeeperProtocol.OperationType.READ_ENTRY == this.operationType) {
                PerChannelBookieClient.this.errorOutReadKey(this, -23);
                PerChannelBookieClient.this.readTimeoutOpLogger.registerSuccessfulEvent(this.elapsedTime(), TimeUnit.NANOSECONDS);
            } else if (BookkeeperProtocol.OperationType.WRITE_LAC == this.operationType) {
                PerChannelBookieClient.this.errorOutWriteLacKey(this, -23);
                PerChannelBookieClient.this.writeLacTimeoutOpLogger.registerSuccessfulEvent(this.elapsedTime(), TimeUnit.NANOSECONDS);
            } else if (BookkeeperProtocol.OperationType.READ_LAC == this.operationType) {
                PerChannelBookieClient.this.errorOutReadLacKey(this, -23);
                PerChannelBookieClient.this.readLacTimeoutOpLogger.registerSuccessfulEvent(this.elapsedTime(), TimeUnit.NANOSECONDS);
            } else if (BookkeeperProtocol.OperationType.GET_BOOKIE_INFO == this.operationType) {
                PerChannelBookieClient.this.errorOutGetBookieInfoKey(this, -23);
                PerChannelBookieClient.this.getBookieInfoTimeoutOpLogger.registerSuccessfulEvent(this.elapsedTime(), TimeUnit.NANOSECONDS);
            } else if (BookkeeperProtocol.OperationType.START_TLS == this.operationType) {
                PerChannelBookieClient.this.errorStartTLS(-23);
            } else {
                PerChannelBookieClient.this.errorOutGetBookieInfoKey(this, -23);
                PerChannelBookieClient.this.getBookieInfoTimeoutOpLogger.registerSuccessfulEvent(this.elapsedTime(), TimeUnit.NANOSECONDS);
            }
        }
    }

    class V3CompletionKey
    extends CompletionKey {
        public V3CompletionKey(long txnId, BookkeeperProtocol.OperationType operationType) {
            super(txnId, operationType);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof V3CompletionKey)) {
                return false;
            }
            V3CompletionKey that = (V3CompletionKey)obj;
            return this.txnId == that.txnId && this.operationType == that.operationType;
        }

        public int hashCode() {
            return (int)this.txnId;
        }

        public String toString() {
            return String.format("TxnId(%d), OperationType(%s)", this.txnId, this.operationType);
        }
    }

    static class AddCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.WriteCallback cb;

        public AddCompletion(PerChannelBookieClient pcbc, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, long ledgerId, long entryId) {
            this(pcbc, null, cb, ctx, ledgerId, entryId, null);
        }

        public AddCompletion(final PerChannelBookieClient pcbc, OpStatsLogger addEntryOpLogger, final BookkeeperInternalCallbacks.WriteCallback originalCallback, final Object originalCtx, long ledgerId, long entryId, Timeout timeout) {
            super(originalCtx, ledgerId, entryId, timeout);
            final long startTime = MathUtils.nowInNano();
            this.cb = null == addEntryOpLogger ? originalCallback : new BookkeeperInternalCallbacks.WriteCallback(){

                @Override
                public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
                    this.cancelTimeout();
                    if (pcbc.addEntryOpLogger != null) {
                        long latency = MathUtils.elapsedNanos(startTime);
                        if (rc != 0) {
                            pcbc.addEntryOpLogger.registerFailedEvent(latency, TimeUnit.NANOSECONDS);
                        } else {
                            pcbc.addEntryOpLogger.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
                        }
                    }
                    if (rc != 0 && !expectedBkOperationErrors.contains(rc)) {
                        pcbc.recordError();
                    }
                    originalCallback.writeComplete(rc, ledgerId, entryId, addr, originalCtx);
                }
            };
        }
    }

    static class GetBookieInfoCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.GetBookieInfoCallback cb;

        public GetBookieInfoCompletion(PerChannelBookieClient pcbc, BookkeeperInternalCallbacks.GetBookieInfoCallback cb, Object ctx) {
            this(pcbc, null, cb, ctx, null);
        }

        public GetBookieInfoCompletion(final PerChannelBookieClient pcbc, final OpStatsLogger getBookieInfoOpLogger, final BookkeeperInternalCallbacks.GetBookieInfoCallback originalCallback, final Object originalCtx, Timeout timeout) {
            super(originalCtx, 0L, 0L, timeout);
            final long startTime = MathUtils.nowInNano();
            this.cb = null == getBookieInfoOpLogger ? originalCallback : new BookkeeperInternalCallbacks.GetBookieInfoCallback(){

                @Override
                public void getBookieInfoComplete(int rc, BookieInfoReader.BookieInfo bInfo, Object ctx) {
                    this.cancelTimeout();
                    if (getBookieInfoOpLogger != null) {
                        long latency = MathUtils.elapsedNanos(startTime);
                        if (rc != 0) {
                            getBookieInfoOpLogger.registerFailedEvent(latency, TimeUnit.NANOSECONDS);
                        } else {
                            getBookieInfoOpLogger.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
                        }
                    }
                    if (rc != 0 && !expectedBkOperationErrors.contains(rc)) {
                        pcbc.recordError();
                    }
                    originalCallback.getBookieInfoComplete(rc, bInfo, originalCtx);
                }
            };
        }
    }

    static class StartTLSCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.StartTLSCallback cb;

        public StartTLSCompletion(PerChannelBookieClient pcbc, BookkeeperInternalCallbacks.StartTLSCallback cb, Object ctx) {
            this(pcbc, null, cb, ctx, null);
        }

        public StartTLSCompletion(final PerChannelBookieClient pcbc, final OpStatsLogger startTLSOpLogger, final BookkeeperInternalCallbacks.StartTLSCallback originalCallback, final Object originalCtx, Timeout timeout) {
            super(originalCtx, -1L, -1L, timeout);
            final long startTime = MathUtils.nowInNano();
            this.cb = new BookkeeperInternalCallbacks.StartTLSCallback(){

                @Override
                public void startTLSComplete(int rc, Object ctx) {
                    this.cancelTimeout();
                    if (startTLSOpLogger != null) {
                        long latency = MathUtils.elapsedNanos(startTime);
                        if (rc != 0) {
                            startTLSOpLogger.registerFailedEvent(latency, TimeUnit.NANOSECONDS);
                        } else {
                            startTLSOpLogger.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
                        }
                    }
                    if (rc != 0 && !expectedBkOperationErrors.contains(rc)) {
                        pcbc.recordError();
                    }
                    if (originalCallback != null) {
                        originalCallback.startTLSComplete(rc, originalCtx);
                    }
                }
            };
        }
    }

    static class ReadCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.ReadEntryCallback cb;

        public ReadCompletion(PerChannelBookieClient pcbc, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx, long ledgerId, long entryId) {
            this(pcbc, null, cb, ctx, ledgerId, entryId, null);
        }

        public ReadCompletion(final PerChannelBookieClient pcbc, final OpStatsLogger readEntryOpLogger, final BookkeeperInternalCallbacks.ReadEntryCallback originalCallback, final Object originalCtx, long ledgerId, long entryId, Timeout timeout) {
            super(originalCtx, ledgerId, entryId, timeout);
            final long startTime = MathUtils.nowInNano();
            this.cb = new BookkeeperInternalCallbacks.ReadEntryCallback(){

                @Override
                public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
                    this.cancelTimeout();
                    if (readEntryOpLogger != null) {
                        long latency = MathUtils.elapsedNanos(startTime);
                        if (rc != 0) {
                            readEntryOpLogger.registerFailedEvent(latency, TimeUnit.NANOSECONDS);
                        } else {
                            readEntryOpLogger.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
                        }
                    }
                    if (rc != 0 && !expectedBkOperationErrors.contains(rc)) {
                        pcbc.recordError();
                    }
                    originalCallback.readEntryComplete(rc, ledgerId, entryId, buffer, originalCtx);
                }
            };
        }
    }

    static class ReadLacCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.ReadLacCallback cb;

        public ReadLacCompletion(BookkeeperInternalCallbacks.ReadLacCallback cb, Object ctx, long ledgerId) {
            this(null, cb, ctx, ledgerId, null);
        }

        public ReadLacCompletion(final OpStatsLogger readLacOpLogger, final BookkeeperInternalCallbacks.ReadLacCallback originalCallback, Object ctx, long ledgerId, Timeout timeout) {
            super(ctx, ledgerId, -1L, timeout);
            final long startTime = MathUtils.nowInNano();
            this.cb = null == readLacOpLogger ? originalCallback : new BookkeeperInternalCallbacks.ReadLacCallback(){

                @Override
                public void readLacComplete(int rc, long ledgerId, ByteBuf lacBuffer, ByteBuf lastEntryBuffer, Object ctx) {
                    this.cancelTimeout();
                    long latency = MathUtils.elapsedNanos(startTime);
                    if (rc != 0) {
                        readLacOpLogger.registerFailedEvent(latency, TimeUnit.NANOSECONDS);
                    } else {
                        readLacOpLogger.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
                    }
                    originalCallback.readLacComplete(rc, ledgerId, lacBuffer, lastEntryBuffer, ctx);
                }
            };
        }
    }

    static class WriteLacCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.WriteLacCallback cb;

        public WriteLacCompletion(BookkeeperInternalCallbacks.WriteLacCallback cb, Object ctx, long ledgerId) {
            this(null, cb, ctx, ledgerId, null);
        }

        public WriteLacCompletion(final OpStatsLogger writeLacOpLogger, final BookkeeperInternalCallbacks.WriteLacCallback originalCallback, final Object originalCtx, long ledgerId, Timeout timeout) {
            super(originalCtx, ledgerId, -1L, timeout);
            final long startTime = MathUtils.nowInNano();
            this.cb = null == writeLacOpLogger ? originalCallback : new BookkeeperInternalCallbacks.WriteLacCallback(){

                @Override
                public void writeLacComplete(int rc, long ledgerId, BookieSocketAddress addr, Object ctx) {
                    this.cancelTimeout();
                    long latency = MathUtils.elapsedNanos(startTime);
                    if (rc != 0) {
                        writeLacOpLogger.registerFailedEvent(latency, TimeUnit.NANOSECONDS);
                    } else {
                        writeLacOpLogger.registerSuccessfulEvent(latency, TimeUnit.NANOSECONDS);
                    }
                    originalCallback.writeLacComplete(rc, ledgerId, addr, originalCtx);
                }
            };
        }
    }

    static abstract class CompletionValue {
        final Object ctx;
        protected final long ledgerId;
        protected final long entryId;
        protected final Timeout timeout;

        public CompletionValue(Object ctx, long ledgerId, long entryId, Timeout timeout) {
            this.ctx = ctx;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.timeout = timeout;
        }

        void cancelTimeout() {
            if (null != this.timeout) {
                this.timeout.cancel();
            }
        }
    }

    static enum ConnectionState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        CLOSED,
        START_TLS;

    }
}

