/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.placement;

import com.twitter.util.Duration;
import com.twitter.util.Function0;
import com.twitter.util.Future;
import com.twitter.util.ScheduledThreadPoolTimer;
import com.twitter.util.Time;
import com.twitter.util.Timer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.service.DLSocketAddress;
import org.apache.distributedlog.service.placement.LoadAppraiser;
import org.apache.distributedlog.service.placement.PlacementStateManager;
import org.apache.distributedlog.service.placement.ServerLoad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.runtime.BoxedUnit;

public abstract class PlacementPolicy {
    private static final Logger logger = LoggerFactory.getLogger(PlacementPolicy.class);
    protected final LoadAppraiser loadAppraiser;
    protected final RoutingService routingService;
    protected final Namespace namespace;
    protected final PlacementStateManager placementStateManager;
    private final Duration refreshInterval;
    protected final OpStatsLogger placementCalcStats;
    private Timer placementRefreshTimer;

    public PlacementPolicy(LoadAppraiser loadAppraiser, RoutingService routingService, Namespace namespace, PlacementStateManager placementStateManager, Duration refreshInterval, StatsLogger statsLogger) {
        this.loadAppraiser = loadAppraiser;
        this.routingService = routingService;
        this.namespace = namespace;
        this.placementStateManager = placementStateManager;
        this.refreshInterval = refreshInterval;
        this.placementCalcStats = statsLogger.getOpStatsLogger("placement");
    }

    public Set<String> getServers() {
        Set hosts = this.routingService.getHosts();
        HashSet<String> servers = new HashSet<String>(hosts.size());
        for (SocketAddress address : hosts) {
            servers.add(DLSocketAddress.toString((InetSocketAddress)((InetSocketAddress)address)));
        }
        return servers;
    }

    public Set<String> getStreams() {
        HashSet<String> streams = new HashSet<String>();
        try {
            Iterator logs = this.namespace.getLogs();
            while (logs.hasNext()) {
                streams.add((String)logs.next());
            }
        }
        catch (IOException e) {
            logger.error("Could not get streams for placement policy.", (Throwable)e);
        }
        return streams;
    }

    public void start(boolean leader) {
        logger.info("Starting placement policy");
        TreeSet<ServerLoad> emptyServerLoads = new TreeSet<ServerLoad>();
        for (String server : this.getServers()) {
            emptyServerLoads.add(new ServerLoad(server));
        }
        this.load(emptyServerLoads);
        if (leader) {
            logger.info("Shard is leader. Scheduling timed refresh.");
            this.placementRefreshTimer = new ScheduledThreadPoolTimer(1, "timer", true);
            this.placementRefreshTimer.schedule(Time.now(), this.refreshInterval, (scala.Function0)new Function0<BoxedUnit>(){

                public BoxedUnit apply() {
                    PlacementPolicy.this.refresh();
                    return BoxedUnit.UNIT;
                }
            });
        } else {
            logger.info("Shard is not leader. Watching for server load changes.");
            this.placementStateManager.watch(new PlacementStateManager.PlacementCallback(){

                @Override
                public void callback(TreeSet<ServerLoad> serverLoads) {
                    if (!serverLoads.isEmpty()) {
                        PlacementPolicy.this.load(serverLoads);
                    }
                }
            });
        }
    }

    public void close() {
        if (this.placementRefreshTimer != null) {
            this.placementRefreshTimer.stop();
        }
    }

    public abstract Future<String> placeStream(String var1);

    public abstract void refresh();

    public abstract void load(TreeSet<ServerLoad> var1);
}

