/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream.limiter;

import com.google.common.base.Preconditions;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.limiter.ComposableRequestLimiter;
import org.apache.distributedlog.limiter.GuavaRateLimiter;
import org.apache.distributedlog.limiter.RateLimiter;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.apache.distributedlog.service.stream.StreamOp;
import org.apache.distributedlog.service.stream.WriteOpWithPayload;

public class RequestLimiterBuilder {
    private ComposableRequestLimiter.OverlimitFunction<StreamOp> overlimitFunction = NOP_OVERLIMIT_FUNCTION;
    private RateLimiter limiter;
    private ComposableRequestLimiter.CostFunction<StreamOp> costFunction;
    private StatsLogger statsLogger = NullStatsLogger.INSTANCE;
    public static final ComposableRequestLimiter.CostFunction<StreamOp> RPS_COST_FUNCTION = new ComposableRequestLimiter.CostFunction<StreamOp>(){

        public int apply(StreamOp op) {
            if (op instanceof WriteOpWithPayload) {
                return 1;
            }
            return 0;
        }
    };
    public static final ComposableRequestLimiter.CostFunction<StreamOp> BPS_COST_FUNCTION = new ComposableRequestLimiter.CostFunction<StreamOp>(){

        public int apply(StreamOp op) {
            if (op instanceof WriteOpWithPayload) {
                WriteOpWithPayload writeOp = (WriteOpWithPayload)((Object)op);
                return (int)Math.min(writeOp.getPayloadSize(), Integer.MAX_VALUE);
            }
            return 0;
        }
    };
    public static final ComposableRequestLimiter.OverlimitFunction<StreamOp> NOP_OVERLIMIT_FUNCTION = new ComposableRequestLimiter.OverlimitFunction<StreamOp>(){

        public void apply(StreamOp op) throws OverCapacityException {
        }
    };

    public RequestLimiterBuilder limit(int limit) {
        this.limiter = GuavaRateLimiter.of((int)limit);
        return this;
    }

    public RequestLimiterBuilder overlimit(ComposableRequestLimiter.OverlimitFunction<StreamOp> overlimitFunction) {
        this.overlimitFunction = overlimitFunction;
        return this;
    }

    public RequestLimiterBuilder cost(ComposableRequestLimiter.CostFunction<StreamOp> costFunction) {
        this.costFunction = costFunction;
        return this;
    }

    public RequestLimiterBuilder statsLogger(StatsLogger statsLogger) {
        this.statsLogger = statsLogger;
        return this;
    }

    public static RequestLimiterBuilder newRpsLimiterBuilder() {
        return new RequestLimiterBuilder().cost(RPS_COST_FUNCTION);
    }

    public static RequestLimiterBuilder newBpsLimiterBuilder() {
        return new RequestLimiterBuilder().cost(BPS_COST_FUNCTION);
    }

    public RequestLimiter<StreamOp> build() {
        Preconditions.checkNotNull((Object)this.limiter);
        Preconditions.checkNotNull(this.overlimitFunction);
        Preconditions.checkNotNull(this.costFunction);
        return new ComposableRequestLimiter(this.limiter, this.overlimitFunction, this.costFunction, this.statsLogger);
    }
}

