/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.streamset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.distributedlog.service.streamset.Partition;

public class PartitionMap {
    private final Map<String, Set<Partition>> partitionMap = new HashMap<String, Set<Partition>>();

    public synchronized boolean addPartition(Partition partition, int maxPartitions) {
        if (maxPartitions <= 0) {
            return true;
        }
        Set<Partition> partitions = this.partitionMap.get(partition.getStream());
        if (null == partitions) {
            partitions = new HashSet<Partition>();
            partitions.add(partition);
            this.partitionMap.put(partition.getStream(), partitions);
            return true;
        }
        if (partitions.contains(partition) || partitions.size() < maxPartitions) {
            partitions.add(partition);
            return true;
        }
        return false;
    }

    public synchronized boolean removePartition(Partition partition) {
        Set<Partition> partitions = this.partitionMap.get(partition.getStream());
        return null != partitions && partitions.remove(partition);
    }
}

