/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.benchmark;

import com.google.common.base.Preconditions;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ClientId;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.Duration$;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.benchmark.Utils;
import org.apache.distributedlog.benchmark.Worker;
import org.apache.distributedlog.benchmark.utils.ShiftableRateLimiter;
import org.apache.distributedlog.client.DistributedLogMultiStreamWriter;
import org.apache.distributedlog.client.serverset.DLZkServerSet;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;
import org.apache.distributedlog.thrift.service.StatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterWorker
implements Worker {
    static final Logger LOG = LoggerFactory.getLogger(WriterWorker.class);
    final String streamPrefix;
    final int startStreamId;
    final int endStreamId;
    final int writeConcurrency;
    final int messageSizeBytes;
    final int hostConnectionCoreSize;
    final int hostConnectionLimit;
    final ExecutorService executorService;
    final ShiftableRateLimiter rateLimiter;
    final URI dlUri;
    final DLZkServerSet[] serverSets;
    final List<String> finagleNames;
    final Random random;
    final List<String> streamNames;
    final int numStreams;
    final int batchSize;
    final boolean thriftmux;
    final boolean handshakeWithClientInfo;
    final int sendBufferSize;
    final int recvBufferSize;
    final boolean enableBatching;
    final int batchBufferSize;
    final int batchFlushIntervalMicros;
    private final String routingServiceFinagleName;
    volatile boolean running = true;
    final StatsReceiver statsReceiver;
    final StatsLogger statsLogger;
    final OpStatsLogger requestStat;
    final StatsLogger exceptionsLogger;
    final StatsLogger dlErrorCodeLogger;
    final ExecutorService executor;

    public WriterWorker(String streamPrefix, URI uri, int startStreamId, int endStreamId, ShiftableRateLimiter rateLimiter, int writeConcurrency, int messageSizeBytes, int batchSize, int hostConnectionCoreSize, int hostConnectionLimit, List<String> serverSetPaths, List<String> finagleNames, StatsReceiver statsReceiver, StatsLogger statsLogger, boolean thriftmux, boolean handshakeWithClientInfo, int sendBufferSize, int recvBufferSize, boolean enableBatching, int batchBufferSize, int batchFlushIntervalMicros, String routingServiceFinagleName) {
        Preconditions.checkArgument((startStreamId <= endStreamId ? 1 : 0) != 0);
        Preconditions.checkArgument((!finagleNames.isEmpty() || !serverSetPaths.isEmpty() ? 1 : 0) != 0);
        this.streamPrefix = streamPrefix;
        this.dlUri = uri;
        this.startStreamId = startStreamId;
        this.endStreamId = endStreamId;
        this.rateLimiter = rateLimiter;
        this.writeConcurrency = writeConcurrency;
        this.messageSizeBytes = messageSizeBytes;
        this.statsReceiver = statsReceiver;
        this.statsLogger = statsLogger;
        this.requestStat = this.statsLogger.getOpStatsLogger("requests");
        this.exceptionsLogger = statsLogger.scope("exceptions");
        this.dlErrorCodeLogger = statsLogger.scope("dl_error_code");
        this.executorService = Executors.newCachedThreadPool();
        this.random = new Random(System.currentTimeMillis());
        this.batchSize = batchSize;
        this.hostConnectionCoreSize = hostConnectionCoreSize;
        this.hostConnectionLimit = hostConnectionLimit;
        this.thriftmux = thriftmux;
        this.handshakeWithClientInfo = handshakeWithClientInfo;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.enableBatching = enableBatching;
        this.batchBufferSize = batchBufferSize;
        this.batchFlushIntervalMicros = batchFlushIntervalMicros;
        this.finagleNames = finagleNames;
        this.serverSets = this.createServerSets(serverSetPaths);
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.routingServiceFinagleName = routingServiceFinagleName;
        this.streamNames = new ArrayList<String>(endStreamId - startStreamId);
        for (int i = startStreamId; i < endStreamId; ++i) {
            this.streamNames.add(String.format("%s_%d", streamPrefix, i));
        }
        this.numStreams = this.streamNames.size();
        LOG.info("Writing to {} streams : {}", (Object)this.numStreams, this.streamNames);
    }

    protected DLZkServerSet[] createServerSets(List<String> serverSetPaths) {
        DLZkServerSet[] serverSets = new DLZkServerSet[serverSetPaths.size()];
        for (int i = 0; i < serverSets.length; ++i) {
            String serverSetPath = serverSetPaths.get(i);
            serverSets[i] = DLZkServerSet.of((URI)URI.create(serverSetPath), (int)60000);
        }
        return serverSets;
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        SchedulerUtils.shutdownScheduler((ExecutorService)this.executorService, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        for (DLZkServerSet serverSet : this.serverSets) {
            serverSet.close();
        }
    }

    private DistributedLogClient buildDlogClient() {
        ClientBuilder clientBuilder = ClientBuilder.get().hostConnectionLimit(this.hostConnectionLimit).hostConnectionCoresize(this.hostConnectionCoreSize).tcpConnectTimeout(Duration$.MODULE$.fromMilliseconds(200L)).connectTimeout(Duration$.MODULE$.fromMilliseconds(200L)).requestTimeout(Duration$.MODULE$.fromSeconds(10)).sendBufferSize(this.sendBufferSize).recvBufferSize(this.recvBufferSize);
        ClientId clientId = ClientId$.MODULE$.apply("dlog_loadtest_writer");
        DistributedLogClientBuilder builder = DistributedLogClientBuilder.newBuilder().clientId(clientId).clientBuilder(clientBuilder).thriftmux(this.thriftmux).redirectBackoffStartMs(100).redirectBackoffMaxMs(500).requestTimeoutMs(10000).statsReceiver(this.statsReceiver).streamNameRegex("^" + this.streamPrefix + "_[0-9]+$").handshakeWithClientInfo(this.handshakeWithClientInfo).periodicHandshakeIntervalMs(TimeUnit.SECONDS.toMillis(30L)).periodicOwnershipSyncIntervalMs(TimeUnit.MINUTES.toMillis(5L)).periodicDumpOwnershipCache(true).handshakeTracing(true).serverRoutingServiceFinagleNameStr(this.routingServiceFinagleName).name("writer");
        if (!this.finagleNames.isEmpty()) {
            String local = this.finagleNames.get(0);
            String[] remotes = new String[this.finagleNames.size() - 1];
            this.finagleNames.subList(1, this.finagleNames.size()).toArray(remotes);
            builder = builder.finagleNameStrs(local, remotes);
        } else if (this.serverSets.length != 0) {
            ServerSet local = this.serverSets[0].getServerSet();
            ServerSet[] remotes = new ServerSet[this.serverSets.length - 1];
            for (int i = 1; i < this.serverSets.length; ++i) {
                remotes[i - 1] = this.serverSets[i].getServerSet();
            }
            builder = builder.serverSets(local, remotes);
        } else {
            builder = builder.uri(this.dlUri);
        }
        return builder.build();
    }

    ByteBuffer buildBuffer(long requestMillis, int messageSizeBytes) {
        try {
            ByteBuffer data = ByteBuffer.wrap(Utils.generateMessage(requestMillis, messageSizeBytes));
            return data;
        }
        catch (TException e) {
            LOG.error("Error generating message : ", (Throwable)e);
            return null;
        }
    }

    List<ByteBuffer> buildBufferList(int batchSize, long requestMillis, int messageSizeBytes) {
        ArrayList<ByteBuffer> bufferList = new ArrayList<ByteBuffer>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            ByteBuffer buf = this.buildBuffer(requestMillis, messageSizeBytes);
            if (null == buf) {
                return null;
            }
            bufferList.add(buf);
        }
        return bufferList;
    }

    @Override
    public void run() {
        LOG.info("Starting writer (concurrency = {}, prefix = {}, batchSize = {})", new Object[]{this.writeConcurrency, this.streamPrefix, this.batchSize});
        try {
            for (int i = 0; i < this.writeConcurrency; ++i) {
                Runnable writer = null;
                writer = this.batchSize > 0 ? new BulkWriter(i) : new Writer(i);
                this.executorService.submit(writer);
            }
        }
        catch (Throwable t) {
            LOG.error("Unhandled exception caught", t);
        }
    }

    class BulkWriter
    implements Runnable {
        final int idx;
        final DistributedLogClient dlc;

        BulkWriter(int idx) {
            this.idx = idx;
            this.dlc = WriterWorker.this.buildDlogClient();
        }

        @Override
        public void run() {
            LOG.info("Started writer {}.", (Object)this.idx);
            while (WriterWorker.this.running) {
                WriterWorker.this.rateLimiter.getLimiter().acquire(WriterWorker.this.batchSize);
                String streamName = WriterWorker.this.streamNames.get(WriterWorker.this.random.nextInt(WriterWorker.this.numStreams));
                long requestMillis = System.currentTimeMillis();
                List<ByteBuffer> data = WriterWorker.this.buildBufferList(WriterWorker.this.batchSize, requestMillis, WriterWorker.this.messageSizeBytes);
                if (null == data) break;
                List results = this.dlc.writeBulk(streamName, data);
                for (Future result : results) {
                    result.addEventListener((FutureEventListener)new TimedRequestHandler(streamName, requestMillis));
                }
            }
            this.dlc.close();
        }
    }

    class Writer
    implements Runnable {
        final int idx;
        final DistributedLogClient dlc;
        DistributedLogMultiStreamWriter writer = null;
        final ShiftableRateLimiter limiter;

        Writer(int idx) {
            this.idx = idx;
            this.dlc = WriterWorker.this.buildDlogClient();
            if (WriterWorker.this.enableBatching) {
                this.writer = DistributedLogMultiStreamWriter.newBuilder().client(this.dlc).streams(WriterWorker.this.streamNames).compressionCodec(CompressionCodec.Type.NONE).flushIntervalMicros(WriterWorker.this.batchFlushIntervalMicros).bufferSize(WriterWorker.this.batchBufferSize).firstSpeculativeTimeoutMs(9000).maxSpeculativeTimeoutMs(9000).requestTimeoutMs(10000L).speculativeBackoffMultiplier(2.0f).build();
            }
            this.limiter = WriterWorker.this.rateLimiter.duplicate();
        }

        @Override
        public void run() {
            LOG.info("Started writer {}.", (Object)this.idx);
            while (WriterWorker.this.running) {
                this.limiter.getLimiter().acquire();
                String streamName = WriterWorker.this.streamNames.get(WriterWorker.this.random.nextInt(WriterWorker.this.numStreams));
                long requestMillis = System.currentTimeMillis();
                ByteBuffer data = WriterWorker.this.buildBuffer(requestMillis, WriterWorker.this.messageSizeBytes);
                if (null == data) break;
                if (null != this.writer) {
                    this.writer.write(data).addEventListener((FutureEventListener)new TimedRequestHandler(streamName, requestMillis));
                    continue;
                }
                this.dlc.write(streamName, data).addEventListener((FutureEventListener)new TimedRequestHandler(streamName, requestMillis));
            }
            if (null != this.writer) {
                this.writer.close();
            }
            this.dlc.close();
        }
    }

    class TimedRequestHandler
    implements FutureEventListener<DLSN>,
    Runnable {
        final String streamName;
        final long requestMillis;
        DLSN dlsn = null;
        Throwable cause = null;

        TimedRequestHandler(String streamName, long requestMillis) {
            this.streamName = streamName;
            this.requestMillis = requestMillis;
        }

        public void onSuccess(DLSN value) {
            this.dlsn = value;
            WriterWorker.this.executor.submit(this);
        }

        public void onFailure(Throwable cause) {
            this.cause = cause;
            WriterWorker.this.executor.submit(this);
        }

        @Override
        public void run() {
            if (null != this.dlsn) {
                WriterWorker.this.requestStat.registerSuccessfulEvent(System.currentTimeMillis() - this.requestMillis, TimeUnit.MILLISECONDS);
            } else {
                LOG.error("Failed to publish to {} : ", (Object)this.streamName, (Object)this.cause);
                WriterWorker.this.requestStat.registerFailedEvent(System.currentTimeMillis() - this.requestMillis, TimeUnit.MILLISECONDS);
                WriterWorker.this.exceptionsLogger.getCounter(this.cause.getClass().getName()).inc();
                if (this.cause instanceof DLException) {
                    DLException dle = (DLException)this.cause;
                    WriterWorker.this.dlErrorCodeLogger.getCounter(StatusCode.findByValue((int)dle.getCode()).toString()).inc();
                }
            }
        }
    }
}

