/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.main;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.file.BaseFileManager;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.jvm.Profile;
import org.openjdk.tools.javac.jvm.Target;
import org.openjdk.tools.javac.main.JavaCompiler;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.main.OptionHelper;
import org.openjdk.tools.javac.platform.PlatformDescription;
import org.openjdk.tools.javac.platform.PlatformUtils;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.PropagatedException;

public class Arguments {
    public static final Context.Key<Arguments> argsKey = new Context.Key();
    private String ownName;
    private Set<String> classNames;
    private Set<Path> files;
    private Map<Option, String> deferredFileManagerOptions;
    private Set<JavaFileObject> fileObjects;
    private final Options options;
    private JavaFileManager fileManager;
    private final Log log;
    private final Context context;
    private ErrorMode errorMode;
    private boolean errors;
    private final OptionHelper cmdLineHelper = new OptionHelper(){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String name, String value) {
            Arguments.this.options.put(name, value);
        }

        @Override
        public void remove(String name) {
            Arguments.this.options.remove(name);
        }

        @Override
        public boolean handleFileManagerOption(Option option, String value) {
            Arguments.this.options.put(option.getText(), value);
            Arguments.this.deferredFileManagerOptions.put(option, value);
            return true;
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }

        @Override
        public String getOwnName() {
            return Arguments.this.ownName;
        }

        @Override
        public void error(String key, Object ... args) {
            Arguments.this.error(key, args);
        }

        @Override
        public void addFile(Path p) {
            Arguments.this.files.add(p);
        }

        @Override
        public void addClassName(String s) {
            Arguments.this.classNames.add(s);
        }
    };
    private final OptionHelper apiHelper = new OptionHelper.GrumpyHelper(null){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option.getText());
        }

        @Override
        public void put(String name, String value) {
            Arguments.this.options.put(name, value);
        }

        @Override
        public void remove(String name) {
            Arguments.this.options.remove(name);
        }

        @Override
        public void error(String key, Object ... args) {
            Arguments.this.error(key, args);
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }
    };

    public static Arguments instance(Context context) {
        Arguments instance = context.get(argsKey);
        if (instance == null) {
            instance = new Arguments(context);
        }
        return instance;
    }

    protected Arguments(Context context) {
        context.put(argsKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
        this.context = context;
    }

    public void init(String ownName, String ... args) {
        this.ownName = ownName;
        this.errorMode = ErrorMode.LOG;
        this.files = new LinkedHashSet<Path>();
        this.deferredFileManagerOptions = new LinkedHashMap<Option, String>();
        this.fileObjects = null;
        this.classNames = new LinkedHashSet<String>();
        this.processArgs(List.from(args), Option.getJavaCompilerOptions(), this.cmdLineHelper, true, false);
    }

    public void init(String ownName, Iterable<String> options, Iterable<String> classNames, Iterable<? extends JavaFileObject> files) {
        this.ownName = ownName;
        this.classNames = this.toSet(classNames);
        this.fileObjects = this.toSet(files);
        this.files = null;
        this.errorMode = ErrorMode.ILLEGAL_ARGUMENT;
        if (options != null) {
            this.processArgs(this.toList(options), Option.getJavacToolOptions(), this.apiHelper, false, true);
        }
        this.errorMode = ErrorMode.ILLEGAL_STATE;
    }

    public Set<JavaFileObject> getFileObjects() {
        if (this.fileObjects == null) {
            if (this.files == null) {
                this.fileObjects = Collections.emptySet();
            } else {
                this.fileObjects = new LinkedHashSet<JavaFileObject>();
                JavacFileManager jfm = (JavacFileManager)this.getFileManager();
                for (JavaFileObject javaFileObject : jfm.getJavaFileObjectsFromPaths((Iterable<? extends Path>)this.files)) {
                    this.fileObjects.add(javaFileObject);
                }
            }
        }
        return this.fileObjects;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    private boolean processArgs(Iterable<String> args, Set<Option> allowableOpts, OptionHelper helper, boolean allowOperands, boolean checkFileManager) {
        if (!this.doProcessArgs(args, allowableOpts, helper, allowOperands, checkFileManager)) {
            return false;
        }
        String platformString = this.options.get(Option.RELEASE);
        this.checkOptionAllowed(platformString == null, option -> this.error("err.release.bootclasspath.conflict", option.getText()), Option.BOOTCLASSPATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.XBOOTCLASSPATH_PREPEND, Option.ENDORSEDDIRS, Option.EXTDIRS, Option.SOURCE, Option.TARGET);
        if (platformString != null) {
            PlatformDescription platformDescription = PlatformUtils.lookupPlatformDescription(platformString);
            if (platformDescription == null) {
                this.error("err.unsupported.release.version", platformString);
                return false;
            }
            this.options.put(Option.SOURCE, platformDescription.getSourceVersion());
            this.options.put(Option.TARGET, platformDescription.getTargetVersion());
            this.context.put(PlatformDescription.class, platformDescription);
            if (!this.doProcessArgs(platformDescription.getAdditionalOptions(), allowableOpts, helper, allowOperands, checkFileManager)) {
                return false;
            }
            Collection<Path> platformCP = platformDescription.getPlatformPath();
            if (platformCP != null) {
                JavaFileManager fm = this.getFileManager();
                if (!(fm instanceof StandardJavaFileManager)) {
                    this.error("err.release.not.standard.file.manager", new Object[0]);
                    return false;
                }
                try {
                    StandardJavaFileManager sfm = (StandardJavaFileManager)fm;
                    sfm.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, platformCP);
                }
                catch (IOException ex) {
                    this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
                    ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
                    return false;
                }
            }
        }
        this.options.notifyListeners();
        return true;
    }

    private boolean doProcessArgs(Iterable<String> args, Set<Option> allowableOpts, OptionHelper helper, boolean allowOperands, boolean checkFileManager) {
        JavaFileManager fm = checkFileManager ? this.getFileManager() : null;
        Iterator<String> argIter = args.iterator();
        while (argIter.hasNext()) {
            String arg = argIter.next();
            if (arg.isEmpty()) {
                this.error("err.invalid.flag", arg);
                return false;
            }
            Option option = null;
            if (arg.startsWith("-")) {
                for (Option o : allowableOpts) {
                    if (!o.matches(arg)) continue;
                    option = o;
                    break;
                }
            } else if (allowOperands && Option.SOURCEFILE.matches(arg)) {
                option = Option.SOURCEFILE;
            }
            if (option == null) {
                if (fm != null && fm.handleOption(arg, argIter)) continue;
                this.error("err.invalid.flag", arg);
                return false;
            }
            if (option.hasArg()) {
                if (!argIter.hasNext()) {
                    this.error("err.req.arg", arg);
                    return false;
                }
                String operand = argIter.next();
                if (!option.process(helper, arg, operand)) continue;
                return false;
            }
            if (!option.process(helper, arg)) continue;
            return false;
        }
        return true;
    }

    public boolean validate() {
        JavaFileManager fm;
        boolean lintOptions;
        String profileString;
        Target target;
        if (this.isEmpty()) {
            if (this.options.isSet(Option.HELP) || this.options.isSet(Option.X) || this.options.isSet(Option.VERSION) || this.options.isSet(Option.FULLVERSION)) {
                return true;
            }
            if (JavaCompiler.explicitAnnotationProcessingRequested(this.options)) {
                this.error("err.no.source.files.classes", new Object[0]);
            } else {
                this.error("err.no.source.files", new Object[0]);
            }
            return false;
        }
        if (!this.checkDirectory(Option.D)) {
            return false;
        }
        if (!this.checkDirectory(Option.S)) {
            return false;
        }
        if (!this.checkDirectory(Option.H)) {
            return false;
        }
        String sourceString = this.options.get(Option.SOURCE);
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get(Option.TARGET);
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0)) && target.compareTo(source.requiredTarget()) < 0) {
            if (targetString != null) {
                if (sourceString == null) {
                    this.error("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                } else {
                    this.error("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                }
                return false;
            }
            target = source.requiredTarget();
            this.options.put("-target", target.name);
        }
        if ((profileString = this.options.get(Option.PROFILE)) != null) {
            Profile profile = Profile.lookup(profileString);
            if (!profile.isValid(target)) {
                this.error("warn.profile.target.conflict", profileString, target.name);
            }
            if (this.options.get(Option.BOOTCLASSPATH) != null) {
                this.error("err.profile.bootclasspath.conflict", new Object[0]);
            }
        }
        if ((lintOptions = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.OPTIONS.option)) && source.compareTo(Source.DEFAULT) < 0 && !this.options.isSet(Option.RELEASE) && (fm = this.getFileManager()) instanceof BaseFileManager && ((BaseFileManager)fm).isDefaultBootClassPath()) {
            this.log.warning(Lint.LintCategory.OPTIONS, "source.no.bootclasspath", source.name);
        }
        boolean obsoleteOptionFound = false;
        if (source.compareTo(Source.MIN) < 0) {
            this.log.error("option.removed.source", source.name, Source.MIN.name);
        } else if (source == Source.MIN && lintOptions) {
            this.log.warning(Lint.LintCategory.OPTIONS, "option.obsolete.source", source.name);
            obsoleteOptionFound = true;
        }
        if (target.compareTo(Target.MIN) < 0) {
            this.log.error("option.removed.target", target.name, Target.MIN.name);
        } else if (target == Target.MIN && lintOptions) {
            this.log.warning(Lint.LintCategory.OPTIONS, "option.obsolete.target", target.name);
            obsoleteOptionFound = true;
        }
        if (obsoleteOptionFound) {
            this.log.warning(Lint.LintCategory.OPTIONS, "option.obsolete.suppression", new Object[0]);
        }
        return !this.errors;
    }

    public boolean isEmpty() {
        return !(this.files != null && !this.files.isEmpty() || this.fileObjects != null && !this.fileObjects.isEmpty() || !this.classNames.isEmpty());
    }

    public Map<Option, String> getDeferredFileManagerOptions() {
        return this.deferredFileManagerOptions;
    }

    public Set<List<String>> getPluginOpts() {
        String plugins = this.options.get(Option.PLUGIN);
        if (plugins == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<List<String>> pluginOpts = new LinkedHashSet<List<String>>();
        for (String plugin : plugins.split("\\x00")) {
            pluginOpts.add(List.from(plugin.split("\\s+")));
        }
        return Collections.unmodifiableSet(pluginOpts);
    }

    public List<String> getDocLintOpts() {
        String xdoclint = this.options.get(Option.XDOCLINT);
        String xdoclintCustom = this.options.get(Option.XDOCLINT_CUSTOM);
        if (xdoclint == null && xdoclintCustom == null) {
            return List.nil();
        }
        LinkedHashSet<String> doclintOpts = new LinkedHashSet<String>();
        if (xdoclint != null) {
            doclintOpts.add("-Xmsgs");
        }
        if (xdoclintCustom != null) {
            for (String s : xdoclintCustom.split("\\s+")) {
                if (s.isEmpty()) continue;
                doclintOpts.add(s.replace(Option.XDOCLINT_CUSTOM.text, "-Xmsgs:"));
            }
        }
        if (doclintOpts.equals(Collections.singleton("-Xmsgs:none"))) {
            return List.nil();
        }
        String checkPackages = this.options.get(Option.XDOCLINT_PACKAGE);
        if (checkPackages != null) {
            for (String s : checkPackages.split("\\s+")) {
                doclintOpts.add(s.replace(Option.XDOCLINT_PACKAGE.text, "-XcheckPackage:"));
            }
        }
        doclintOpts.add("-XimplicitHeaders:2");
        return List.from(doclintOpts.toArray(new String[doclintOpts.size()]));
    }

    private boolean checkDirectory(Option option) {
        String value = this.options.get(option);
        if (value == null) {
            return true;
        }
        Path file = Paths.get(value, new String[0]);
        if (Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    void checkOptionAllowed(boolean allowed, ErrorReporter r, Option ... opts) {
        if (!allowed) {
            Stream.of(opts).filter(this.options::isSet).forEach(r::report);
        }
    }

    void error(String key, Object ... args) {
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                String msg = this.log.localize(Log.PrefixKind.JAVAC, key, args);
                throw new PropagatedException(new IllegalArgumentException(msg));
            }
            case ILLEGAL_STATE: {
                String msg = this.log.localize(Log.PrefixKind.JAVAC, key, args);
                throw new PropagatedException(new IllegalStateException(msg));
            }
            case LOG: {
                this.report(key, args);
                this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
            }
        }
    }

    void warning(String key, Object ... args) {
        this.report(key, args);
    }

    private void report(String key, Object ... args) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, key, args));
    }

    private JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = this.context.get(JavaFileManager.class);
        }
        return this.fileManager;
    }

    <T> ListBuffer<T> toList(Iterable<? extends T> items) {
        ListBuffer<T> list = new ListBuffer<T>();
        if (items != null) {
            for (T item : items) {
                list.add(item);
            }
        }
        return list;
    }

    <T> Set<T> toSet(Iterable<? extends T> items) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        if (items != null) {
            for (T item : items) {
                set.add(item);
            }
        }
        return set;
    }

    private static interface ErrorReporter {
        public void report(Option var1);
    }

    private static enum ErrorMode {
        ILLEGAL_ARGUMENT,
        ILLEGAL_STATE,
        LOG;

    }
}

