/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AbstractIndexWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.IndexBuilder;

public class SplitIndexWriter
extends AbstractIndexWriter {
    protected int prev;
    protected int next;
    private List<Character> indexElements;

    public SplitIndexWriter(ConfigurationImpl configuration, DocPath path, IndexBuilder indexbuilder, Collection<Character> elements, int prev, int next) throws IOException {
        super(configuration, path, indexbuilder);
        this.indexElements = new ArrayList<Character>(elements);
        this.prev = prev;
        this.next = next;
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        DocPath filename = DocPath.empty;
        DocPath path = DocPaths.INDEX_FILES;
        try {
            TreeSet<Character> keys = new TreeSet<Character>(indexbuilder.getIndexMap().keySet());
            keys.addAll(configuration.tagSearchIndexKeys);
            ListIterator<Character> li = new ArrayList<Character>(keys).listIterator();
            while (li.hasNext()) {
                Character ch = li.next();
                filename = DocPaths.indexN(li.nextIndex());
                SplitIndexWriter indexgen = new SplitIndexWriter(configuration, path.resolve(filename), indexbuilder, keys, li.previousIndex(), li.nextIndex());
                indexgen.generateIndexFile(ch);
                if (!li.hasNext()) {
                    indexgen.createSearchIndexFiles();
                }
                indexgen.close();
            }
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void generateIndexFile(Character unicode) throws IOException {
        String title = this.configuration.getText("doclet.Window_Split_Index", unicode.toString());
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : body;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            body.addContent(htmlTree);
        }
        HtmlTree divTree = new HtmlTree(HtmlTag.DIV);
        divTree.addStyle(HtmlStyle.contentContainer);
        this.addLinksForIndexes(divTree);
        if (this.configuration.tagSearchIndexMap.get(unicode) == null) {
            this.addContents(unicode, this.indexbuilder.getMemberList(unicode), divTree);
        } else if (this.indexbuilder.getMemberList(unicode) == null) {
            this.addSearchContents(unicode, this.configuration.tagSearchIndexMap.get(unicode), divTree);
        } else {
            this.addContents(unicode, this.indexbuilder.getMemberList(unicode), this.configuration.tagSearchIndexMap.get(unicode), divTree);
        }
        this.addLinksForIndexes(divTree);
        body.addContent(this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN(divTree) : divTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            htmlTree = HtmlTree.FOOTER();
        }
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(htmlTree);
        }
        this.printHtmlDocument(null, true, body);
    }

    protected void addLinksForIndexes(Content contentTree) {
        for (int i = 0; i < this.indexElements.size(); ++i) {
            int j = i + 1;
            contentTree.addContent(this.getHyperLink(DocPaths.indexN(j), (Content)new StringContent(this.indexElements.get(i).toString())));
            contentTree.addContent(this.getSpace());
        }
    }

    @Override
    public Content getNavLinkPrevious() {
        Content prevletterLabel = this.getResource("doclet.Prev_Letter");
        if (this.prev == -1) {
            return HtmlTree.LI(prevletterLabel);
        }
        Content prevLink = this.getHyperLink(DocPaths.indexN(this.prev), prevletterLabel);
        return HtmlTree.LI(prevLink);
    }

    @Override
    public Content getNavLinkNext() {
        Content nextletterLabel = this.getResource("doclet.Next_Letter");
        if (this.next == -1) {
            return HtmlTree.LI(nextletterLabel);
        }
        Content nextLink = this.getHyperLink(DocPaths.indexN(this.next), nextletterLabel);
        return HtmlTree.LI(nextLink);
    }
}

