/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class InetSocketAddressUtil$ {
    public static final InetSocketAddressUtil$ MODULE$;
    private final SocketAddress unconnected;

    static {
        new InetSocketAddressUtil$();
    }

    public SocketAddress unconnected() {
        return this.unconnected;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SocketAddress toPublic(SocketAddress bound) {
        InetAddress inetAddress;
        SocketAddress socketAddress2 = bound;
        if (!(socketAddress2 instanceof InetSocketAddress)) return bound;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress2;
        if (!inetSocketAddress.getAddress().isAnyLocalAddress()) return bound;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = InetAddress.getLoopbackAddress();
        }
        InetAddress host = inetAddress;
        return new InetSocketAddress(host, inetSocketAddress.getPort());
    }

    public Seq<Tuple2<String, Object>> parseHostPorts(String hosts2) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(hosts2)).split(new char[]{' ', ','})).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$2) {
                return x$2.split(":");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).map((Function1)new Serializable(hosts2){
            public static final long serialVersionUID = 0L;
            private final String hosts$1;

            public final Tuple2<String, Object> apply(String[] hp) {
                block4: {
                    Tuple2 tuple2;
                    block3: {
                        Option option;
                        String[] stringArray;
                        block2: {
                            Predef$.MODULE$.require(hp.length == 2, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "You must specify host and port";
                                }
                            });
                            stringArray = hp;
                            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                            if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(2) != 0) break block2;
                            String host = (String)((SeqLike)option2.get()).apply(0);
                            String string = (String)((SeqLike)option2.get()).apply(1);
                            if (!"*".equals(string)) break block2;
                            tuple2 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)0));
                            break block3;
                        }
                        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) break block4;
                        String host = (String)((SeqLike)option.get()).apply(0);
                        String portStr = (String)((SeqLike)option.get()).apply(1);
                        tuple2 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(portStr)).toInt()));
                    }
                    return tuple2;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Malformed host/port specification: ").append((Object)this.hosts$1).toString());
            }
            {
                this.hosts$1 = hosts$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Set<SocketAddress> resolveHostPorts(Seq<Tuple2<String, Object>> hostPorts) {
        return ((TraversableOnce)this.resolveHostPortsSeq(hostPorts).flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
    }

    public Seq<Seq<SocketAddress>> resolveHostPortsSeq(Seq<Tuple2<String, Object>> hostPorts) {
        return (Seq)hostPorts.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<InetSocketAddress> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    Seq seq = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])InetAddress.getAllByName(host)).map((Function1)new Serializable(this, port){
                        public static final long serialVersionUID = 0L;
                        private final int port$1;

                        public final InetSocketAddress apply(InetAddress addr) {
                            return new InetSocketAddress(addr, this.port$1);
                        }
                        {
                            this.port$1 = port$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class)))).toSeq();
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<InetSocketAddress> parseHosts(String hosts2) {
        String string = hosts2;
        String string2 = ":*";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetSocketAddress[]{new InetSocketAddress(0)}));
        }
        return ((TraversableOnce)this.parseHostPorts(hosts2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InetSocketAddress apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    String string = host;
                    String string2 = "";
                    InetSocketAddress inetSocketAddress = !(string != null ? !string.equals(string2) : string2 != null) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
                    return inetSocketAddress;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    private InetSocketAddressUtil$() {
        MODULE$ = this;
        this.unconnected = new SocketAddress(){

            public String toString() {
                return "unconnected";
            }
        };
    }
}

