/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.base.Preconditions;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.util.BackoffStrategy;

public class TruncatedBinaryBackoff
implements BackoffStrategy {
    private final long initialBackoffMs;
    private final long maxBackoffIntervalMs;
    private final boolean stopAtMax;

    public TruncatedBinaryBackoff(Amount<Long, Time> initialBackoff, Amount<Long, Time> maxBackoff, boolean stopAtMax) {
        Preconditions.checkNotNull(initialBackoff);
        Preconditions.checkNotNull(maxBackoff);
        Preconditions.checkArgument(((Long)initialBackoff.getValue() > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((maxBackoff.compareTo(initialBackoff) >= 0 ? 1 : 0) != 0);
        this.initialBackoffMs = (Long)initialBackoff.as((Unit)Time.MILLISECONDS);
        this.maxBackoffIntervalMs = (Long)maxBackoff.as((Unit)Time.MILLISECONDS);
        this.stopAtMax = stopAtMax;
    }

    public TruncatedBinaryBackoff(Amount<Long, Time> initialBackoff, Amount<Long, Time> maxBackoff) {
        this(initialBackoff, maxBackoff, false);
    }

    @Override
    public long calculateBackoffMs(long lastBackoffMs) {
        Preconditions.checkArgument((lastBackoffMs >= 0L ? 1 : 0) != 0);
        long backoff = lastBackoffMs == 0L ? this.initialBackoffMs : Math.min(this.maxBackoffIntervalMs, lastBackoffMs * 2L);
        return backoff;
    }

    @Override
    public boolean shouldContinue(long lastBackoffMs) {
        Preconditions.checkArgument((lastBackoffMs >= 0L ? 1 : 0) != 0);
        boolean stop = this.stopAtMax && lastBackoffMs >= this.maxBackoffIntervalMs;
        return !stop;
    }
}

