/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class KeyPair {
    @Named(value="public_key")
    private final String publicKey;
    @Named(value="private_key")
    private final String privateKey;
    @Named(value="user_id")
    private final String userId;
    private final String name;
    private final String fingerprint;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromKeyPair(this);
    }

    @ConstructorProperties(value={"public_key", "private_key", "user_id", "name", "fingerprint"})
    protected KeyPair(@Nullable String publicKey, @Nullable String privateKey, @Nullable String userId, String name, @Nullable String fingerprint) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.userId = userId;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.fingerprint = fingerprint;
    }

    @Nullable
    public String getPublicKey() {
        return this.publicKey;
    }

    @Nullable
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getFingerprint() {
        return this.fingerprint;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.publicKey, this.privateKey, this.userId, this.name, this.fingerprint});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeyPair that = (KeyPair)KeyPair.class.cast(obj);
        return Objects.equal((Object)this.publicKey, (Object)that.publicKey) && Objects.equal((Object)this.privateKey, (Object)that.privateKey) && Objects.equal((Object)this.userId, (Object)that.userId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.fingerprint, (Object)that.fingerprint);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").omitNullValues().add("public_key", (Object)this.publicKey).add("private_key", (Object)this.privateKey).add("user_id", (Object)this.userId).add("name", (Object)this.name).add("fingerprint", (Object)this.fingerprint);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String publicKey;
        protected String privateKey;
        protected String userId;
        protected String name;
        protected String fingerprint;

        protected abstract T self();

        public T publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this.self();
        }

        public T privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this.self();
        }

        public T userId(String userId) {
            this.userId = userId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this.self();
        }

        public KeyPair build() {
            return new KeyPair(this.publicKey, this.privateKey, this.userId, this.name, this.fingerprint);
        }

        public T fromKeyPair(KeyPair in) {
            return ((Builder)((Builder)((Builder)((Builder)this.publicKey(in.getPublicKey())).privateKey(in.getPrivateKey())).userId(in.getUserId())).name(in.getName())).fingerprint(in.getFingerprint());
        }
    }
}

