/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Constants;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.OSInformation;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.url.URLConnectionHandler;
import aQute.bnd.version.Version;
import aQute.lib.collections.ExtList;
import aQute.lib.collections.SortedList;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.cryptography.SHA1;
import aQute.libg.generics.Create;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processor
extends Domain
implements Reporter,
Registry,
Constants,
Closeable {
    static final int BUFFER_SIZE = 4096;
    static Pattern PACKAGES_IGNORED = Pattern.compile("(java\\.lang\\.reflect|sun\\.reflect).*");
    static ThreadLocal<Processor> current = new ThreadLocal();
    static ExecutorService executor = Executors.newCachedThreadPool();
    static Random random = new Random();
    public static final String LIST_SPLITTER = "\\s*,\\s*";
    final List<String> errors = new ArrayList<String>();
    final List<String> warnings = new ArrayList<String>();
    final Set<Object> basicPlugins = new HashSet<Object>();
    private final Set<Closeable> toBeClosed = new HashSet<Closeable>();
    Set<Object> plugins;
    boolean pedantic;
    boolean trace;
    boolean exceptions;
    boolean fileMustExist = true;
    private File base = new File("").getAbsoluteFile();
    Properties properties;
    String profile;
    private Macro replacer;
    private long lastModified;
    private File propertiesFile;
    private boolean fixup = true;
    long modified;
    Processor parent;
    List<File> included;
    CL pluginLoader;
    Collection<String> filter;
    HashSet<String> missingCommand;
    Boolean strict;
    boolean fixupMessages;
    private static final String OSGI_NATIVE = "osgi.native";
    private static final String OS_NAME = "osname";
    private static final String OS_VERSION = "osversion";
    private static final String OS_PROCESSOR = "processor";
    List<Report.Location> locations = new ArrayList<Report.Location>();
    Version upto = null;

    public Processor() {
        this.properties = new Properties();
    }

    public Processor(Properties parent) {
        this.properties = new Properties(parent);
    }

    public Processor(Processor child) {
        this(child.properties);
        this.parent = child;
    }

    public void setParent(Processor processor) {
        this.parent = processor;
        Properties ext = new Properties(processor.properties);
        ext.putAll((Map<?, ?>)this.properties);
        this.properties = ext;
    }

    public Processor getParent() {
        return this.parent;
    }

    public Processor getTop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTop();
    }

    public void getInfo(Reporter processor, String prefix) {
        if (prefix == null) {
            prefix = this.getBase() + " :";
        }
        if (this.isFailOk()) {
            this.addAll(this.warnings, processor.getErrors(), prefix, processor);
        } else {
            this.addAll(this.errors, processor.getErrors(), prefix, processor);
        }
        this.addAll(this.warnings, processor.getWarnings(), prefix, processor);
        processor.getErrors().clear();
        processor.getWarnings().clear();
    }

    public void getInfo(Reporter processor) {
        this.getInfo(processor, "");
    }

    private void addAll(List<String> to, List<String> from, String prefix, Reporter reporter) {
        try {
            for (String message : from) {
                String newMessage = prefix + message;
                to.add(newMessage);
                Report.Location location = reporter.getLocation(message);
                if (location == null) continue;
                Reporter.SetLocation newer = this.location(newMessage);
                for (Field f : newer.getClass().getFields()) {
                    if ("message".equals(f.getName())) continue;
                    f.set(newer, f.get(location));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Processor current() {
        Processor p = current.get();
        if (p == null) {
            return this;
        }
        return p;
    }

    @Override
    public Reporter.SetLocation warning(String string, Object ... args) {
        this.fixupMessages = false;
        Processor p = this.current();
        String s = Processor.formatArrays(string, args);
        if (!p.warnings.contains(s)) {
            p.warnings.add(s);
        }
        p.signal();
        return this.location(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reporter.SetLocation error(String string, Object ... args) {
        this.fixupMessages = false;
        Processor p = this.current();
        try {
            if (p.isFailOk()) {
                Reporter.SetLocation setLocation = p.warning(string, args);
                return setLocation;
            }
            String s = Processor.formatArrays(string, args == null ? new Object[]{} : args);
            if (!p.errors.contains(s)) {
                p.errors.add(s);
            }
            Reporter.SetLocation setLocation = this.location(s);
            return setLocation;
        }
        finally {
            p.signal();
        }
    }

    @Override
    public void progress(float progress, String format, Object ... args) {
        format = progress > 0.0f ? String.format("[%2d] %s%n", (int)progress, format) : String.format("%s%n", format);
        System.err.printf(format, args);
    }

    public void progress(String format, Object ... args) {
        this.progress(-1.0f, format, args);
    }

    @Override
    public Reporter.SetLocation exception(Throwable t, String format, Object ... args) {
        return this.error(format, t, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reporter.SetLocation error(String string, Throwable t, Object ... args) {
        Processor p = this.current();
        try {
            if (p.exceptions) {
                this.printExceptionSummary(t, System.err);
            }
            if (p.isFailOk()) {
                Reporter.SetLocation setLocation = p.warning(string + ": " + t, args);
                return setLocation;
            }
            p.errors.add("Exception: " + t.getMessage());
            String s = Processor.formatArrays(string, args == null ? new Object[]{} : args);
            if (!p.errors.contains(s)) {
                p.errors.add(s);
            }
            Reporter.SetLocation setLocation = this.location(s);
            return setLocation;
        }
        finally {
            p.signal();
        }
    }

    public int printExceptionSummary(Throwable e, PrintStream out) {
        if (e == null) {
            return 0;
        }
        int count = 10;
        int n = this.printExceptionSummary(e.getCause(), out);
        if (n == 0) {
            out.println("Root cause: " + e.getMessage() + "   :" + e.getClass().getName());
            count = Integer.MAX_VALUE;
        } else {
            out.println("Rethrown from: " + ((Object)e).toString());
        }
        out.println();
        this.printStackTrace(e, count, out);
        System.err.println();
        return n + 1;
    }

    public void printStackTrace(Throwable e, int count, PrintStream out) {
        StackTraceElement[] st = e.getStackTrace();
        String previousPkg = null;
        boolean shorted = false;
        if (count < st.length) {
            shorted = true;
            --count;
        }
        for (int i = 0; i < count && i < st.length; ++i) {
            String cname = st[i].getClassName();
            String file = st[i].getFileName();
            String method = st[i].getMethodName();
            int line = st[i].getLineNumber();
            String pkg = Descriptors.getPackage(cname);
            if (PACKAGES_IGNORED.matcher(pkg).matches()) continue;
            String shortName = Descriptors.getShortName(cname);
            pkg = pkg.equals(previousPkg) ? "''" : pkg + "";
            file = file.equals(shortName + ".java") ? "" : " (" + file + ")";
            String l = st[i].isNativeMethod() ? "native" : (line > 0 ? "" + line : "");
            out.printf(" %10s %-40s %s %s%n", l, shortName + "." + method, pkg, file);
            previousPkg = pkg;
        }
        if (shorted) {
            out.println("...");
        }
    }

    public void signal() {
    }

    @Override
    public List<String> getWarnings() {
        this.fixupMessages();
        return this.warnings;
    }

    @Override
    public List<String> getErrors() {
        this.fixupMessages();
        return this.errors;
    }

    public static Parameters parseHeader(String value, Processor logger) {
        return new Parameters(value, logger);
    }

    public Parameters parseHeader(String value) {
        return new Parameters(value, this);
    }

    public void addClose(Closeable jar) {
        assert (jar != null);
        this.toBeClosed.add(jar);
    }

    public void removeClose(Closeable jar) {
        assert (jar != null);
        this.toBeClosed.remove(jar);
    }

    @Override
    public boolean isPedantic() {
        return this.current().pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public void use(Processor reporter) {
        this.setPedantic(reporter.isPedantic());
        this.setTrace(reporter.isTrace());
        this.setFailOk(reporter.isFailOk());
    }

    public static File getFile(File base, String file) {
        return IO.getFile(base, file);
    }

    public File getFile(String file) {
        return Processor.getFile(this.base, file);
    }

    @Override
    public <T> List<T> getPlugins(Class<T> clazz) {
        ArrayList<T> l = new ArrayList<T>();
        Set<Object> all = this.getPlugins();
        for (Object plugin : all) {
            if (!clazz.isInstance(plugin)) continue;
            l.add(clazz.cast(plugin));
        }
        return l;
    }

    @Override
    public <T> T getPlugin(Class<T> clazz) {
        Set<Object> all = this.getPlugins();
        for (Object plugin : all) {
            if (!clazz.isInstance(plugin)) continue;
            return clazz.cast(plugin);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getPlugins() {
        Processor processor = this;
        synchronized (processor) {
            if (this.plugins != null) {
                return this.plugins;
            }
            this.plugins = new LinkedHashSet<Object>();
            this.missingCommand = new HashSet();
        }
        this.plugins.add(this);
        this.setTypeSpecificPlugins(this.plugins);
        if (this.parent != null) {
            this.plugins.addAll(this.parent.getPlugins());
        }
        if (this.properties.containsKey("-plugin")) {
            String spe = this.getProperty("-plugin");
            if (spe.equals("none")) {
                return new LinkedHashSet<Object>();
            }
            String pluginPath = this.getProperty("-pluginpath");
            this.loadPlugins(this.plugins, spe, pluginPath);
        }
        this.addExtensions(this.plugins);
        return this.plugins;
    }

    protected void addExtensions(Set<Object> plugins) {
    }

    protected void loadPlugins(Set<Object> instances, String pluginString, String pluginPathString) {
        Attrs attrs;
        String className;
        Parameters plugins = new Parameters(pluginString);
        CL loader = this.getLoader();
        for (Map.Entry<String, Attrs> entry : plugins.entrySet()) {
            String key = Processor.removeDuplicateMarker(entry.getKey());
            String path = entry.getValue().get("path:");
            if (path == null) continue;
            String[] parts = path.split(LIST_SPLITTER);
            try {
                for (String p : parts) {
                    File f = this.getFile(p).getAbsoluteFile();
                    loader.add(f.toURI().toURL());
                }
            }
            catch (Exception e) {
                this.error("Problem adding path %s to loader for plugin %s. Exception: (%s)", path, key, e);
            }
        }
        HashSet<String> loaded = new HashSet<String>();
        for (Map.Entry<String, Attrs> entry : plugins.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            this.trace("Trying pre-plugin %s", className);
            Object plugin = this.loadPlugin(this.getClass().getClassLoader(), attrs, className, true);
            if (plugin == null) continue;
            loaded.add(entry.getKey());
            instances.add(plugin);
        }
        plugins.keySet().removeAll(loaded);
        this.loadPluginPath(instances, pluginPathString, loader);
        for (Map.Entry<String, Attrs> entry : plugins.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            this.trace("Loading secondary plugin %s", className);
            String commands = attrs.get("command:");
            Object plugin = this.loadPlugin(loader, attrs, className, commands != null);
            if (plugin != null) {
                instances.add(plugin);
                continue;
            }
            if (commands == null) {
                this.error("Cannot load the plugin %s", className);
                continue;
            }
            Collection<String> cs = Processor.split(commands);
            this.missingCommand.addAll(cs);
        }
    }

    private void loadPluginPath(Set<Object> instances, String pluginPath, CL loader) {
        Parameters pluginpath = new Parameters(pluginPath);
        for (Map.Entry<String, Attrs> entry : pluginpath.entrySet()) {
            File f;
            block11: {
                f = this.getFile(entry.getKey()).getAbsoluteFile();
                if (!f.isFile()) {
                    String url = entry.getValue().get("url");
                    if (url != null) {
                        try {
                            this.trace("downloading %s to %s", url, f.getAbsoluteFile());
                            URL u = new URL(url);
                            URLConnection connection = u.openConnection();
                            for (Object plugin : instances) {
                                URLConnectionHandler handler;
                                if (!(plugin instanceof URLConnectionHandler) || !(handler = (URLConnectionHandler)plugin).matches(u)) continue;
                                handler.handle(connection);
                            }
                            f.getParentFile().mkdirs();
                            IO.copy(connection.getInputStream(), f);
                            String digest = entry.getValue().get("sha1");
                            if (digest == null) break block11;
                            if (Hex.isHex(digest.trim())) {
                                byte[] filesha1;
                                byte[] sha1 = Hex.toByteArray(digest);
                                if (!Arrays.equals(sha1, filesha1 = SHA1.digest(f).digest())) {
                                    this.error("Plugin path: %s, specified url %s and a sha1 but the file does not match the sha", entry.getKey(), url);
                                }
                            } else {
                                this.error("Plugin path: %s, specified url %s and a sha1 '%s' but this is not a hexadecimal", entry.getKey(), url, digest);
                            }
                            break block11;
                        }
                        catch (Exception e) {
                            this.error("Failed to download plugin %s from %s, error %s", entry.getKey(), url, e);
                            continue;
                        }
                    }
                    this.error("No such file %s from %s and no 'url' attribute on the path so it can be downloaded", entry.getKey(), this);
                    continue;
                }
            }
            this.trace("Adding %s to loader for plugins", f);
            try {
                loader.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
    }

    private Object loadPlugin(ClassLoader loader, Attrs attrs, String className, boolean ignoreError) {
        try {
            Class<?> c = loader.loadClass(className);
            Object plugin = c.newInstance();
            this.customize(plugin, attrs);
            if (plugin instanceof Closeable) {
                this.addClose((Closeable)plugin);
            }
            return plugin;
        }
        catch (NoClassDefFoundError e) {
            if (!ignoreError) {
                this.error("Failed to load plugin %s;%s, error: %s ", className, attrs, e.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            if (!ignoreError) {
                this.error("Failed to load plugin %s;%s, error: %s ", className, attrs, e.getMessage());
            }
        }
        catch (Exception e) {
            this.error("Unexpected error loading plugin %s-%s: %s", className, attrs, e);
        }
        return null;
    }

    protected void setTypeSpecificPlugins(Set<Object> list) {
        list.add(executor);
        list.add(random);
        list.addAll(this.basicPlugins);
    }

    protected <T> T customize(T plugin, Attrs map) {
        if (plugin instanceof Plugin) {
            ((Plugin)plugin).setReporter(this);
            try {
                if (map == null) {
                    map = Attrs.EMPTY_ATTRS;
                }
                ((Plugin)plugin).setProperties(map);
            }
            catch (Exception e) {
                this.error("While setting properties %s on plugin %s, %s", map, plugin, e);
            }
        }
        if (plugin instanceof RegistryPlugin) {
            ((RegistryPlugin)plugin).setRegistry(this);
        }
        return plugin;
    }

    @Override
    public boolean isFailOk() {
        String v = this.getProperty("-failok", null);
        return v != null && v.equalsIgnoreCase("true");
    }

    public File getBase() {
        return this.base;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public void clear() {
        this.errors.clear();
        this.warnings.clear();
        this.locations.clear();
        this.fixupMessages = false;
    }

    @Override
    public void trace(String msg, Object ... parms) {
        Processor p = this.current();
        if (p.trace) {
            System.err.printf("# " + msg + "%n", parms);
        }
    }

    public <T> List<T> newList() {
        return new ArrayList();
    }

    public <T> Set<T> newSet() {
        return new TreeSet();
    }

    public static <K, V> Map<K, V> newMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new LinkedHashMap();
    }

    public <T> List<T> newList(Collection<T> t) {
        return new ArrayList<T>(t);
    }

    public <T> Set<T> newSet(Collection<T> t) {
        return new TreeSet<T>(t);
    }

    public <K, V> Map<K, V> newMap(Map<K, V> t) {
        return new LinkedHashMap<K, V>(t);
    }

    @Override
    public void close() {
        for (Closeable c : this.toBeClosed) {
            try {
                c.close();
            }
            catch (IOException iOException) {}
        }
        this.toBeClosed.clear();
    }

    public String _basedir(String[] args) {
        if (this.base == null) {
            throw new IllegalArgumentException("No base dir set");
        }
        return this.base.getAbsolutePath();
    }

    public Properties getProperties() {
        if (this.fixup) {
            this.fixup = false;
            this.begin();
        }
        this.fixupMessages = false;
        return this.properties;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public void mergeProperties(File file, boolean override) {
        if (file.isFile()) {
            try {
                Properties properties = this.loadProperties(file);
                this.mergeProperties(properties, override);
            }
            catch (Exception e) {
                this.error("Error loading properties file: " + file, new Object[0]);
            }
        } else if (!file.exists()) {
            this.error("Properties file does not exist: " + file, new Object[0]);
        } else {
            this.error("Properties file must a file, not a directory: " + file, new Object[0]);
        }
    }

    public void mergeProperties(Properties properties, boolean override) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            if (!override && this.getProperties().containsKey(key)) continue;
            this.setProperty(key, value);
        }
    }

    public void setProperties(Properties properties) {
        this.doIncludes(this.getBase(), properties);
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addProperties(File file) throws Exception {
        this.addIncluded(file);
        Properties p = this.loadProperties(file);
        this.setProperties(p);
    }

    public void addProperties(Map<?, ?> properties) {
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            this.setProperty(entry.getKey().toString(), entry.getValue() + "");
        }
    }

    public synchronized void addIncluded(File file) {
        if (this.included == null) {
            this.included = new ArrayList<File>();
        }
        this.included.add(file);
    }

    private void doIncludes(File ubase, Properties p) {
        String includes = p.getProperty("-include");
        if (includes != null) {
            includes = this.getReplacer().process(includes);
            p.remove("-include");
            Set<String> clauses = new Parameters(includes).keySet();
            for (String value : clauses) {
                boolean fileMustExist = true;
                boolean overwrite = true;
                while (true) {
                    if (value.startsWith("-")) {
                        fileMustExist = false;
                        value = value.substring(1).trim();
                        continue;
                    }
                    if (!value.startsWith("~")) break;
                    overwrite = false;
                    value = value.substring(1).trim();
                }
                try {
                    File file = Processor.getFile(ubase, value).getAbsoluteFile();
                    if (!file.isFile() && fileMustExist) {
                        this.error("Included file " + file + (file.exists() ? " does not exist" : " is directory"), new Object[0]);
                        continue;
                    }
                    this.doIncludeFile(file, overwrite, p);
                }
                catch (Exception e) {
                    if (!fileMustExist) continue;
                    this.error("Error in processing included file: " + value, e, new Object[0]);
                }
            }
        }
    }

    public void doIncludeFile(File file, boolean overwrite, Properties target) throws Exception {
        this.doIncludeFile(file, overwrite, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIncludeFile(File file, boolean overwrite, Properties target, String extensionName) throws Exception {
        if (this.included != null && this.included.contains(file)) {
            this.error("Cyclic or multiple include of " + file, new Object[0]);
        } else {
            this.addIncluded(file);
            this.updateModified(file.lastModified(), ((Object)file).toString());
            FileInputStream in = new FileInputStream(file);
            try {
                Properties sub = file.getName().toLowerCase().endsWith(".mf") ? Processor.getManifestAsProperties(in) : this.loadProperties(in, file.getAbsolutePath());
                this.doIncludes(file.getParentFile(), sub);
                for (Map.Entry<Object, Object> entry : sub.entrySet()) {
                    String extensionKey;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (overwrite || !target.containsKey(key)) {
                        target.setProperty(key, value);
                        continue;
                    }
                    if (extensionName == null || target.containsKey(extensionKey = extensionName + "." + key)) continue;
                    target.setProperty(extensionKey, value);
                }
            }
            finally {
                IO.close(in);
            }
        }
    }

    public void unsetProperty(String string) {
        this.getProperties().remove(string);
    }

    public boolean refresh() {
        this.plugins = null;
        if (this.propertiesFile == null) {
            return false;
        }
        boolean changed = this.updateModified(this.propertiesFile.lastModified(), "properties file");
        if (this.included != null) {
            for (File file : this.included) {
                if (changed) break;
                changed |= !file.exists() || this.updateModified(file.lastModified(), "include file: " + file);
            }
        }
        this.profile = this.getProperty("-profile");
        if (changed) {
            this.forceRefresh();
            return true;
        }
        return false;
    }

    boolean isStrict() {
        if (this.strict == null) {
            this.strict = Processor.isTrue(this.getProperty("-strict"));
        }
        return this.strict;
    }

    public void forceRefresh() {
        this.included = null;
        this.properties.clear();
        this.setProperties(this.propertiesFile, this.base);
        this.propertiesChanged();
    }

    public void propertiesChanged() {
    }

    public void setProperties(File propertiesFile) throws IOException {
        propertiesFile = propertiesFile.getAbsoluteFile();
        this.setProperties(propertiesFile, propertiesFile.getParentFile());
    }

    public void setProperties(File propertiesFile, File base) {
        this.propertiesFile = propertiesFile.getAbsoluteFile();
        this.setBase(base);
        try {
            if (propertiesFile.isFile()) {
                long modified = propertiesFile.lastModified();
                if (modified > System.currentTimeMillis() + 100L) {
                    System.err.println("Huh? This is in the future " + propertiesFile);
                    this.modified = System.currentTimeMillis();
                } else {
                    this.modified = modified;
                }
                this.included = null;
                Properties p = this.loadProperties(propertiesFile);
                this.setProperties(p);
            } else if (this.fileMustExist) {
                this.error("No such properties file: " + propertiesFile, new Object[0]);
            }
        }
        catch (IOException e) {
            this.error("Could not load properties " + propertiesFile, new Object[0]);
        }
    }

    protected void begin() {
        if (Processor.isTrue(this.getProperty("-pedantic"))) {
            this.setPedantic(true);
        }
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("off".equalsIgnoreCase(value)) {
            return false;
        }
        return !"not".equalsIgnoreCase(value);
    }

    public String getUnprocessedProperty(String key, String deflt) {
        return this.getProperties().getProperty(key, deflt);
    }

    public String getProperty(String key, String deflt) {
        Processor source;
        String value = null;
        Instruction ins = new Instruction(key);
        if (!ins.isLiteral()) {
            SortedList<String> sortedList = SortedList.fromIterator(this.iterator());
            StringBuilder sb = new StringBuilder();
            String del = "";
            for (String k : sortedList) {
                String v;
                if (!ins.matches(k) || (v = this.getProperty(k, null)) == null) continue;
                sb.append(del);
                del = ",";
                sb.append(v);
            }
            if (sb.length() == 0) {
                return deflt;
            }
            return sb.toString();
        }
        if (this.filter != null && this.filter.contains(key)) {
            value = (String)this.getProperties().get(key);
        } else {
            for (source = this; source != null && (value = (String)source.getProperties().get(key)) == null; source = source.getParent()) {
            }
            if (value == null) {
                value = this.getReplacer().getMacro(key, null);
            }
        }
        if (value != null) {
            return this.getReplacer().process(value, source);
        }
        if (deflt != null) {
            return this.getReplacer().process(deflt, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(File file) throws IOException {
        this.updateModified(file.lastModified(), "Properties file: " + file);
        FileInputStream in = new FileInputStream(file);
        try {
            Properties p;
            Properties properties = p = this.loadProperties(in, file.getAbsolutePath());
            return properties;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    Properties loadProperties(InputStream in, String name) throws IOException {
        int n = name.lastIndexOf(47);
        if (n > 0) {
            name = name.substring(0, n);
        }
        if (name.length() == 0) {
            name = ".";
        }
        try {
            Properties p = new Properties();
            p.load(in);
            return Processor.replaceAll(p, "\\$\\{\\.\\}", name);
        }
        catch (Exception e) {
            this.error("Error during loading properties file: " + name + ", error:" + e, new Object[0]);
            return new Properties();
        }
    }

    public static Properties replaceAll(Properties p, String pattern, String replacement) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = value.replaceAll(pattern, replacement);
            result.put(key, value);
        }
        return result;
    }

    public static String printClauses(Map<?, ? extends Map<?, ?>> exports) throws IOException {
        return Processor.printClauses(exports, false);
    }

    public static String printClauses(Map<?, ? extends Map<?, ?>> exports, boolean checkMultipleVersions) throws IOException {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Map.Entry<?, Map<?, ?>> entry : exports.entrySet()) {
            String name = entry.getKey().toString();
            Map<?, ?> clause = entry.getValue();
            String outname = Processor.removeDuplicateMarker(name);
            sb.append(del);
            sb.append(outname);
            Processor.printClause(clause, sb);
            del = ",";
        }
        return sb.toString();
    }

    public static void printClause(Map<?, ?> map, StringBuilder sb) throws IOException {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key.equals("-noimport:") || key.equals("provide:") || key.equals("-split-package:") || key.equals("from:")) continue;
            String value = ((String)entry.getValue()).trim();
            sb.append(";");
            sb.append(key);
            sb.append("=");
            Processor.quote(sb, value);
        }
    }

    public static boolean quote(Appendable sb, String value) throws IOException {
        boolean clean;
        if (value.startsWith("\\\"")) {
            value = value.substring(2);
        }
        if (value.endsWith("\\\"")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        boolean bl = clean = value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' || Verifier.TOKEN.matcher(value).matches();
        if (!clean) {
            sb.append("\"");
        }
        block3: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append('\\').append('\"');
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (!clean) {
            sb.append("\"");
        }
        return clean;
    }

    public Macro getReplacer() {
        if (this.replacer == null) {
            this.replacer = new Macro(this, this.getMacroDomains());
            return this.replacer;
        }
        return this.replacer;
    }

    protected Object[] getMacroDomains() {
        return new Object[0];
    }

    public Properties getFlattenedProperties() {
        return this.getReplacer().getFlattenedProperties();
    }

    public Properties getFlattenedProperties(boolean ignoreInstructions) {
        return this.getReplacer().getFlattenedProperties(ignoreInstructions);
    }

    public Set<String> getPropertyKeys(boolean inherit) {
        Set<Object> result = this.parent == null || !inherit ? Create.set() : this.parent.getPropertyKeys(inherit);
        for (Object o : this.properties.keySet()) {
            result.add(o.toString());
        }
        return result;
    }

    public boolean updateModified(long time, String reason) {
        if (time > this.lastModified) {
            this.lastModified = time;
            return true;
        }
        return false;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setProperty(String key, String value) {
        for (int i = 0; i < headers.length; ++i) {
            if (!headers[i].equalsIgnoreCase(value)) continue;
            value = headers[i];
            break;
        }
        this.getProperties().put(key, value);
    }

    public static Properties getManifestAsProperties(InputStream in) throws IOException {
        Properties p = new Properties();
        Manifest manifest = new Manifest(in);
        for (Attributes.Name name : manifest.getMainAttributes().keySet()) {
            String value = manifest.getMainAttributes().getValue(name);
            p.put(((Object)name).toString(), value);
        }
        return p;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setFileMustExist(boolean mustexist) {
        this.fileMustExist = mustexist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in) throws Exception {
        InputStreamReader ir = new InputStreamReader(in, "UTF8");
        StringBuilder sb = new StringBuilder();
        try {
            char[] chars = new char[4096];
            int size = ir.read(chars);
            while (size > 0) {
                sb.append(chars, 0, size);
                size = ir.read(chars);
            }
        }
        finally {
            ir.close();
        }
        return sb.toString();
    }

    public static String join(Collection<?> list, String delimeter) {
        return Processor.join(delimeter, list);
    }

    public static String join(String delimeter, Collection<?> ... list) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        if (list != null) {
            for (Collection<?> l : list) {
                for (Object item : l) {
                    sb.append(del);
                    sb.append(item);
                    del = delimeter;
                }
            }
        }
        return sb.toString();
    }

    public static String join(Object[] list, String delimeter) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (Object item : list) {
            sb.append(del);
            sb.append(item);
            del = delimeter;
        }
        return sb.toString();
    }

    public static String join(Collection<?> ... list) {
        return Processor.join(",", list);
    }

    public static <T> String join(T[] list) {
        return Processor.join(list, ",");
    }

    public static void split(String s, Collection<String> set) {
        String[] elements;
        for (String element : elements = s.trim().split(LIST_SPLITTER)) {
            if (element.length() <= 0) continue;
            set.add(element);
        }
    }

    public static Collection<String> split(String s) {
        return Processor.split(s, LIST_SPLITTER);
    }

    public static Collection<String> split(String s, String splitter) {
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.trim().length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(s.split(splitter));
    }

    public static String merge(String ... strings) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strings) {
            if (s == null) continue;
            Processor.split(s, result);
        }
        return Processor.join(result);
    }

    public boolean isExceptions() {
        return this.exceptions;
    }

    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    public String normalize(String f) {
        if (f.startsWith(this.base.getAbsolutePath() + "/")) {
            return f.substring(this.base.getAbsolutePath().length() + 1);
        }
        return f;
    }

    public String normalize(File f) {
        return this.normalize(f.getAbsolutePath());
    }

    public static String removeDuplicateMarker(String key) {
        int i;
        for (i = key.length() - 1; i >= 0 && key.charAt(i) == '~'; --i) {
        }
        return key.substring(0, i + 1);
    }

    public static boolean isDuplicate(String name) {
        return name.length() > 0 && name.charAt(name.length() - 1) == '~';
    }

    public void setTrace(boolean x) {
        this.trace = x;
    }

    protected CL getLoader() {
        if (this.pluginLoader == null) {
            this.pluginLoader = new CL();
        }
        return this.pluginLoader;
    }

    public boolean exists() {
        return this.base != null && this.base.isDirectory() && this.propertiesFile != null && this.propertiesFile.isFile();
    }

    @Override
    public boolean isOk() {
        return this.isFailOk() || this.getErrors().size() == 0;
    }

    private void fixupMessages() {
        if (this.fixupMessages) {
            return;
        }
        this.fixupMessages = true;
        Parameters fixup = new Parameters(this.getProperty("-fixupmessages"));
        if (fixup.isEmpty()) {
            return;
        }
        Instructions instrs = new Instructions(fixup);
        this.doFixup(instrs, this.errors, this.warnings, "error");
        this.doFixup(instrs, this.warnings, this.errors, "warning");
    }

    private void doFixup(Instructions instrs, List<String> messages, List<String> other, String type) {
        for (int i = 0; i < messages.size(); ++i) {
            Attrs attrs;
            String restrict;
            String message = messages.get(i);
            Instruction matcher = instrs.finder(message);
            if (matcher == null || matcher.isNegated() || (restrict = (attrs = instrs.get(matcher)).get("restrict:")) != null && !"error".equals(restrict)) continue;
            String replace = attrs.get("replace:");
            if (replace != null) {
                this.trace("replacing %s with %s", message, replace);
                this.setProperty("@", message);
                message = this.getReplacer().process(replace);
                messages.set(i, message);
                this.unsetProperty("@");
            }
            String is = attrs.get("is:");
            if (attrs.isEmpty() || "ignore".equals(is)) {
                messages.remove(i--);
                continue;
            }
            if (is == null || type.equals(is)) continue;
            messages.remove(i--);
            other.add(message);
        }
    }

    public boolean check(String ... pattern) throws IOException {
        Set missed = Create.set();
        if (pattern != null) {
            for (String p : pattern) {
                boolean match = false;
                Pattern pat = Pattern.compile(p);
                Iterator<String> i = this.errors.iterator();
                while (i.hasNext()) {
                    if (!pat.matcher(i.next()).find()) continue;
                    i.remove();
                    match = true;
                }
                i = this.warnings.iterator();
                while (i.hasNext()) {
                    if (!pat.matcher(i.next()).find()) continue;
                    i.remove();
                    match = true;
                }
                if (match) continue;
                missed.add(p);
            }
        }
        if (missed.isEmpty() && this.isPerfect()) {
            return true;
        }
        if (!missed.isEmpty()) {
            System.err.println("Missed the following patterns in the warnings or errors: " + missed);
        }
        this.report(System.err);
        return false;
    }

    protected void report(Appendable out) throws IOException {
        int i;
        if (this.errors.size() > 0) {
            out.append(String.format("-----------------%nErrors%n", new Object[0]));
            for (i = 0; i < this.errors.size(); ++i) {
                out.append(String.format("%03d: %s%n", i, this.errors.get(i)));
            }
        }
        if (this.warnings.size() > 0) {
            out.append(String.format("-----------------%nWarnings%n", new Object[0]));
            for (i = 0; i < this.warnings.size(); ++i) {
                out.append(String.format("%03d: %s%n", i, this.warnings.get(i)));
            }
        }
    }

    public boolean isPerfect() {
        return this.getErrors().size() == 0 && this.getWarnings().size() == 0;
    }

    public void setForceLocal(Collection<String> local) {
        this.filter = local;
    }

    public boolean isMissingPlugin(String name) {
        this.getPlugins();
        return this.missingCommand != null && this.missingCommand.contains(name);
    }

    public static String appendPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        boolean lastSlash = true;
        for (String part : parts) {
            for (int i = 0; i < part.length(); ++i) {
                char c = part.charAt(i);
                if (c == '/') {
                    if (!lastSlash) {
                        sb.append('/');
                    }
                    lastSlash = true;
                    continue;
                }
                sb.append(c);
                lastSlash = false;
            }
            if (lastSlash || sb.length() <= 0) continue;
            sb.append('/');
            lastSlash = true;
        }
        if (lastSlash && sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Attrs doAttrbutes(Object[] attrs, Clazz clazz, Macro macro) {
        Attrs map = new Attrs();
        if (attrs == null || attrs.length == 0) {
            return map;
        }
        for (Object a : attrs) {
            String attr = (String)a;
            int n = attr.indexOf("=");
            if (n <= 0) {
                throw new IllegalArgumentException(Processor.formatArrays("Invalid attribute on package-info.java in %s , %s. Must be <key>=<name> ", clazz, attr));
            }
            map.put(attr.substring(0, n), macro.process(attr.substring(n + 1)));
        }
        return map;
    }

    public static String formatArrays(String string, Object ... parms) {
        Object[] parms2 = parms;
        Object[] output = new Object[parms.length];
        for (int i = 0; i < parms.length; ++i) {
            output[i] = Processor.makePrintable(parms[i]);
        }
        return String.format(string, parms2);
    }

    public static Object makePrintable(Object object) {
        if (object == null) {
            return object;
        }
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            Object[] output = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                output[i] = Processor.makePrintable(array[i]);
            }
            return Arrays.toString(output);
        }
        return object;
    }

    public static String append(String ... strings) {
        List result = Create.list();
        for (String s : strings) {
            result.addAll(Processor.split(s));
        }
        return Processor.join(result);
    }

    public synchronized Class<?> getClass(String type, File jar) throws Exception {
        CL cl = this.getLoader();
        cl.add(jar.toURI().toURL());
        return cl.loadClass(type);
    }

    public boolean isTrace() {
        return this.current().trace;
    }

    public static long getDuration(String tm, long dflt) {
        if (tm == null) {
            return dflt;
        }
        tm = tm.toUpperCase();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        Matcher m = Pattern.compile("\\s*(\\d+)\\s*(NANOSECONDS|MICROSECONDS|MILLISECONDS|SECONDS|MINUTES|HOURS|DAYS)?").matcher(tm);
        if (m.matches()) {
            long duration = Long.parseLong(tm);
            String u = m.group(2);
            if (u != null) {
                unit = TimeUnit.valueOf(u);
            }
            duration = TimeUnit.MILLISECONDS.convert(duration, unit);
            return duration;
        }
        return dflt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _random(String[] args) {
        int numchars = 8;
        if (args.length > 1) {
            try {
                numchars = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid character count parameter in ${random} macro.");
            }
        }
        Class<Processor> e = Processor.class;
        synchronized (Processor.class) {
            if (random == null) {
                random = new Random();
            }
            // ** MonitorExit[e] (shouldn't be in output)
            char[] letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
            char[] alphanums = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
            char[] array = new char[numchars];
            for (int i = 0; i < numchars; ++i) {
                char c = i == 0 ? letters[random.nextInt(letters.length)] : alphanums[random.nextInt(alphanums.length)];
                array[i] = c;
            }
            return new String(array);
        }
    }

    public String _native_capability(String[] args) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder().append(OSGI_NATIVE);
        String processorNames = null;
        OSInformation osInformation = null;
        IllegalArgumentException osInformationException = null;
        String[] aliases = OSInformation.getProcessorAliases(System.getProperty("os.arch"));
        if (aliases != null) {
            processorNames = Strings.join(aliases);
        }
        try {
            osInformation = new OSInformation();
        }
        catch (IllegalArgumentException e) {
            osInformationException = e;
        }
        String osnameOverride = null;
        Version osversionOverride = null;
        String processorNamesOverride = null;
        if (args.length > 1) {
            assert ("native_capability".equals(args[0]));
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                String[] fields = arg.split("=", 2);
                if (fields.length != 2) {
                    throw new IllegalArgumentException("Illegal property syntax in \"" + arg + "\", use \"key=value\"");
                }
                String key = fields[0];
                String value = fields[1];
                if (OS_NAME.equals(key)) {
                    osnameOverride = value;
                    continue;
                }
                if (OS_VERSION.equals(key)) {
                    osversionOverride = new Version(value);
                    continue;
                }
                if (OS_PROCESSOR.equals(key)) {
                    processorNamesOverride = value;
                    continue;
                }
                throw new IllegalArgumentException("Unrecognised/unsupported property. Supported: osname, osversion, processor.");
            }
        }
        if (osnameOverride == null && osInformation != null) {
            osnameOverride = osInformation.osnames;
        }
        if (osversionOverride == null && osInformation != null) {
            osversionOverride = osInformation.osversion;
        }
        if (processorNamesOverride == null && processorNames != null) {
            processorNamesOverride = processorNames;
        }
        builder.append(";osgi.native.osname:List<String>=\"").append(osnameOverride).append('\"');
        builder.append(";osgi.native.osversion:Version=").append(osversionOverride);
        builder.append(";osgi.native.processor:List<String>=\"").append(processorNamesOverride).append('\"');
        if (osnameOverride == null || osversionOverride == null || processorNamesOverride == null) {
            throw new IllegalArgumentException("At least one of the required parameters could not be detected; specify an override. Detected: " + builder.toString(), osInformationException);
        }
        return builder.toString();
    }

    protected Processor beginHandleErrors(String message) {
        this.trace("begin %s", message);
        Processor previous = current.get();
        current.set(this);
        return previous;
    }

    protected void endHandleErrors(Processor previous) {
        this.trace("end", new Object[0]);
        current.set(previous);
    }

    public static Executor getExecutor() {
        return executor;
    }

    public synchronized void addBasicPlugin(Object plugin) {
        this.basicPlugins.add(plugin);
        if (this.plugins != null) {
            this.plugins.add(plugin);
        }
    }

    public synchronized void removeBasicPlugin(Object plugin) {
        this.basicPlugins.remove(plugin);
        if (this.plugins != null) {
            this.plugins.remove(plugin);
        }
    }

    public List<File> getIncluded() {
        return this.included;
    }

    @Override
    public String get(String key) {
        return this.getProperty(key);
    }

    @Override
    public String get(String key, String deflt) {
        return this.getProperty(key, deflt);
    }

    @Override
    public void set(String key, String value) {
        this.getProperties().setProperty(key, value);
    }

    @Override
    public Iterator<String> iterator() {
        Set<String> keys = this.keySet();
        final Iterator<String> it = keys.iterator();
        return new Iterator<String>(){
            String current;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public String next() {
                this.current = ((String)it.next()).toString();
                return this.current;
            }

            @Override
            public void remove() {
                Processor.this.getProperties().remove(this.current);
            }
        };
    }

    public Set<String> keySet() {
        Set<Object> set = this.parent == null ? Create.set() : this.parent.keySet();
        for (Object o : this.properties.keySet()) {
            set.add(o.toString());
        }
        return set;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.report(sb);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String replaceExtension(String s, String extension, String newExtension) {
        if (s.endsWith(extension)) {
            s = s.substring(0, s.length() - extension.length());
        }
        return s + newExtension;
    }

    private Reporter.SetLocation location(String s) {
        SetLocationImpl loc = new SetLocationImpl(s);
        this.locations.add(loc);
        return loc;
    }

    @Override
    public Report.Location getLocation(String msg) {
        for (Report.Location l : this.locations) {
            if (l.message == null || !l.message.equals(msg)) continue;
            return l;
        }
        return null;
    }

    public FileLine getHeader(String header) throws Exception {
        return this.getHeader(Pattern.compile("^[ \t]*" + Pattern.quote(header), 10));
    }

    public FileLine getHeader(Pattern header) throws Exception {
        FileLine fl = this.getHeader0(header);
        if (fl != null) {
            return fl;
        }
        Processor rover = this;
        while (rover.getPropertiesFile() == null) {
            if (rover.parent == null) {
                return new FileLine(new File("ANONYMOUS"), 0, 0);
            }
            rover = rover.parent;
        }
        return new FileLine(rover.getPropertiesFile(), 0, 0);
    }

    private FileLine getHeader0(Pattern header) throws Exception {
        FileLine fl;
        File f = this.getPropertiesFile();
        if (f != null) {
            fl = Processor.findHeader(f, header);
            if (fl != null) {
                return fl;
            }
            List<File> result = this.getIncluded();
            if (result != null) {
                ExtList<File> reversed = new ExtList<File>((Collection<File>)result);
                Collections.reverse(reversed);
                for (File included : reversed) {
                    fl = Processor.findHeader(included, header);
                    if (fl == null) continue;
                    return fl;
                }
            }
        }
        if (this.getParent() != null && (fl = this.getParent().getHeader(header)) != null) {
            return fl;
        }
        if (f == null && this.parent != null) {
            f = this.parent.getPropertiesFile();
        }
        if (f == null) {
            return null;
        }
        return new FileLine(f, 0, 0);
    }

    public static FileLine findHeader(File f, String header) throws IOException {
        return Processor.findHeader(f, Pattern.compile("^[ \t]*" + Pattern.quote(header), 10));
    }

    public static FileLine findHeader(File f, Pattern header) throws IOException {
        String s = IO.collect(f);
        Matcher matcher = header.matcher(s);
        if (!matcher.find()) {
            return null;
        }
        return new FileLine(f, Processor.getLine(s, matcher.start(0)), matcher.group().length());
    }

    public static int getLine(String s, int index) {
        int n = 0;
        while (--index > 0) {
            char c = s.charAt(index);
            if (c != '\n') continue;
            ++n;
        }
        return n;
    }

    public boolean since(Version introduced) {
        if (this.upto == null) {
            String uptov = this.getProperty("-upto");
            if (uptov == null) {
                this.upto = Version.HIGHEST;
                return true;
            }
            if (!Version.VERSION.matcher(uptov).matches()) {
                this.error("The %s given version is not a version: %s", "-upto", uptov);
                this.upto = Version.HIGHEST;
                return true;
            }
            this.upto = new Version(uptov);
        }
        return this.upto.compareTo(introduced) >= 0;
    }

    public void report(Map<String, Object> table) throws Exception {
        table.put("Included Files", this.getIncluded());
        table.put("Base", this.getBase());
        table.put("Properties", this.properties.entrySet());
    }

    public boolean is(String propertyName) {
        return Processor.isTrue(this.getProperty(propertyName));
    }

    static class SetLocationImpl
    extends Report.Location
    implements Reporter.SetLocation {
        public SetLocationImpl(String s) {
            this.message = s;
        }

        public Reporter.SetLocation file(String file) {
            this.file = file;
            return this;
        }

        public Reporter.SetLocation header(String header) {
            this.header = header;
            return this;
        }

        public Reporter.SetLocation context(String context) {
            this.context = context;
            return this;
        }

        public Reporter.SetLocation method(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Reporter.SetLocation line(int n) {
            this.line = n;
            return this;
        }

        public Reporter.SetLocation reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Reporter.SetLocation details(Object details) {
            this.details = details;
            return this;
        }

        public Report.Location location() {
            return this;
        }

        public Reporter.SetLocation length(int length) {
            this.length = length;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CL
    extends URLClassLoader {
        CL() {
            super(new URL[0], Processor.class.getClassLoader());
        }

        void add(URL url) {
            URL[] urls;
            for (URL u : urls = this.getURLs()) {
                if (!((Object)u).equals(url)) continue;
                return;
            }
            super.addURL(url);
        }

        @Override
        public Class<?> loadClass(String name) throws NoClassDefFoundError {
            try {
                Class<?> c = super.loadClass(name);
                return c;
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append(name);
                sb.append(" not found, parent:  ");
                sb.append(this.getParent());
                sb.append(" urls:");
                sb.append(Arrays.toString(this.getURLs()));
                sb.append(" exception:");
                sb.append(t);
                throw new NoClassDefFoundError(sb.toString());
            }
        }
    }

    public static class FileLine {
        public static final FileLine DUMMY = new FileLine(null, 0, 0);
        public final File file;
        public final int line;
        public final int length;

        public FileLine(File file, int line, int length) {
            this.file = file;
            this.line = line;
            this.length = length;
        }

        public void set(Reporter.SetLocation sl) {
            sl.file(this.file.getAbsolutePath());
            sl.line(this.line);
            sl.length(this.length);
        }
    }
}

