/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.util.http.auth.Credentials;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;

public class BasicOsgiBundleWithUrl
implements CatalogItem.CatalogBundle,
OsgiBundleWithUrl {
    private String symbolicName;
    private String version;
    private String url;
    private Credentials credential;

    private BasicOsgiBundleWithUrl() {
    }

    public BasicOsgiBundleWithUrl(String name, String version, String url) {
        this(name, version, url, null);
    }

    public BasicOsgiBundleWithUrl(String name, String version, String url, @Nullable Credentials cred) {
        if (name == null && version == null) {
            Preconditions.checkNotNull((Object)url, (Object)"Either a URL or both name and version are required");
        } else {
            Preconditions.checkNotNull((Object)name, (Object)"Either a URL or both name and version are required");
            Preconditions.checkNotNull((Object)version, (Object)"Either a URL or both name and version are required");
        }
        this.symbolicName = name;
        this.version = version;
        this.url = url;
        this.credential = cred;
    }

    public BasicOsgiBundleWithUrl(OsgiBundleWithUrl b) {
        this(b.getSymbolicName(), b.getSuppliedVersionString(), b.getUrl());
    }

    public boolean isNameResolved() {
        return this.symbolicName != null && this.version != null;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getSuppliedVersionString() {
        return this.version;
    }

    public String getOsgiVersionString() {
        return this.version == null ? this.version : BrooklynVersionSyntax.toValidOsgiVersion((String)this.version);
    }

    public VersionedName getVersionedName() {
        if (!this.isNameResolved()) {
            return null;
        }
        return new VersionedName(this.getSymbolicName(), this.getSuppliedVersionString());
    }

    public String getUrl() {
        return this.url;
    }

    public Credentials getUrlCredential() {
        return this.credential;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbolicName", (Object)this.symbolicName).add("version", (Object)this.version).add("url", (Object)this.url).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.version, this.url});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OsgiBundleWithUrl other = (OsgiBundleWithUrl)obj;
        if (!Objects.equal((Object)this.symbolicName, (Object)other.getSymbolicName())) {
            return false;
        }
        if (!Objects.equal((Object)this.getOsgiVersionString(), (Object)other.getOsgiVersionString())) {
            return false;
        }
        return Objects.equal((Object)this.url, (Object)other.getUrl());
    }
}

