/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import javax.annotation.Nullable;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.osgi.framework.Bundle;

@Beta
public class OsgiClassPrefixer {
    public static final String DELIMITER = ":";
    private final Function<Class<?>, Optional<Bundle>> bundleRetriever;

    public OsgiClassPrefixer() {
        this(null);
    }

    @VisibleForTesting
    protected OsgiClassPrefixer(@Nullable Function<Class<?>, Optional<Bundle>> bundleRetriever) {
        this.bundleRetriever = bundleRetriever;
    }

    public Optional<String> getPrefix(Class<?> type) {
        Optional bundle;
        Optional optional = bundle = this.bundleRetriever != null ? (Optional)this.bundleRetriever.apply(type) : Osgis.getBundleOf(type);
        if (bundle.isPresent()) {
            return Optional.of((Object)(((Bundle)bundle.get()).getSymbolicName() + DELIMITER));
        }
        return Optional.absent();
    }

    public Optional<String> stripMatchingPrefix(Bundle bundle, String type) {
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null && type.startsWith(symbolicName + DELIMITER)) {
            return Optional.of((Object)type.substring(type.lastIndexOf(DELIMITER) + 1));
        }
        return Optional.absent();
    }

    public boolean hasPrefix(String type) {
        return type != null && type.contains(DELIMITER);
    }
}

