/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Closeables2;

public class JcloudsVersion {
    @VisibleForTesting
    static final String VERSION_RESOURCE_FILE = "META-INF/maven/org.apache.jclouds/jclouds-core/pom.properties";
    private static final String VERSION_PROPERTY_NAME = "version";
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:-(alpha|beta|rc)\\.(\\d+)|-SNAPSHOT)?");
    private static final String ALPHA_VERSION_IDENTIFIER = "alpha";
    private static final String BETA_VERSION_IDENTIFIER = "beta";
    private static final JcloudsVersion INSTANCE = new JcloudsVersion();
    public final int majorVersion;
    public final int minorVersion;
    public final int patchVersion;
    public final boolean alpha;
    public final boolean beta;
    @Nullable
    public final Integer alphaVersion;
    @Nullable
    public final Integer betaVersion;
    public final boolean releaseCandidate;
    @Nullable
    public final Integer releaseCandidateVersion;
    public final boolean snapshot;
    private final String version;

    @VisibleForTesting
    JcloudsVersion() {
        this(JcloudsVersion.class.getClassLoader());
    }

    @VisibleForTesting
    JcloudsVersion(ClassLoader resourceLoader) {
        this(JcloudsVersion.readVersionPropertyFromClasspath(resourceLoader));
    }

    private static String readVersionPropertyFromClasspath(ClassLoader resourceLoader) {
        Properties versionProperties = new Properties();
        InputStream is = (InputStream)Preconditions.checkNotNull((Object)resourceLoader.getResourceAsStream(VERSION_RESOURCE_FILE), (Object)VERSION_RESOURCE_FILE);
        try {
            versionProperties.load(is);
        }
        catch (IOException exception) {
            throw new IllegalStateException(String.format("Unable to load version resource file '%s'", VERSION_RESOURCE_FILE), exception);
        }
        finally {
            Closeables2.closeQuietly(is);
        }
        return (String)Preconditions.checkNotNull((Object)versionProperties.getProperty(VERSION_PROPERTY_NAME), (Object)VERSION_PROPERTY_NAME);
    }

    @VisibleForTesting
    JcloudsVersion(String version) {
        Matcher versionMatcher = SEMANTIC_VERSION_PATTERN.matcher(version);
        Preconditions.checkArgument((boolean)versionMatcher.matches(), (String)"Version '%s' did not match expected pattern '%s'", (Object[])new Object[]{version, SEMANTIC_VERSION_PATTERN});
        this.version = version;
        this.majorVersion = Integer.parseInt(versionMatcher.group(1));
        this.minorVersion = Integer.parseInt(versionMatcher.group(2));
        this.patchVersion = Integer.parseInt(versionMatcher.group(3));
        String alphaOrBetaOrReleaseCandidateVersionIfPresent = versionMatcher.group(4);
        if (alphaOrBetaOrReleaseCandidateVersionIfPresent != null) {
            Integer alphaOrBetaOrReleaseCandidateVersion = Integer.valueOf(versionMatcher.group(5));
            if (alphaOrBetaOrReleaseCandidateVersionIfPresent.equals(ALPHA_VERSION_IDENTIFIER)) {
                this.alpha = true;
                this.alphaVersion = alphaOrBetaOrReleaseCandidateVersion;
                this.beta = false;
                this.betaVersion = null;
                this.releaseCandidate = false;
                this.releaseCandidateVersion = null;
            } else if (alphaOrBetaOrReleaseCandidateVersionIfPresent.equals(BETA_VERSION_IDENTIFIER)) {
                this.alpha = false;
                this.alphaVersion = null;
                this.beta = true;
                this.betaVersion = alphaOrBetaOrReleaseCandidateVersion;
                this.releaseCandidate = false;
                this.releaseCandidateVersion = null;
            } else {
                this.alpha = false;
                this.alphaVersion = null;
                this.beta = false;
                this.betaVersion = null;
                this.releaseCandidate = true;
                this.releaseCandidateVersion = alphaOrBetaOrReleaseCandidateVersion;
            }
        } else {
            this.alpha = false;
            this.alphaVersion = null;
            this.beta = false;
            this.betaVersion = null;
            this.releaseCandidate = false;
            this.releaseCandidateVersion = null;
        }
        this.snapshot = version.endsWith("-SNAPSHOT");
    }

    public String toString() {
        return this.version;
    }

    public static JcloudsVersion get() {
        return INSTANCE;
    }
}

