/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.database.mysql.InitSlaveTaskBody;
import org.apache.brooklyn.entity.database.mysql.MySqlCluster;
import org.apache.brooklyn.entity.database.mysql.MySqlClusterUtils;
import org.apache.brooklyn.entity.database.mysql.MySqlNode;
import org.apache.brooklyn.entity.database.mysql.MySqlRowParser;
import org.apache.brooklyn.entity.database.mysql.ReplicationSnapshot;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.feed.function.FunctionFeed;
import org.apache.brooklyn.feed.function.FunctionPollConfig;
import org.apache.brooklyn.util.collections.CollectionFunctionals;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.guava.Functionals;
import org.apache.brooklyn.util.guava.IfFunctions;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;

public class MySqlClusterImpl
extends DynamicClusterImpl
implements MySqlCluster {
    private static final AttributeSensor<Boolean> NODE_REPLICATION_INITIALIZED = Sensors.newBooleanSensor((String)"mysql.replication_initialized");
    private static final String MASTER_CONFIG_URL = "classpath:///org/apache/brooklyn/entity/database/mysql/mysql_master.conf";
    private static final String SLAVE_CONFIG_URL = "classpath:///org/apache/brooklyn/entity/database/mysql/mysql_slave.conf";
    protected static final int MASTER_SERVER_ID = 1;
    private static final AttributeSensor<Supplier<Integer>> SLAVE_NEXT_SERVER_ID = Sensors.newSensor((TypeToken)new TypeToken<Supplier<Integer>>(){}, (String)"mysql.slave.next_server_id", (String)"Returns the ID of the next slave server");
    protected static final AttributeSensor<Map<String, String>> SLAVE_ID_ADDRESS_MAPPING = Sensors.newSensor((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"mysql.slave.id_address_mapping", (String)"Maps slave entity IDs to SUBNET_ADDRESS, so the address is known at member remove time.");

    public void init() {
        super.init();
        this.sensors().set(SLAVE_NEXT_SERVER_ID, (Object)new NextServerIdSupplier());
        this.sensors().set(SLAVE_ID_ADDRESS_MAPPING, new ConcurrentHashMap());
        if (this.getConfig((ConfigKey.HasConfigKey)SLAVE_PASSWORD) == null) {
            this.sensors().set((AttributeSensor)SLAVE_PASSWORD, (Object)Identifiers.makeRandomId((int)8));
        } else {
            this.sensors().set((AttributeSensor)SLAVE_PASSWORD, this.getConfig((ConfigKey.HasConfigKey)SLAVE_PASSWORD));
        }
        this.initSubscriptions();
    }

    public void rebind() {
        super.rebind();
        this.initSubscriptions();
    }

    private void initSubscriptions() {
        this.subscriptions().subscribeToMembers((Group)this, (Sensor)MySqlNode.SERVICE_PROCESS_IS_RUNNING, (SensorEventListener)new NodeRunningListener(this));
        this.subscriptions().subscribe((Entity)this, (Sensor)MEMBER_REMOVED, (SensorEventListener)new MemberRemovedListener());
    }

    protected void initEnrichers() {
        super.initEnrichers();
        this.propagateMasterAttribute(MySqlNode.HOSTNAME);
        this.propagateMasterAttribute(MySqlNode.ADDRESS);
        this.propagateMasterAttribute(MySqlNode.SUBNET_HOSTNAME);
        this.propagateMasterAttribute(MySqlNode.SUBNET_ADDRESS);
        this.propagateMasterAttribute((AttributeSensor)MySqlNode.MYSQL_PORT);
        this.propagateMasterAttribute(MySqlNode.DATASTORE_URL);
        this.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(MySqlNode.DATASTORE_URL).publishing(SLAVE_DATASTORE_URL_LIST).computing(Functions.identity())).entityFilter(Predicates.not(MySqlClusterUtils.IS_MASTER))).fromMembers()).build());
        this.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(MySqlNode.QUERIES_PER_SECOND_FROM_MYSQL).publishing(QUERIES_PER_SECOND_FROM_MYSQL_PER_NODE).fromMembers()).computingAverage()).defaultValueForUnreportedSensors((Object)0.0)).build());
    }

    private <T> void propagateMasterAttribute(AttributeSensor<T> att) {
        this.enrichers().add(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating(att).publishing(att).computing((Function)IfFunctions.ifPredicate((Predicate)CollectionFunctionals.notEmpty()).apply(CollectionFunctionals.firstElement()).defaultValue(null))).entityFilter(MySqlClusterUtils.IS_MASTER)).build());
    }

    protected EntitySpec<?> getFirstMemberSpec() {
        EntitySpec firstMemberSpec = super.getFirstMemberSpec();
        if (firstMemberSpec != null) {
            return this.applyDefaults(firstMemberSpec, (Supplier<Integer>)Suppliers.ofInstance((Object)1), MASTER_CONFIG_URL);
        }
        EntitySpec memberSpec = super.getMemberSpec();
        if (memberSpec != null) {
            return this.applyDefaults(memberSpec, (Supplier<Integer>)Suppliers.ofInstance((Object)1), MASTER_CONFIG_URL);
        }
        return (EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(MySqlNode.class).displayName("MySql Master")).configure(MySqlNode.MYSQL_SERVER_ID, (Object)1)).configure(MySqlNode.TEMPLATE_CONFIGURATION_URL, (Object)MASTER_CONFIG_URL);
    }

    protected EntitySpec<?> getMemberSpec() {
        Supplier serverIdSupplier = (Supplier)this.getAttribute(SLAVE_NEXT_SERVER_ID);
        EntitySpec spec = super.getMemberSpec();
        if (spec != null) {
            return this.applyDefaults(spec, (Supplier<Integer>)serverIdSupplier, SLAVE_CONFIG_URL);
        }
        return (EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(MySqlNode.class).displayName("MySql Slave")).configure(MySqlNode.MYSQL_SERVER_ID, serverIdSupplier.get())).configure(MySqlNode.TEMPLATE_CONFIGURATION_URL, (Object)SLAVE_CONFIG_URL);
    }

    private EntitySpec<?> applyDefaults(EntitySpec<?> spec, Supplier<Integer> serverId, String configUrl) {
        boolean needsConfigUrl;
        boolean needsServerId = !this.isKeyConfigured(spec, MySqlNode.MYSQL_SERVER_ID);
        boolean bl = needsConfigUrl = !this.isKeyConfigured(spec, MySqlNode.TEMPLATE_CONFIGURATION_URL.getConfigKey());
        if (needsServerId || needsConfigUrl) {
            EntitySpec clonedSpec = EntitySpec.create(spec);
            if (needsServerId) {
                clonedSpec.configure(MySqlNode.MYSQL_SERVER_ID, serverId.get());
            }
            if (needsConfigUrl) {
                clonedSpec.configure(MySqlNode.TEMPLATE_CONFIGURATION_URL, (Object)configUrl);
            }
            return clonedSpec;
        }
        return spec;
    }

    private boolean isKeyConfigured(EntitySpec<?> spec, ConfigKey<?> key) {
        return spec.getConfig().containsKey(key) || spec.getFlags().containsKey(key.getName());
    }

    protected Entity createNode(Location loc, Map<?, ?> flags) {
        MySqlNode node = (MySqlNode)super.createNode(loc, flags);
        if (!MySqlClusterUtils.IS_MASTER.apply((Object)node)) {
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)node, MySqlCluster.MySqlSlave.SLAVE_HEALTHY, (Object)"Replication not started");
            FunctionFeed.builder().entity((Entity)node).period(Duration.FIVE_SECONDS).poll((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)((FunctionPollConfig)FunctionPollConfig.forSensor(MySqlCluster.MySqlSlave.SLAVE_HEALTHY).callable((Callable)new SlaveStateCallable(node)).checkSuccess(StringPredicates.isNonBlank())).onSuccess((Function)new SlaveStateParser(node))).setOnFailure((Object)false)).description("Polls SHOW SLAVE STATUS")).build(false);
            node.enrichers().add(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(MySqlCluster.MySqlSlave.SLAVE_HEALTHY).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"Slave replication status is not healthy"))).build());
        }
        return node;
    }

    public class MemberRemovedListener
    implements SensorEventListener<Entity> {
        public void onEvent(SensorEvent<Entity> event) {
            MySqlCluster cluster = (MySqlCluster)event.getSource();
            Entity node = (Entity)event.getValue();
            String slaveAddress = (String)((Map)cluster.getAttribute(SLAVE_ID_ADDRESS_MAPPING)).remove(node.getId());
            if (slaveAddress != null) {
                MySqlNode master = (MySqlNode)Iterables.find((Iterable)cluster.getMembers(), MySqlClusterUtils.IS_MASTER);
                String username = MySqlClusterUtils.validateSqlParam((String)cluster.getConfig(MySqlCluster.SLAVE_USERNAME));
                MySqlClusterUtils.executeSqlOnNodeAsync(master, String.format("DROP USER '%s'@'%s';", username, slaveAddress));
            }
        }
    }

    private static class InitMasterTaskBody
    implements Runnable {
        private MySqlNode master;
        private MySqlCluster cluster;

        public InitMasterTaskBody(MySqlCluster cluster, MySqlNode master) {
            this.cluster = cluster;
            this.master = master;
        }

        @Override
        public void run() {
            String creationScript;
            String binLogInfo = MySqlClusterUtils.executeSqlOnNode(this.master, "FLUSH TABLES WITH READ LOCK;SHOW MASTER STATUS \\G UNLOCK TABLES;");
            Map<String, String> status = MySqlRowParser.parseSingle(binLogInfo);
            String file = status.get("File");
            String position = status.get("Position");
            if (file != null && position != null) {
                this.cluster.sensors().set(MySqlCluster.REPLICATION_LAST_SLAVE_SNAPSHOT, (Object)new ReplicationSnapshot(null, null, file, Integer.parseInt(position)));
            }
            if ((creationScript = InitMasterTaskBody.getDatabaseCreationScriptAsString(this.master)) != null) {
                this.master.invoke(MySqlNode.EXECUTE_SCRIPT, (Map)ImmutableMap.of((Object)"commands", (Object)creationScript));
            }
        }

        @Nullable
        private static String getDatabaseCreationScriptAsString(Entity entity) {
            String url = (String)entity.getConfig(MySqlCluster.MySqlMaster.MASTER_CREATION_SCRIPT_URL);
            if (!Strings.isBlank((CharSequence)url)) {
                return new ResourceUtils((Object)entity).getResourceAsString(url);
            }
            String contents = (String)entity.getConfig(MySqlCluster.MySqlMaster.MASTER_CREATION_SCRIPT_CONTENTS);
            if (!Strings.isBlank((CharSequence)contents)) {
                return contents;
            }
            return null;
        }
    }

    private static final class NodeRunningListener
    implements SensorEventListener<Boolean> {
        private MySqlCluster cluster;
        private Semaphore lock = new Semaphore(1);

        public NodeRunningListener(MySqlCluster cluster) {
            this.cluster = cluster;
        }

        public void onEvent(SensorEvent<Boolean> event) {
            MySqlNode node = (MySqlNode)event.getSource();
            if (Boolean.TRUE.equals(event.getValue()) && Boolean.FALSE.equals(node.getAttribute(MySqlNode.SERVICE_UP)) && !Boolean.TRUE.equals(node.getAttribute(NODE_REPLICATION_INITIALIZED))) {
                node.sensors().set(NODE_REPLICATION_INITIALIZED, (Object)Boolean.TRUE);
                Runnable nodeInitTaskBody = MySqlClusterUtils.IS_MASTER.apply((Object)node) ? new InitMasterTaskBody(this.cluster, node) : new InitSlaveTaskBody(this.cluster, node, this.lock);
                DynamicTasks.submitTopLevelTask((TaskAdaptable)TaskBuilder.builder().displayName("setup master-slave replication").body(nodeInitTaskBody).tag((Object)"NON-TRANSIENT").build(), (Entity)node);
            }
        }
    }

    private static class NextServerIdSupplier
    implements Supplier<Integer> {
        private AtomicInteger nextId = new AtomicInteger(2);

        private NextServerIdSupplier() {
        }

        public Integer get() {
            return this.nextId.getAndIncrement();
        }
    }

    public static class SlaveStateParser
    implements Function<String, Boolean> {
        private Entity slave;

        public SlaveStateParser(Entity slave) {
            this.slave = slave;
        }

        public Boolean apply(String result) {
            Map<String, String> status = MySqlRowParser.parseSingle(result);
            String secondsBehindMaster = status.get("Seconds_Behind_Master");
            if (secondsBehindMaster != null && !"NULL".equals(secondsBehindMaster)) {
                this.slave.sensors().set(MySqlCluster.MySqlSlave.SLAVE_SECONDS_BEHIND_MASTER, (Object)new Integer(secondsBehindMaster));
            }
            return "Yes".equals(status.get("Slave_IO_Running")) && "Yes".equals(status.get("Slave_SQL_Running"));
        }
    }

    public static class SlaveStateCallable
    implements Callable<String> {
        private MySqlNode slave;

        public SlaveStateCallable(MySqlNode slave) {
            this.slave = slave;
        }

        @Override
        public String call() throws Exception {
            if (Boolean.TRUE.equals(this.slave.getAttribute(MySqlNode.SERVICE_PROCESS_IS_RUNNING))) {
                return MySqlClusterUtils.executeSqlOnNode(this.slave, "SHOW SLAVE STATUS \\G");
            }
            return null;
        }
    }
}

