/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.ControlPlaneConfigSpec;
import io.fabric8.openshift.api.model.hive.v1.ControlPlaneServingCertificateSpec;
import io.fabric8.openshift.api.model.hive.v1.ControlPlaneServingCertificateSpecBuilder;
import io.fabric8.openshift.api.model.hive.v1.ControlPlaneServingCertificateSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ControlPlaneConfigSpecFluent<A extends ControlPlaneConfigSpecFluent<A>>
extends BaseFluent<A> {
    private String apiURLOverride;
    private ControlPlaneServingCertificateSpecBuilder servingCertificates;
    private Map<String, Object> additionalProperties;

    public ControlPlaneConfigSpecFluent() {
    }

    public ControlPlaneConfigSpecFluent(ControlPlaneConfigSpec instance) {
        ControlPlaneConfigSpec controlPlaneConfigSpec = instance = instance != null ? instance : new ControlPlaneConfigSpec();
        if (instance != null) {
            this.withApiURLOverride(instance.getApiURLOverride());
            this.withServingCertificates(instance.getServingCertificates());
            this.withApiURLOverride(instance.getApiURLOverride());
            this.withServingCertificates(instance.getServingCertificates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiURLOverride() {
        return this.apiURLOverride;
    }

    public A withApiURLOverride(String apiURLOverride) {
        this.apiURLOverride = apiURLOverride;
        return (A)((Object)this);
    }

    public boolean hasApiURLOverride() {
        return this.apiURLOverride != null;
    }

    public ControlPlaneServingCertificateSpec buildServingCertificates() {
        return this.servingCertificates != null ? this.servingCertificates.build() : null;
    }

    public A withServingCertificates(ControlPlaneServingCertificateSpec servingCertificates) {
        this._visitables.get((Object)"servingCertificates").remove((Object)this.servingCertificates);
        if (servingCertificates != null) {
            this.servingCertificates = new ControlPlaneServingCertificateSpecBuilder(servingCertificates);
            this._visitables.get((Object)"servingCertificates").add(this.servingCertificates);
        } else {
            this.servingCertificates = null;
            this._visitables.get((Object)"servingCertificates").remove((Object)this.servingCertificates);
        }
        return (A)((Object)this);
    }

    public boolean hasServingCertificates() {
        return this.servingCertificates != null;
    }

    public ServingCertificatesNested<A> withNewServingCertificates() {
        return new ServingCertificatesNested(null);
    }

    public ServingCertificatesNested<A> withNewServingCertificatesLike(ControlPlaneServingCertificateSpec item) {
        return new ServingCertificatesNested(item);
    }

    public ServingCertificatesNested<A> editServingCertificates() {
        return this.withNewServingCertificatesLike(Optional.ofNullable(this.buildServingCertificates()).orElse(null));
    }

    public ServingCertificatesNested<A> editOrNewServingCertificates() {
        return this.withNewServingCertificatesLike(Optional.ofNullable(this.buildServingCertificates()).orElse(new ControlPlaneServingCertificateSpecBuilder().build()));
    }

    public ServingCertificatesNested<A> editOrNewServingCertificatesLike(ControlPlaneServingCertificateSpec item) {
        return this.withNewServingCertificatesLike(Optional.ofNullable(this.buildServingCertificates()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ControlPlaneConfigSpecFluent that = (ControlPlaneConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.apiURLOverride, that.apiURLOverride)) {
            return false;
        }
        if (!Objects.equals((Object)this.servingCertificates, (Object)that.servingCertificates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiURLOverride, this.servingCertificates, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiURLOverride != null) {
            sb.append("apiURLOverride:");
            sb.append(this.apiURLOverride + ",");
        }
        if (this.servingCertificates != null) {
            sb.append("servingCertificates:");
            sb.append((Object)((Object)this.servingCertificates) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServingCertificatesNested<N>
    extends ControlPlaneServingCertificateSpecFluent<ServingCertificatesNested<N>>
    implements Nested<N> {
        ControlPlaneServingCertificateSpecBuilder builder;

        ServingCertificatesNested(ControlPlaneServingCertificateSpec item) {
            this.builder = new ControlPlaneServingCertificateSpecBuilder(this, item);
        }

        public N and() {
            return (N)ControlPlaneConfigSpecFluent.this.withServingCertificates(this.builder.build());
        }

        public N endServingCertificates() {
            return this.and();
        }
    }
}

