/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigInheritances;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.util.collections.CollectionMerger;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConfigInheritance
implements ConfigInheritance {
    private static final Logger log = LoggerFactory.getLogger(BasicConfigInheritance.class);
    private static final long serialVersionUID = -5916548049057961051L;
    public static final String CONFLICT_RESOLUTION_STRATEGY_DEEP_MERGE = "deep_merge";
    public static final String CONFLICT_RESOLUTION_STRATEGY_OVERWRITE = "overwrite";
    public static final ConfigInheritance NOT_REINHERITED = new NotReinherited();
    public static final ConfigInheritance NOT_REINHERITED_ELSE_DEEP_MERGE = new NotReinheritedElseDeepMerge();
    public static final ConfigInheritance NEVER_INHERITED = new NeverInherited();
    private static final ConfigInheritance NEVER_INHERITED_OLD = new BasicConfigInheritance(false, "overwrite", true, true);
    public static final ConfigInheritance OVERWRITE = new Overwrite();
    public static final ConfigInheritance DEEP_MERGE = new DeepMerge();
    protected final boolean isReinherited;
    @Nullable
    protected final String conflictResolutionStrategy;
    @Deprecated
    protected final Boolean useLocalDefaultValue;
    @Nonnull
    protected final Boolean localDefaultResolvesWithAncestorValue;
    @Nonnull
    protected final Boolean ancestorDefaultInheritable;

    private static ConfigInheritance returnEquivalentConstant(ConfigInheritance candidate) {
        for (ConfigInheritance knownMode : Arrays.asList(NOT_REINHERITED, NOT_REINHERITED_ELSE_DEEP_MERGE, NEVER_INHERITED, OVERWRITE, DEEP_MERGE)) {
            if (!candidate.equals(knownMode)) continue;
            return knownMode;
        }
        if (candidate.equals(NEVER_INHERITED_OLD)) {
            return NEVER_INHERITED;
        }
        return candidate;
    }

    private static void registerReplacements() {
        ConfigInheritance.Legacy.registerReplacement((ConfigInheritance)ConfigInheritance.DEEP_MERGE, (ConfigInheritance)DEEP_MERGE);
        ConfigInheritance.Legacy.registerReplacement((ConfigInheritance)ConfigInheritance.ALWAYS, (ConfigInheritance)OVERWRITE);
        ConfigInheritance.Legacy.registerReplacement((ConfigInheritance)ConfigInheritance.NONE, (ConfigInheritance)NOT_REINHERITED);
    }

    @Deprecated
    protected BasicConfigInheritance(boolean isReinherited, @Nullable String conflictResolutionStrategy, boolean localDefaultResolvesWithAncestorValue) {
        this(isReinherited, conflictResolutionStrategy, localDefaultResolvesWithAncestorValue, true);
    }

    protected BasicConfigInheritance(boolean isReinherited, @Nullable String conflictResolutionStrategy, boolean localDefaultResolvesWithAncestorValue, boolean ancestorDefaultInheritable) {
        this.isReinherited = isReinherited;
        this.conflictResolutionStrategy = conflictResolutionStrategy;
        this.useLocalDefaultValue = null;
        this.localDefaultResolvesWithAncestorValue = localDefaultResolvesWithAncestorValue;
        this.ancestorDefaultInheritable = ancestorDefaultInheritable;
    }

    @Deprecated
    public ConfigInheritance.InheritanceMode isInherited(ConfigKey<?> key, Object from, Object to) {
        return null;
    }

    protected <TContainer, TValue> void checkInheritanceContext(ConfigValueAtContainer<TContainer, TValue> local, ConfigInheritance.ConfigInheritanceContext context) {
        ConfigInheritance rightInheritance = ConfigInheritances.findInheritance(local, (ConfigInheritance.ConfigInheritanceContext)context, (ConfigInheritance)this);
        if (!this.isSameRootInstanceAs(rightInheritance)) {
            throw new IllegalStateException("Low level inheritance computation error: caller should invoke on " + rightInheritance + " (the inheritance at " + local + "), not " + this);
        }
    }

    private boolean isSameRootInstanceAs(ConfigInheritance other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof DelegatingConfigInheritance) {
            return this.isSameRootInstanceAs(((DelegatingConfigInheritance)other).getDelegate());
        }
        return false;
    }

    public <TContainer, TValue> boolean isReinheritable(ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritance.ConfigInheritanceContext context) {
        this.checkInheritanceContext(parent, context);
        return this.isReinherited();
    }

    public <TContainer, TValue> boolean considerParent(ConfigValueAtContainer<TContainer, TValue> local, ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritance.ConfigInheritanceContext context) {
        this.checkInheritanceContext(local, context);
        if (parent == null) {
            return false;
        }
        if (CONFLICT_RESOLUTION_STRATEGY_OVERWRITE.equals(this.conflictResolutionStrategy)) {
            return !local.isValueExplicitlySet() && !this.getLocalDefaultResolvesWithAncestorValue();
        }
        return true;
    }

    public <TContainer, TValue> ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resolveWithParent(ConfigValueAtContainer<TContainer, TValue> local, ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritance.ConfigInheritanceContext context) {
        this.checkInheritanceContext(local, context);
        if (!parent.isValueExplicitlySet() && !this.getLocalDefaultResolvesWithAncestorValue()) {
            if (this.getAncestorDefaultInheritable() && !local.isValueExplicitlySet() && local.getDefaultValue().isAbsentOrNull() && parent.getDefaultValue().isPresentAndNonNull()) {
                return ReferenceWithError.newInstanceWithoutError((Object)new ConfigInheritances.BasicConfigValueAtContainer(parent));
            }
            return ReferenceWithError.newInstanceWithoutError((Object)new ConfigInheritances.BasicConfigValueAtContainer(local));
        }
        if (!local.isValueExplicitlySet() && !this.getLocalDefaultResolvesWithAncestorValue()) {
            return ReferenceWithError.newInstanceWithoutError((Object)new ConfigInheritances.BasicConfigValueAtContainer(parent));
        }
        if (CONFLICT_RESOLUTION_STRATEGY_DEEP_MERGE.equals(this.conflictResolutionStrategy)) {
            ConfigInheritances.BasicConfigValueAtContainer result = new ConfigInheritances.BasicConfigValueAtContainer(local);
            ReferenceWithError resolvedValue = BasicConfigInheritance.deepMerge(local.isValueExplicitlySet() ? local.asMaybe() : local.getDefaultValue(), parent.isValueExplicitlySet() ? parent.asMaybe() : (this.getAncestorDefaultInheritable() ? parent.getDefaultValue() : Maybe.absent()));
            result.setValue((Maybe)resolvedValue.getWithoutError());
            return ReferenceWithError.newInstanceThrowingError((Object)result, (Throwable)resolvedValue.getError());
        }
        return this.resolveWithParentCustomStrategy(local, parent, context);
    }

    protected <TContainer, TValue> ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resolveWithParentCustomStrategy(ConfigValueAtContainer<TContainer, TValue> local, ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritance.ConfigInheritanceContext context) {
        throw new IllegalStateException("Unknown config conflict resolution strategy '" + this.conflictResolutionStrategy + "' evaluating " + local + "/" + parent);
    }

    private static <T> ReferenceWithError<Maybe<? extends T>> deepMerge(Maybe<? extends T> val1, Maybe<? extends T> val2) {
        if (val2.isAbsent() || val2.isNull()) {
            return ReferenceWithError.newInstanceWithoutError(val1);
        }
        if (val1.isAbsent()) {
            return ReferenceWithError.newInstanceWithoutError(val2);
        }
        if (val1.isNull()) {
            return ReferenceWithError.newInstanceWithoutError(val1);
        }
        if (val1.get() instanceof Map && val2.get() instanceof Map) {
            Maybe result = Maybe.of((Object)CollectionMerger.builder().build().merge((Map)val1.get(), (Map)val2.get()));
            return ReferenceWithError.newInstanceWithoutError((Object)result);
        }
        return ReferenceWithError.newInstanceThrowingError(val1, (Throwable)new IllegalArgumentException("Cannot merge '" + val1.get() + "' and '" + val2.get() + "'"));
    }

    public boolean isReinherited() {
        return this.isReinherited;
    }

    public String getConflictResolutionStrategy() {
        return this.conflictResolutionStrategy;
    }

    @Deprecated
    public boolean getUseLocalDefaultValue() {
        return this.getLocalDefaultResolvesWithAncestorValue();
    }

    public boolean getLocalDefaultResolvesWithAncestorValue() {
        if (this.localDefaultResolvesWithAncestorValue == null) {
            log.warn("Encountered legacy " + this + " with null localDefaultResolvesWithAncestorValue; transforming", new Throwable("stack trace for legacy " + this));
            this.readResolve();
        }
        return this.localDefaultResolvesWithAncestorValue;
    }

    public boolean getAncestorDefaultInheritable() {
        if (this.ancestorDefaultInheritable == null) {
            log.warn("Encountered legacy " + this + " with null ancestorDefaultInheritable; transforming", new Throwable("stack trace for legacy " + this));
            this.readResolve();
        }
        return this.ancestorDefaultInheritable;
    }

    private ConfigInheritance readResolve() {
        try {
            if (this.useLocalDefaultValue != null) {
                Field fNew = this.getClass().getDeclaredField("localDefaultResolvesWithAncestorValue");
                fNew.setAccessible(true);
                Field fOld = this.getClass().getDeclaredField("useLocalDefaultValue");
                fOld.setAccessible(true);
                if (fNew.get(this) == null) {
                    fNew.set(this, this.useLocalDefaultValue);
                } else if (!fNew.get(this).equals(this.useLocalDefaultValue)) {
                    throw new IllegalStateException("Incompatible values detected for " + fOld + " (" + fOld.get(this) + ") and " + fNew + " (" + fNew.get(this) + ")");
                }
                fOld.set(this, null);
            }
            if (this.ancestorDefaultInheritable == null) {
                Field f = this.getClass().getDeclaredField("ancestorDefaultInheritable");
                f.setAccessible(true);
                f.set(this, true);
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return BasicConfigInheritance.returnEquivalentConstant(this);
    }

    public int hashCode() {
        return Objects.hash(this.conflictResolutionStrategy, this.isReinherited, this.localDefaultResolvesWithAncestorValue, this.ancestorDefaultInheritable);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DelegatingConfigInheritance) {
            return this.equals(((DelegatingConfigInheritance)obj).getDelegate());
        }
        if (obj instanceof BasicConfigInheritance) {
            return this.equalsAfterResolvingDelegate((BasicConfigInheritance)obj);
        }
        return false;
    }

    protected boolean equalsAfterResolvingDelegate(BasicConfigInheritance b) {
        return Objects.equals(this.conflictResolutionStrategy, b.conflictResolutionStrategy) && Objects.equals(this.isReinherited, b.isReinherited) && Objects.equals(this.getLocalDefaultResolvesWithAncestorValue(), b.getLocalDefaultResolvesWithAncestorValue()) && Objects.equals(this.getAncestorDefaultInheritable(), b.getAncestorDefaultInheritable());
    }

    public String toString() {
        return super.toString() + "[reinherit=" + this.isReinherited() + "; strategy=" + this.getConflictResolutionStrategy() + "; localDefaultResolvesWithAncestor=" + this.localDefaultResolvesWithAncestorValue + "]";
    }

    public static ConfigInheritance fromString(String val) {
        if (Strings.isBlank((CharSequence)val)) {
            return null;
        }
        switch (val.toLowerCase().trim()) {
            case "not_reinherited": 
            case "notreinherited": 
            case "none": {
                return NOT_REINHERITED;
            }
            case "never": {
                return NEVER_INHERITED;
            }
            case "overwrite": 
            case "always": {
                return OVERWRITE;
            }
            case "deep_merge": 
            case "merge": 
            case "deepmerge": {
                return DEEP_MERGE;
            }
        }
        throw new IllegalArgumentException("Invalid config-inheritance '" + val + "' (legal values are none, always or deep_merge)");
    }

    static {
        BasicConfigInheritance.registerReplacements();
    }

    private static class DeepMerge
    extends DelegatingConfigInheritance {
        static final BasicConfigInheritance DELEGATE = new BasicConfigInheritance(true, "deep_merge", false, true);

        private DeepMerge() {
        }

        @Override
        protected ConfigInheritance getDelegate() {
            return DELEGATE;
        }
    }

    private static class Overwrite
    extends DelegatingConfigInheritance {
        static final BasicConfigInheritance DELEGATE = new BasicConfigInheritance(true, "overwrite", false, true);

        private Overwrite() {
        }

        @Override
        protected ConfigInheritance getDelegate() {
            return DELEGATE;
        }
    }

    private static class NeverInherited
    extends DelegatingConfigInheritance {
        static final BasicConfigInheritance DELEGATE = new BasicConfigInheritance(false, "overwrite", true, false);

        private NeverInherited() {
        }

        @Override
        protected ConfigInheritance getDelegate() {
            return DELEGATE;
        }
    }

    private static class NotReinheritedElseDeepMerge
    extends DelegatingConfigInheritance {
        static final BasicConfigInheritance DELEGATE = new BasicConfigInheritance(false, "deep_merge", false, true);

        private NotReinheritedElseDeepMerge() {
        }

        @Override
        protected ConfigInheritance getDelegate() {
            return DELEGATE;
        }
    }

    private static class NotReinherited
    extends DelegatingConfigInheritance {
        static final BasicConfigInheritance DELEGATE = new BasicConfigInheritance(false, "overwrite", false, true);

        private NotReinherited() {
        }

        @Override
        protected ConfigInheritance getDelegate() {
            return DELEGATE;
        }
    }

    public static abstract class DelegatingConfigInheritance
    implements ConfigInheritance {
        protected abstract ConfigInheritance getDelegate();

        @Deprecated
        public ConfigInheritance.InheritanceMode isInherited(ConfigKey<?> key, Object from, Object to) {
            return this.getDelegate().isInherited(key, from, to);
        }

        public <TContainer, TValue> boolean isReinheritable(ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritance.ConfigInheritanceContext context) {
            return this.getDelegate().isReinheritable(parent, context);
        }

        public <TContainer, TValue> boolean considerParent(ConfigValueAtContainer<TContainer, TValue> local, ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritance.ConfigInheritanceContext context) {
            return this.getDelegate().considerParent(local, parent, context);
        }

        public <TContainer, TValue> ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resolveWithParent(ConfigValueAtContainer<TContainer, TValue> local, ConfigValueAtContainer<TContainer, TValue> resolvedParent, ConfigInheritance.ConfigInheritanceContext context) {
            return this.getDelegate().resolveWithParent(local, resolvedParent, context);
        }

        public boolean equals(Object obj) {
            return super.equals(obj) || this.getDelegate().equals(obj);
        }

        public int hashCode() {
            return this.getDelegate().hashCode();
        }

        protected ConfigInheritance readResolve() {
            return BasicConfigInheritance.returnEquivalentConstant(this);
        }
    }
}

