/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.store.WorkflowStatePersistenceViaSensors;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowReplayUtils {
    private static final Logger log = LoggerFactory.getLogger(WorkflowReplayUtils.class);

    public static boolean isReplayResumable(WorkflowExecutionContext workflowExecutionContext, ReplayResumeDepthCheck requireDeeplyReplayable, boolean allowInternallyEvenIfDisabled) {
        WorkflowStepInstanceExecutionContext csi = workflowExecutionContext.currentStepInstance;
        if (csi != null) {
            if (csi.getStepIndex() != workflowExecutionContext.currentStepIndex.intValue()) {
                return true;
            }
            WorkflowStepDefinition stepDefinition = workflowExecutionContext.getStepsResolved().get(csi.stepIndex);
            if (stepDefinition != null) {
                Boolean idempotence = stepDefinition.isIdempotent(csi);
                if (Boolean.FALSE.equals(idempotence)) {
                    return false;
                }
                if (stepDefinition instanceof WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow) {
                    WorkflowStepDefinition.SubWorkflowsForReplay subWorkflowReplayable = ((WorkflowStepDefinition.WorkflowStepDefinitionWithSubWorkflow)((Object)stepDefinition)).getSubWorkflowsForReplay(csi, false, true, allowInternallyEvenIfDisabled);
                    if (!subWorkflowReplayable.isResumableAtSubworkflows) {
                        if (subWorkflowReplayable.hasNonResumableWorkflows && requireDeeplyReplayable == ReplayResumeDepthCheck.RESUMABLE_IFF_NESTED_WORKFLOWS_RESUMABLE) {
                            return false;
                        }
                        return subWorkflowReplayable.isResumableOnlyAtParent;
                    }
                    if (requireDeeplyReplayable == ReplayResumeDepthCheck.RESUMABLE_WHENEVER_NESTED_WORKFLOWS_PRESENT) {
                        return true;
                    }
                    if (requireDeeplyReplayable == ReplayResumeDepthCheck.RESUMABLE_IFF_NESTED_WORKFLOWS_REPLAYABLE_OR_RESUMABLE) {
                        return subWorkflowReplayable.subworkflows.stream().allMatch(sub -> WorkflowReplayUtils.isReplayableAnywhere(sub, allowInternallyEvenIfDisabled));
                    }
                    if (requireDeeplyReplayable == ReplayResumeDepthCheck.RESUMABLE_IFF_NESTED_WORKFLOWS_RESUMABLE) {
                        return subWorkflowReplayable.subworkflows.stream().allMatch(sub -> WorkflowReplayUtils.isReplayResumable(sub, requireDeeplyReplayable, allowInternallyEvenIfDisabled));
                    }
                    throw new IllegalArgumentException("Invalid requireDeeply mode: " + (Object)((Object)requireDeeplyReplayable));
                }
                if (idempotence != null) {
                    return idempotence;
                }
                return false;
            }
            return WorkflowReplayUtils.isReplayableFromStep(workflowExecutionContext, csi.stepIndex);
        }
        return WorkflowReplayUtils.isReplayableFromStep(workflowExecutionContext, workflowExecutionContext.currentStepIndex);
    }

    static boolean isReplayableFromStep(WorkflowExecutionContext workflowExecutionContext, Integer stepIndex) {
        if (stepIndex == null || stepIndex == -1) {
            return Boolean.TRUE.equals(workflowExecutionContext.replayableFromStart) || Objects.equals(workflowExecutionContext.replayableLastStep, -1);
        }
        if (stepIndex == -2) {
            return true;
        }
        if (Objects.equals(stepIndex, workflowExecutionContext.currentStepIndex) && Objects.equals(workflowExecutionContext.replayableLastStep, stepIndex)) {
            return true;
        }
        WorkflowExecutionContext.OldStepRecord osi = workflowExecutionContext.oldStepInfo.get(stepIndex);
        if (osi != null) {
            return Boolean.TRUE.equals(osi.replayableFromHere);
        }
        return false;
    }

    public static boolean isReplayableAnywhere(WorkflowExecutionContext workflowExecutionContext, boolean allowInternallyEvenIfDisabled) {
        if (workflowExecutionContext.factory(allowInternallyEvenIfDisabled).isDisabled()) {
            return false;
        }
        return workflowExecutionContext.currentStepIndex == null || workflowExecutionContext.replayableLastStep != null || Boolean.TRUE.equals(workflowExecutionContext.replayableFromStart) || workflowExecutionContext.currentStepInstance != null && workflowExecutionContext.currentStepInstance.getStepIndex() != workflowExecutionContext.currentStepIndex.intValue() || workflowExecutionContext.currentStepIndex == -1 || workflowExecutionContext.currentStepIndex == -2 || WorkflowReplayUtils.isReplayResumable(workflowExecutionContext, ReplayResumeDepthCheck.RESUMABLE_IFF_NESTED_WORKFLOWS_REPLAYABLE_OR_RESUMABLE, allowInternallyEvenIfDisabled);
    }

    public static Consumer<WorkflowExecutionContext> updaterForReplayableAtWorkflow(String replayable, String idempotent, boolean isNestedWorkflowStep) {
        boolean replayableFromStart;
        boolean replayableDisabled;
        boolean idempotentAll;
        if (replayable == null) {
            replayable = "";
        }
        replayable = replayable.toLowerCase().replaceAll("[^a-z]+", " ").trim();
        if (idempotent == null) {
            idempotent = "";
        }
        if (idempotentAll = "all".equals(idempotent = idempotent.toLowerCase().replaceAll("[^a-z]+", " ").trim())) {
            idempotent = "";
        }
        if (!Strings.isBlank((CharSequence)idempotent)) {
            throw new IllegalArgumentException("Invalid value for `idempotent` on workflow step");
        }
        boolean replayableAutomatically = replayable.contains("automatically");
        if (replayableAutomatically) {
            replayable = replayable.replace("automatically", "").trim();
        }
        if (!replayableAutomatically && replayable.equals("enabled")) {
            replayable = "";
        }
        boolean bl = replayableDisabled = !replayableAutomatically && replayable.equals("disabled");
        if (replayableDisabled) {
            replayable = "";
        }
        if (replayableFromStart = replayable.equals("from start")) {
            replayable = "";
        }
        if (!Strings.isBlank((CharSequence)replayable)) {
            if (!replayableAutomatically && isNestedWorkflowStep) {
                WorkflowReplayUtils.validateReplayableAndIdempotentAtStep(replayable, idempotent, false);
            } else {
                if (replayableAutomatically) {
                    throw new IllegalArgumentException("Invalid 'replayable' value: 'automatically' cannot be used with '" + replayable + "'");
                }
                throw new IllegalArgumentException("Invalid 'replayable' value: '" + replayable + "'");
            }
        }
        return ctx -> {
            if (replayableFromStart) {
                ctx.replayableFromStart = replayableFromStart;
                ctx.replayableLastStep = -1;
            }
            ctx.replayableAutomatically = replayableAutomatically ? Boolean.valueOf(true) : null;
            ctx.replayableDisabled = replayableDisabled ? Boolean.valueOf(true) : null;
            ctx.idempotentAll = idempotentAll ? Boolean.valueOf(true) : null;
        };
    }

    public static Consumer<WorkflowExecutionContext> updaterForReplayableAtWorkflow(ConfigBag paramsDefiningWorkflow, boolean isNestedWorkflowStep) {
        return WorkflowReplayUtils.updaterForReplayableAtWorkflow(paramsDefiningWorkflow.get(WorkflowCommonConfig.REPLAYABLE), paramsDefiningWorkflow.get(WorkflowCommonConfig.IDEMPOTENT), isNestedWorkflowStep);
    }

    public static void updateReplayableFromStep(WorkflowExecutionContext context, WorkflowStepDefinition step) {
        Pair<ReplayableAtStepOption, Boolean> opt = step.validateReplayableAndIdempotent();
        if (opt.getLeft() != null && ((ReplayableAtStepOption)((Object)opt.getLeft())).isReplayPoint) {
            context.oldStepInfo.get((Object)context.currentStepIndex).replayableFromHere = true;
            context.replayableLastStep = context.currentStepIndex;
        }
        if (opt.getLeft() != null && ((ReplayableAtStepOption)((Object)opt.getLeft())).forcesReset) {
            context.replayableLastStep = null;
            context.oldStepInfo.forEach((k, v) -> {
                v.replayableFromHere = ((ReplayableAtStepOption)((Object)((Object)opt.getLeft()))).isReplayPoint && Objects.equals(k, context.currentStepIndex) ? Boolean.valueOf(true) : null;
            });
        }
    }

    public static Pair<ReplayableAtStepOption, Boolean> validateReplayableAndIdempotentAtStep(String replayable, String idempotent, boolean asWorkflowDefinition) {
        if (replayable == null) {
            replayable = "";
        }
        if (idempotent == null) {
            idempotent = "";
        }
        replayable = replayable.toLowerCase().replaceAll("[^a-z]+", " ").trim();
        idempotent = idempotent.toLowerCase().replaceAll("[^a-z]+", " ").trim();
        Maybe<ReplayableAtStepOption> rv = Strings.isBlank((CharSequence)replayable) ? Maybe.ofAllowingNull(null) : ReplayableAtStepOption.ofMaybe(replayable);
        Maybe<Boolean> id = WorkflowReplayUtils.validateIdempotentAtStep(idempotent);
        if (asWorkflowDefinition) {
            WorkflowReplayUtils.updaterForReplayableAtWorkflow(rv.isPresent() ? null : replayable, id.isPresent() ? null : idempotent, false);
        } else {
            rv.get();
            id.get();
        }
        return Pair.of((Object)rv.orNull(), (Object)id.orNull());
    }

    private static Maybe<Boolean> validateIdempotentAtStep(String idempotent) {
        if (Strings.isBlank((CharSequence)idempotent) || idempotent.equals("default")) {
            return Maybe.ofAllowingNull(null);
        }
        if (idempotent.equals("yes") || idempotent.equals("true")) {
            return Maybe.of((Object)true);
        }
        if (idempotent.equals("no") || idempotent.equals("false")) {
            return Maybe.of((Object)false);
        }
        return Maybe.absent((String)("Invalid value for idempotent: '" + idempotent + "'"));
    }

    public static Integer findNearestReplayPoint(WorkflowExecutionContext context, int stepIndex0) {
        return WorkflowReplayUtils.findNearestReplayPoint(context, stepIndex0, true);
    }

    public static Integer findNearestReplayPoint(WorkflowExecutionContext context, int stepIndex0, boolean allowInclusive) {
        int stepIndex = stepIndex0;
        MutableSet considered = MutableSet.of();
        MutableSet possibleOthers = MutableSet.of();
        while (!allowInclusive || !WorkflowReplayUtils.isReplayableFromStep(context, stepIndex)) {
            boolean repeating;
            allowInclusive = true;
            if (stepIndex == -1) {
                return null;
            }
            WorkflowExecutionContext.OldStepRecord osi = context.oldStepInfo.get(stepIndex);
            if (osi == null) {
                log.warn("Unable to backtrack from step " + stepIndex + "; no step information. Will try to replay from start.");
                stepIndex = -1;
                continue;
            }
            Set<Integer> prev = osi.previous;
            if (prev == null || prev.isEmpty()) {
                log.warn("Unable to backtrack from step " + stepIndex + "; no previous step recorded. Will try to replay from start.");
                stepIndex = -1;
                continue;
            }
            boolean bl = repeating = !considered.add(stepIndex);
            if (repeating) {
                if (possibleOthers.size() != 1) {
                    log.warn("Unable to backtrack from step " + stepIndex + "; ambiguous precedents " + prev + " / " + possibleOthers + ". Will try to replay from start.");
                    stepIndex = -1;
                    continue;
                }
                stepIndex = (Integer)possibleOthers.iterator().next();
                continue;
            }
            Iterator<Integer> prevI = prev.iterator();
            stepIndex = prevI.next();
            while (prevI.hasNext()) {
                possibleOthers.add(prevI.next());
            }
        }
        return stepIndex;
    }

    public static void updateOnWorkflowStartOrReplay(WorkflowExecutionContext ctx, Task<?> task, String reasonForReplay, Integer fixedStepToReplayFrom) {
        WorkflowReplayRecord.add(ctx, task, reasonForReplay);
        if (fixedStepToReplayFrom != null) {
            ctx.replayableLastStep = fixedStepToReplayFrom;
        }
    }

    public static void updateOnWorkflowSuccess(WorkflowExecutionContext ctx, Task<?> task, Object result) {
        WorkflowReplayRecord.updateInternal(ctx, task, true, result);
        ctx.replayableLastStep = -2;
    }

    public static void updateOnWorkflowError(WorkflowExecutionContext ctx, Task<?> task, Throwable error) {
        WorkflowReplayRecord.updateInternal(ctx, task, false, Exceptions.collapseTextInContext((Throwable)error, (Object[])new Object[]{task}));
    }

    public static void updateOnWorkflowTaskStartupOrReplay(WorkflowExecutionContext ctx, Task<?> task, List<WorkflowStepDefinition> stepsResolved, boolean firstRun, Integer optionalReplayStep) {
        WorkflowReplayRecord.updateInternal(ctx, task, null, null);
    }

    private static Task<Object> createReplayResumingSubWorkflowTaskOrThrow(WorkflowExecutionContext subWorkflow, WorkflowStepDefinition.ReplayContinuationInstructions instructions, boolean allowInternallyEvenIfDisabled) {
        if (instructions.stepToReplayFrom != null) {
            throw new IllegalStateException("Cannot replay a nested workflow where the parent started at a specific step");
        }
        if (instructions.forced && instructions.customBehavior != null) {
            log.debug("Creating task to replay subworkflow " + subWorkflow + " from last, forced with custom behaviour - " + instructions);
            return subWorkflow.factory(allowInternallyEvenIfDisabled).createTaskReplaying(subWorkflow.factory(allowInternallyEvenIfDisabled).makeInstructionsForReplayResumingForcedWithCustom(instructions.customBehaviorExplanation, instructions.customBehavior));
        }
        if (Objects.equals(subWorkflow.replayableLastStep, -2)) {
            log.debug("Creating task to replay subworkflow " + subWorkflow + " from last, but already at end - " + instructions);
            return null;
        }
        log.debug("Creating task to replay subworkflow " + subWorkflow + " from last: " + instructions);
        WorkflowStepDefinition.ReplayContinuationInstructions subInstr = subWorkflow.factory(allowInternallyEvenIfDisabled).makeInstructionsForReplayResuming(instructions.customBehaviorExplanation, instructions.forced);
        log.debug("Creating task to replay subworkflow " + subWorkflow + ", will use: " + subInstr);
        return subWorkflow.factory(allowInternallyEvenIfDisabled).createTaskReplaying(subInstr);
    }

    public static Object replayResumingInSubWorkflow(String summary, WorkflowStepInstanceExecutionContext context, WorkflowExecutionContext w, WorkflowStepDefinition.ReplayContinuationInstructions instructions, BiFunction<WorkflowExecutionContext, Exception, Object> ifNotReplayable, boolean allowInternallyEvenIfDisabled) {
        Pair<Boolean, Object> check = WorkflowReplayUtils.checkReplayResumingInSubWorkflowAlsoReturningTaskOrResult(summary, context, w, instructions, ifNotReplayable, allowInternallyEvenIfDisabled);
        if (((Boolean)check.getLeft()).booleanValue()) {
            return DynamicTasks.queue((Task)check.getRight()).getUnchecked();
        }
        return check.getRight();
    }

    public static Pair<Boolean, Object> checkReplayResumingInSubWorkflowAlsoReturningTaskOrResult(String summary, WorkflowStepInstanceExecutionContext context, WorkflowExecutionContext w, WorkflowStepDefinition.ReplayContinuationInstructions instructions, BiFunction<WorkflowExecutionContext, Exception, Object> ifNotReplayable, boolean allowInternallyEvenIfDisabled) {
        Task<Object> t;
        try {
            t = WorkflowReplayUtils.createReplayResumingSubWorkflowTaskOrThrow(w, instructions, allowInternallyEvenIfDisabled);
            if (t == null) {
                return Pair.of((Object)false, (Object)w.getOutput());
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.debug("Step " + context.getWorkflowStepReference() + " could not resume nested workflow " + (w == null ? "<null>" : w.getWorkflowId()) + " (running alternate): " + e);
            return Pair.of((Object)false, (Object)ifNotReplayable.apply(w, e));
        }
        log.debug("Step " + context.getWorkflowStepReference() + " resuming nested workflow " + w.getWorkflowId() + " in task " + t.getId());
        return Pair.of((Object)true, t);
    }

    public static void setNewSubWorkflows(WorkflowStepInstanceExecutionContext context, List<BrooklynTaskTags.WorkflowTaskTag> tags, String supersededId) {
        WorkflowReplayUtils.markSubWorkflowsSupersededByTask(context, supersededId);
        tags.forEach(nw -> WorkflowReplayUtils.addNewSubWorkflow(context, nw));
        context.getWorkflowExectionContext().persist();
    }

    public static void markSubWorkflowsSupersededByTask(WorkflowStepInstanceExecutionContext context, String supersededId) {
        context.getSubWorkflows().forEach(tag -> tag.setSupersededByTaskId(supersededId));
    }

    public static boolean addNewSubWorkflow(WorkflowStepInstanceExecutionContext context, BrooklynTaskTags.WorkflowTaskTag nw) {
        if (nw == null) {
            throw new IllegalArgumentException("Workflow tag must not be null");
        }
        return context.getSubWorkflows().add(nw);
    }

    public static WorkflowStepDefinition.SubWorkflowsForReplay getSubWorkflowsForReplay(WorkflowStepInstanceExecutionContext context, boolean forced, boolean peekingOnly, boolean allowInternallyEvenIfDisabled, Consumer<WorkflowStepDefinition.SubWorkflowsForReplay> ifNoSubworkflows) {
        Set<BrooklynTaskTags.WorkflowTaskTag> sws = context.getSubWorkflows();
        WorkflowStepDefinition.SubWorkflowsForReplay result = new WorkflowStepDefinition.SubWorkflowsForReplay();
        if (sws != null && !sws.isEmpty()) {
            List nestedWorkflowsToReplay = sws.stream().filter(tag -> tag.getSupersededByTaskId() == null).map(tag -> {
                Entity targetEntity = (Entity)context.getManagementContext().lookup(tag.getEntityId());
                if (targetEntity == null) {
                    log.warn("Unable to find entity for sub-workflow " + tag + " in " + context + "; assuming entity has gone, and may trigger recomputation of targets");
                    return null;
                }
                return new WorkflowStatePersistenceViaSensors(context.getManagementContext()).getWorkflows(targetEntity).get(tag.getWorkflowId());
            }).collect(Collectors.toList());
            result.subworkflows = nestedWorkflowsToReplay;
            if (nestedWorkflowsToReplay.isEmpty()) {
                if (!peekingOnly) {
                    log.info("Step " + context.getWorkflowStepReference() + " has all sub workflows superseded; replaying from start");
                }
                if (!peekingOnly) {
                    log.debug("Step " + context.getWorkflowStepReference() + " superseded sub workflows detail: " + sws + " -> " + nestedWorkflowsToReplay);
                }
                ifNoSubworkflows.accept(result);
            } else if (nestedWorkflowsToReplay.contains(null)) {
                if (!peekingOnly) {
                    log.info("Step " + context.getWorkflowStepReference() + " has uninitialized sub workflows; replaying from start");
                }
                if (!peekingOnly) {
                    log.debug("Step " + context.getWorkflowStepReference() + " uninitialized/unpersisted sub workflow detail: " + sws + " -> " + nestedWorkflowsToReplay);
                }
                ifNoSubworkflows.accept(result);
            } else if (!forced && nestedWorkflowsToReplay.stream().anyMatch(nest -> !WorkflowReplayUtils.isReplayableAnywhere(nest, allowInternallyEvenIfDisabled))) {
                if (!peekingOnly) {
                    log.info("Step " + context.getWorkflowStepReference() + " has non-replayable sub workflows; replaying from start");
                }
                if (!peekingOnly) {
                    log.debug("Step " + context.getWorkflowStepReference() + " non-replayable sub workflow detail: " + sws + " -> " + nestedWorkflowsToReplay);
                }
                result.hasNonResumableWorkflows = true;
            } else {
                if (!peekingOnly) {
                    log.debug("Step " + context.getWorkflowStepReference() + " replay sub workflow detail: " + sws + " -> " + nestedWorkflowsToReplay);
                }
                result.isResumableAtSubworkflows = true;
            }
        } else {
            ifNoSubworkflows.accept(result);
        }
        return result;
    }

    public static Object getNext(Object ... sources) {
        Object result = null;
        for (Object o : sources) {
            if (o == null) continue;
            if (o instanceof WorkflowStepInstanceExecutionContext) {
                result = ((WorkflowStepInstanceExecutionContext)o).next;
            } else if (o instanceof WorkflowStepDefinition) {
                result = ((WorkflowStepDefinition)o).next;
            } else if (o instanceof String || o instanceof WorkflowStepDefinition.ReplayContinuationInstructions) {
                result = o;
            } else {
                throw new IllegalArgumentException("Next not supported for " + o + " (type " + o.getClass() + ")");
            }
            if (result != null) break;
        }
        return result;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class WorkflowReplayRecord {
        String taskId;
        String reasonForReplay;
        String submittedByTaskId;
        long submitTimeUtc;
        long startTimeUtc;
        long endTimeUtc;
        String status;
        Boolean isError;
        Object result;

        private static void add(WorkflowExecutionContext ctx, Task<?> task, String reasonForReplay) {
            WorkflowReplayRecord wrr = new WorkflowReplayRecord();
            wrr.taskId = task.getId();
            wrr.reasonForReplay = reasonForReplay;
            ctx.replays.add(wrr);
            ctx.replayCurrent = wrr;
            WorkflowReplayRecord.update(ctx, task);
        }

        private static void updateInternal(WorkflowExecutionContext ctx, Task<?> task, Boolean forceEndSuccessOrError, Object result) {
            if (ctx.replayCurrent == null || ctx.replayCurrent.taskId != task.getId()) {
                log.warn("Mismatch in workflow replays for " + ctx + ": " + ctx.replayCurrent + " vs " + task);
                return;
            }
            if (task.getSubmittedByTaskId() != null) {
                ctx.replayCurrent.submittedByTaskId = task.getSubmittedByTaskId();
            } else if (ctx.replayCurrent.submittedByTaskId == null && Tasks.current() != null && !Tasks.current().equals(task)) {
                ctx.replayCurrent.submittedByTaskId = Tasks.current().getId();
            }
            ctx.replayCurrent.submitTimeUtc = task.getSubmitTimeUtc();
            if (ctx.replayCurrent.submitTimeUtc <= 0L) {
                ctx.replayCurrent.submitTimeUtc = Instant.now().toEpochMilli();
            }
            ctx.replayCurrent.startTimeUtc = task.getStartTimeUtc();
            ctx.replayCurrent.endTimeUtc = task.getEndTimeUtc();
            ctx.replayCurrent.status = task.getStatusSummary();
            if (forceEndSuccessOrError == null) {
                ctx.replayCurrent.isError = task.isDone() ? Boolean.valueOf(task.isError()) : null;
                try {
                    ctx.replayCurrent.result = task.isDone() ? task.get() : null;
                }
                catch (Throwable t) {
                    ctx.replayCurrent.result = Exceptions.collapseTextInContext((Throwable)t, (Object[])new Object[]{task});
                }
            } else {
                if (ctx.replayCurrent.endTimeUtc <= 0L) {
                    ctx.replayCurrent.endTimeUtc = System.currentTimeMillis();
                    ctx.replayCurrent.status = forceEndSuccessOrError != false ? "Completed" : "Failed";
                }
                ctx.replayCurrent.isError = forceEndSuccessOrError == false;
                ctx.replayCurrent.result = result;
            }
        }

        private static void update(WorkflowExecutionContext ctx, Task<?> task) {
            WorkflowReplayRecord.updateInternal(ctx, task, null, null);
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String toString() {
            return super.toString() + "[task=" + this.taskId + "]";
        }
    }

    public static enum ReplayableAtStepOption {
        RESET(false, true),
        FROM_HERE(true, false),
        FROM_HERE_ONLY(true, true);

        private final boolean isReplayPoint;
        private final boolean forcesReset;

        private ReplayableAtStepOption(boolean isReplayPoint, boolean forcesReset) {
            this.isReplayPoint = isReplayPoint;
            this.forcesReset = forcesReset;
        }

        public static Maybe<ReplayableAtStepOption> ofMaybe(String replayable) {
            if (Strings.isBlank((CharSequence)replayable)) {
                return Maybe.absentNull();
            }
            if ("reset".equalsIgnoreCase(replayable)) {
                return Maybe.of((Object)((Object)RESET));
            }
            if ("from here".equalsIgnoreCase(replayable)) {
                return Maybe.of((Object)((Object)FROM_HERE));
            }
            if ("from here only".equalsIgnoreCase(replayable)) {
                return Maybe.of((Object)((Object)FROM_HERE_ONLY));
            }
            return Maybe.absent((String)("Invalid 'replayable' value: " + replayable));
        }
    }

    public static enum ReplayResumeDepthCheck {
        RESUMABLE_IFF_NESTED_WORKFLOWS_RESUMABLE,
        RESUMABLE_IFF_NESTED_WORKFLOWS_REPLAYABLE_OR_RESUMABLE,
        RESUMABLE_WHENEVER_NESTED_WORKFLOWS_PRESENT;

    }
}

