/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.unmodifiable;

import aQute.bnd.unmodifiable.ImmutableEntry;
import aQute.bnd.unmodifiable.ImmutableSet;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

final class ImmutableMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    static final ImmutableMap<?, ?> EMPTY = new ImmutableMap(new Map.Entry[0]);
    final Map.Entry<K, V>[] entries;
    final transient short[] hash_bucket;
    transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 1L;

    @SafeVarargs
    ImmutableMap(Map.Entry<K, V> ... entries) {
        this.entries = entries;
        this.hash_bucket = ImmutableMap.hash(entries);
    }

    private static <K, V> short[] hash(Map.Entry<K, V>[] entries) {
        int length = entries.length;
        if (length == 0) {
            return new short[1];
        }
        if (length >= 65536) {
            throw new IllegalArgumentException("map too large: " + length);
        }
        short[] hash_bucket = new short[length * 2];
        int i = 0;
        while (i < length) {
            int slot = ImmutableMap.linear_probe(entries, hash_bucket, entries[i].getKey());
            if (slot >= 0) {
                throw new IllegalArgumentException("duplicate key: " + entries[i].getKey());
            }
            hash_bucket[-1 - slot] = (short)(++i);
        }
        return hash_bucket;
    }

    private static <K, V> int linear_probe(Map.Entry<K, V>[] entries, short[] hash_bucket, Object key) {
        int length = hash_bucket.length;
        int hash = (key.hashCode() & Integer.MAX_VALUE) % length;
        int slot;
        while ((slot = Short.toUnsignedInt(hash_bucket[hash]) - 1) >= 0) {
            if (entries[slot].getKey().equals(key)) {
                return slot;
            }
            hash = (hash + 1) % length;
        }
        return -1 - hash;
    }

    private int linear_probe(Object key) {
        return ImmutableMap.linear_probe(this.entries, this.hash_bucket, key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new ImmutableSet<Map.Entry<K, V>>(this.entries);
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null) {
            return this.linear_probe(key) >= 0;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (Map.Entry<K, V> entry : this.entries) {
                if (!value.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int slot;
        if (key != null && (slot = this.linear_probe(key)) >= 0) {
            return this.entries[slot].getValue();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.entries.length != other.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entries) {
                if (entry.getValue().equals(other.get(entry.getKey()))) continue;
                return false;
            }
        }
        catch (ClassCastException checkedMap) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<K, V> entry : this.entries) {
            hashCode += entry.hashCode();
        }
        return hashCode;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("proxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static final class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient Object[] data;

        SerializationProxy(ImmutableMap<?, ?> map) {
            Map.Entry<K, V>[] entries = map.entries;
            int length = entries.length;
            Object[] local = new Object[length * 2];
            int i = 0;
            for (Map.Entry entry : entries) {
                local[i++] = entry.getKey();
                local[i++] = entry.getValue();
            }
            this.data = local;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            Object[] local = this.data;
            int length = local.length;
            oos.writeInt(length);
            for (int i = 0; i < length; ++i) {
                oos.writeObject(local[i]);
            }
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            int length = ois.readInt();
            if (length < 0) {
                throw new InvalidObjectException("negative length");
            }
            if (length % 2 != 0) {
                throw new InvalidObjectException("odd length");
            }
            Object[] local = new Object[length];
            for (int i = 0; i < length; ++i) {
                local[i] = ois.readObject();
            }
            this.data = local;
        }

        private Object readResolve() throws InvalidObjectException {
            try {
                Object[] local = this.data;
                if (local.length == 0) {
                    return EMPTY;
                }
                int length = local.length / 2;
                Map.Entry[] entries = new Map.Entry[length];
                for (int i = 0; i < length; ++i) {
                    int j = i * 2;
                    entries[i] = new ImmutableEntry<Object, Object>(local[j], local[j + 1]);
                }
                return new ImmutableMap(entries);
            }
            catch (RuntimeException e) {
                InvalidObjectException ioe = new InvalidObjectException("invalid");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }
}

