/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.blobstore.functions.BucketToResourceList;
import org.jclouds.s3.blobstore.functions.ContainerToBucketListOptions;
import org.jclouds.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ListMultipartUploadResponse;
import org.jclouds.s3.domain.ListMultipartUploadsResponse;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.util.S3Utils;
import org.jclouds.util.Predicates2;

@Singleton
public class S3BlobStore
extends BaseBlobStore {
    private final S3Client sync;
    private final Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata;
    private final ContainerToBucketListOptions container2BucketListOptions;
    private final BucketToResourceList bucket2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToObjectMetadata blob2ObjectMetadata;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;

    @Inject
    protected S3BlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, S3Client sync, Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> convertBucketsToStorageMetadata, ContainerToBucketListOptions container2BucketListOptions, BucketToResourceList bucket2ResourceList, ObjectToBlob object2Blob, BlobToHttpGetOptions blob2ObjectGetOptions, BlobToObject blob2Object, BlobToObjectMetadata blob2ObjectMetadata, ObjectToBlobMetadata object2BlobMd, Provider<FetchBlobMetadata> fetchBlobMetadataProvider) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.sync = (S3Client)Preconditions.checkNotNull((Object)sync, (Object)"sync");
        this.convertBucketsToStorageMetadata = (Function)Preconditions.checkNotNull(convertBucketsToStorageMetadata, (Object)"convertBucketsToStorageMetadata");
        this.container2BucketListOptions = (ContainerToBucketListOptions)Preconditions.checkNotNull((Object)container2BucketListOptions, (Object)"container2BucketListOptions");
        this.bucket2ResourceList = (BucketToResourceList)Preconditions.checkNotNull((Object)bucket2ResourceList, (Object)"bucket2ResourceList");
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.object2BlobMd = (ObjectToBlobMetadata)Preconditions.checkNotNull((Object)object2BlobMd, (Object)"object2BlobMd");
        this.blob2ObjectMetadata = (BlobToObjectMetadata)Preconditions.checkNotNull((Object)blob2ObjectMetadata, (Object)"blob2ObjectMetadata");
        this.fetchBlobMetadataProvider = (Provider)Preconditions.checkNotNull(fetchBlobMetadataProvider, (Object)"fetchBlobMetadataProvider");
    }

    public PageSet<? extends StorageMetadata> list() {
        return (PageSet)this.convertBucketsToStorageMetadata.apply(this.sync.listOwnedBuckets());
    }

    public boolean containerExists(String container) {
        return this.sync.bucketExists(container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, (CreateContainerOptions)CreateContainerOptions.NONE);
    }

    public ContainerAccess getContainerAccess(String container) {
        AccessControlList acl = this.sync.getBucketACL(container);
        if (acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
            return ContainerAccess.PUBLIC_READ;
        }
        return ContainerAccess.PRIVATE;
    }

    public void setContainerAccess(String container, ContainerAccess access) {
        CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
        if (access == ContainerAccess.PUBLIC_READ) {
            acl = CannedAccessPolicy.PUBLIC_READ;
        }
        this.sync.updateBucketCannedACL(container, acl);
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        ListBucketOptions httpOptions = this.container2BucketListOptions.apply(options);
        PageSet list = this.bucket2ResourceList.apply(this.sync.listBucket(container, httpOptions));
        return options.isDetailed() ? ((FetchBlobMetadata)this.fetchBlobMetadataProvider.get()).setContainerName(container).apply(list) : list;
    }

    protected void deletePathAndEnsureGone(String path) {
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String in) {
                try {
                    S3BlobStore.this.clearContainer(in);
                    return S3BlobStore.this.sync.deleteBucketIfEmpty(in);
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
            }
        }, (long)30000L).apply((Object)path), (String)"%s still exists after deleting!", (Object)path);
    }

    public boolean blobExists(String container, String key) {
        return this.sync.objectExists(container, key);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.headObject(container, key));
    }

    public Blob getBlob(String container, String key, GetOptions optionsList) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(optionsList);
        return this.object2Blob.apply(this.sync.getObject(container, key, httpOptions));
    }

    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, (PutOptions)PutOptions.NONE);
    }

    public String putBlob(String container, Blob blob, PutOptions overrides) {
        if (overrides.isMultipart()) {
            return this.putMultipartBlob(container, blob, overrides);
        }
        PutObjectOptions options = new PutObjectOptions();
        if (overrides.getBlobAccess() == BlobAccess.PUBLIC_READ) {
            options = options.withAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        return this.sync.putObject(container, this.blob2Object.apply(blob), options);
    }

    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Map userMetadata;
        ContentMetadata contentMetadata;
        CopyObjectOptions s3Options = new CopyObjectOptions();
        if (options.ifMatch() != null) {
            s3Options.ifSourceETagMatches(options.ifMatch());
        }
        if (options.ifNoneMatch() != null) {
            s3Options.ifSourceETagDoesntMatch(options.ifNoneMatch());
        }
        if (options.ifModifiedSince() != null) {
            s3Options.ifSourceModifiedSince(options.ifModifiedSince());
        }
        if (options.ifUnmodifiedSince() != null) {
            s3Options.ifSourceUnmodifiedSince(options.ifUnmodifiedSince());
        }
        if ((contentMetadata = options.contentMetadata()) != null) {
            String contentType;
            String contentLanguage;
            String contentEncoding;
            String contentDisposition;
            String cacheControl = contentMetadata.getCacheControl();
            if (cacheControl != null) {
                s3Options.cacheControl(cacheControl);
            }
            if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
                s3Options.contentDisposition(contentDisposition);
            }
            if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                s3Options.contentEncoding(contentEncoding);
            }
            if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                s3Options.contentLanguage(contentLanguage);
            }
            if ((contentType = contentMetadata.getContentType()) != null) {
                s3Options.contentType(contentType);
            }
        }
        if ((userMetadata = options.userMetadata()) != null) {
            s3Options.overrideMetadataWith(userMetadata);
        }
        return this.sync.copyObject(fromContainer, fromName, toContainer, toName, s3Options).getETag();
    }

    public void removeBlob(String container, String key) {
        this.sync.deleteObject(container, key);
    }

    public void removeBlobs(String container, Iterable<String> keys) {
        for (List partition : Iterables.partition(keys, (int)1000)) {
            this.sync.deleteObjects(container, partition);
        }
    }

    public BlobAccess getBlobAccess(String container, String name) {
        AccessControlList acl = this.sync.getObjectACL(container, name);
        if (acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
            return BlobAccess.PUBLIC_READ;
        }
        return BlobAccess.PRIVATE;
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
        if (access == BlobAccess.PUBLIC_READ) {
            acl = CannedAccessPolicy.PUBLIC_READ;
        }
        this.sync.updateObjectCannedACL(container, name, acl);
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions overrides) {
        PutObjectOptions options = new PutObjectOptions();
        if (overrides.getBlobAccess() == BlobAccess.PUBLIC_READ) {
            options = options.withAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        String id = this.sync.initiateMultipartUpload(container, this.blob2ObjectMetadata.apply(blobMetadata), options);
        return MultipartUpload.create((String)container, (String)blobMetadata.getName(), (String)id, (BlobMetadata)blobMetadata, (PutOptions)overrides);
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        this.sync.abortMultipartUpload(mpu.containerName(), mpu.blobName(), mpu.id());
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MultipartPart part : parts) {
            builder.put((Object)part.partNumber(), (Object)part.partETag());
        }
        return this.sync.completeMultipartUpload(mpu.containerName(), mpu.blobName(), mpu.id(), (Map<Integer, String>)builder.build());
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        long partSize = payload.getContentMetadata().getContentLength();
        String eTag = this.sync.uploadPart(mpu.containerName(), mpu.blobName(), partNumber, mpu.id(), payload);
        Date lastModified = null;
        return MultipartPart.create((int)partNumber, (long)partSize, (String)eTag, lastModified);
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        ImmutableList.Builder parts = ImmutableList.builder();
        Map<Integer, ListMultipartUploadResponse> s3Parts = this.sync.listMultipartPartsFull(mpu.containerName(), mpu.blobName(), mpu.id());
        for (Map.Entry<Integer, ListMultipartUploadResponse> entry : s3Parts.entrySet()) {
            ListMultipartUploadResponse response = entry.getValue();
            parts.add((Object)MultipartPart.create((int)entry.getKey(), (long)response.size(), (String)response.eTag(), (Date)response.lastModified()));
        }
        return parts.build();
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        ListMultipartUploadsResponse response;
        ImmutableList.Builder builder = ImmutableList.builder();
        String keyMarker = null;
        String uploadIdMarker = null;
        do {
            response = this.sync.listMultipartUploads(container, null, null, keyMarker, null, uploadIdMarker);
            for (ListMultipartUploadsResponse.Upload upload : response.uploads()) {
                builder.add((Object)MultipartUpload.create((String)container, (String)upload.key(), (String)upload.uploadId(), null, null));
            }
            keyMarker = response.keyMarker();
            uploadIdMarker = response.uploadIdMarker();
        } while (!response.uploads().isEmpty() && keyMarker != null && uploadIdMarker != null);
        return builder.build();
    }

    public long getMinimumMultipartPartSize() {
        return 0x500000L;
    }

    public long getMaximumMultipartPartSize() {
        return 0x140000000L;
    }

    public int getMaximumNumberOfParts() {
        return 10000;
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        return S3Utils.deleteAndVerifyContainerGone(this.sync, container);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        PutBucketOptions putBucketOptions = new PutBucketOptions();
        if (options.isPublicRead()) {
            putBucketOptions.withBucketAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        location = location != null ? location : (Location)this.defaultLocation.get();
        return this.sync.putBucketInRegion(location.getId(), container, putBucketOptions);
    }
}

