/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.messaging.kafka.AbstractfKafkaSshDriver;
import org.apache.brooklyn.entity.messaging.kafka.KafkaZooKeeper;
import org.apache.brooklyn.entity.messaging.kafka.KafkaZooKeeperDriver;
import org.apache.brooklyn.entity.messaging.kafka.KafkaZooKeeperImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.text.StringEscapes;

public class KafkaZooKeeperSshDriver
extends AbstractfKafkaSshDriver
implements KafkaZooKeeperDriver {
    public KafkaZooKeeperSshDriver(KafkaZooKeeperImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    @Override
    protected Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"zookeeperPort", (Object)this.getZookeeperPort());
    }

    @Override
    protected ConfigKey<String> getConfigTemplateKey() {
        return KafkaZooKeeper.KAFKA_ZOOKEEPER_CONFIG_TEMPLATE;
    }

    @Override
    protected String getConfigFileName() {
        return "zookeeper.properties";
    }

    @Override
    protected String getLaunchScriptName() {
        return "zookeeper-server-start.sh";
    }

    @Override
    protected String getTopicsScriptName() {
        return "kafka-topics.sh";
    }

    @Override
    protected String getProcessIdentifier() {
        return "quorum\\.QuorumPeerMain";
    }

    @Override
    public Integer getZookeeperPort() {
        return (Integer)this.getEntity().getAttribute((AttributeSensor)KafkaZooKeeper.ZOOKEEPER_PORT);
    }

    @Override
    public void createTopic(String topic) {
        String zookeeperUrl = (String)this.getEntity().getAttribute(Attributes.HOSTNAME) + ":" + this.getZookeeperPort();
        this.newScript((String)"customizing").failOnNonZeroResultCode().body.append((CharSequence)String.format("./bin/%s  --create --zookeeper \"%s\" --replication-factor 1 --partitions 1 --topic \"%s\"", this.getTopicsScriptName(), StringEscapes.BashStringEscapes.escapeLiteralForDoubleQuotedBash((String)zookeeperUrl), StringEscapes.BashStringEscapes.escapeLiteralForDoubleQuotedBash((String)topic))).execute();
    }
}

