/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Callables;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslAccessible;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslFunctionSource;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslToStringHelpers;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.AppGroupTraverser;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.core.xstream.ObjectWithDefaultStringImplConverter;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslComponent
extends BrooklynDslDeferredSupplier<Entity>
implements DslFunctionSource {
    private static final Logger log = LoggerFactory.getLogger(DslComponent.class);
    private static final long serialVersionUID = -7715984495268724954L;
    private final String componentId;
    private final DeferredSupplier<?> componentIdSupplier;
    private final DslComponent scopeComponent;
    private final Scope scope;

    public static DslComponent newInstance(DslComponent scopeComponent, Scope scope, Object componentId) {
        if (DslUtils.resolved(componentId)) {
            return new DslComponent(scopeComponent, scope, (String)componentId);
        }
        return new DslComponent(scopeComponent, scope, (DeferredSupplier)componentId);
    }

    public static DslComponent newInstance(Scope scope, Object componentId) {
        if (DslUtils.resolved(componentId)) {
            return new DslComponent(scope, (String)componentId);
        }
        return new DslComponent(scope, (DeferredSupplier)componentId);
    }

    public static DslComponent newInstanceChangingScope(Scope scope, DslComponent old, Function<String, String> dslUpdateFn) {
        DslComponent result = old.componentIdSupplier != null ? new DslComponent(scope, old.componentIdSupplier) : (old.componentId != null ? new DslComponent(scope, old.componentId) : new DslComponent(scope));
        result.dsl = dslUpdateFn != null && old.dsl instanceof String ? dslUpdateFn.apply((String)old.dsl) : old.dsl;
        return result;
    }

    @Deprecated
    public DslComponent(String componentId) {
        this(Scope.GLOBAL, componentId);
    }

    public DslComponent(Scope scope) {
        this(null, scope);
    }

    public DslComponent(DslComponent scopeComponent, Scope scope) {
        this(scopeComponent, scope, (String)null);
    }

    public DslComponent(Scope scope, String componentId) {
        this(null, scope, componentId);
    }

    public DslComponent(Scope scope, DeferredSupplier<?> componentIdSupplier) {
        this(null, scope, componentIdSupplier);
    }

    private DslComponent() {
        this.scopeComponent = null;
        this.componentId = null;
        this.componentIdSupplier = null;
        this.scope = null;
    }

    public DslComponent(DslComponent scopeComponent, Scope scope, String componentId) {
        Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope");
        this.scopeComponent = scopeComponent;
        this.componentId = componentId;
        this.componentIdSupplier = null;
        this.scope = scope;
    }

    public DslComponent(DslComponent scopeComponent, Scope scope, DeferredSupplier<?> componentIdSupplier) {
        Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope");
        this.scopeComponent = scopeComponent;
        this.componentId = null;
        this.componentIdSupplier = componentIdSupplier;
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public DeferredSupplier<?> getComponentIdSupplier() {
        return this.componentIdSupplier;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public DslComponent getScopeComponent() {
        return this.scopeComponent;
    }

    @JsonIgnore
    public final Maybe<Entity> getImmediately() {
        return new EntityInScopeFinder(this.scopeComponent, this.scope, this.componentId, this.componentIdSupplier).getImmediately();
    }

    @Override
    public Task<Entity> newTask() {
        return TaskBuilder.builder().displayName(this.toString()).tag((Object)"TRANSIENT").body((Callable)new EntityInScopeFinder(this.scopeComponent, this.scope, this.componentId, this.componentIdSupplier)).build();
    }

    static ExecutionContext findExecutionContext(Object callerContext) {
        ExecutionContext execContext = BrooklynTaskTags.getCurrentExecutionContext();
        if (execContext == null) {
            throw new IllegalStateException("No execution context available to resolve " + callerContext);
        }
        return execContext;
    }

    @DslAccessible
    public DslComponent entity(Object id) {
        return DslComponent.newInstance(this, Scope.GLOBAL, id);
    }

    @DslAccessible
    public DslComponent child(Object id) {
        return DslComponent.newInstance(this, Scope.CHILD, id);
    }

    @DslAccessible
    public DslComponent sibling(Object id) {
        return DslComponent.newInstance(this, Scope.SIBLING, id);
    }

    @DslAccessible
    public DslComponent descendant(Object id) {
        return DslComponent.newInstance(this, Scope.DESCENDANT, id);
    }

    @DslAccessible
    public DslComponent ancestor(Object id) {
        return DslComponent.newInstance(this, Scope.ANCESTOR, id);
    }

    @DslAccessible
    public DslComponent root() {
        return new DslComponent(this, Scope.ROOT);
    }

    @DslAccessible
    public DslComponent scopeRoot() {
        return new DslComponent(this, Scope.SCOPE_ROOT);
    }

    @Deprecated
    @DslAccessible
    public DslComponent component(Object id) {
        return DslComponent.newInstance(this, Scope.GLOBAL, id);
    }

    @DslAccessible
    public DslComponent self() {
        return new DslComponent(this, Scope.THIS);
    }

    @DslAccessible
    public DslComponent parent() {
        return new DslComponent(this, Scope.PARENT);
    }

    @DslAccessible
    public DslComponent component(String scope, Object id) {
        if (!Scope.isValid(scope)) {
            throw new IllegalArgumentException(scope + " is not a valid scope");
        }
        return DslComponent.newInstance(this, Scope.fromString(scope), id);
    }

    @DslAccessible
    public DslComponent application(Object id) {
        return DslComponent.newInstance(this, Scope.APPLICATIONS, id);
    }

    @DslAccessible
    public DslComponent member(Object id) {
        return DslComponent.newInstance(this, Scope.MEMBERS, id);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<?> entityId() {
        return new EntityId(this);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<?> attributeWhenReady(Object sensorNameOrSupplier) {
        return new AttributeWhenReady(this, sensorNameOrSupplier);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<?> config(Object keyNameOrSupplier) {
        return new DslConfigSupplier(this, keyNameOrSupplier);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<Sensor<?>> sensor(Object sensorIndicator) {
        return new DslSensorSupplier(this, sensorIndicator);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<Object> location() {
        return new DslLocationSupplier(this, 0);
    }

    @DslAccessible
    public BrooklynDslDeferredSupplier<Object> location(Object index) {
        return new DslLocationSupplier(this, index);
    }

    public Object template(Object template) {
        return new DslTemplate(this, template);
    }

    public Object template(Object template, Map<?, ?> substitutions) {
        return new DslTemplate(this, template, substitutions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.componentId, this.scopeComponent, this.scope});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DslComponent that = (DslComponent)DslComponent.class.cast(obj);
        return Objects.equal((Object)this.componentId, (Object)that.componentId) && Objects.equal((Object)this.scopeComponent, (Object)that.scopeComponent) && Objects.equal((Object)((Object)this.scope), (Object)((Object)that.scope));
    }

    public String toString() {
        DeferredSupplier<?> component;
        DeferredSupplier<?> deferredSupplier = component = this.componentId != null ? this.componentId : this.componentIdSupplier;
        if (this.scope == Scope.GLOBAL) {
            return DslToStringHelpers.fn("entity", component);
        }
        if (this.scope == Scope.THIS) {
            if (this.scopeComponent != null) {
                return this.scopeComponent.toString();
            }
            return DslToStringHelpers.fn("entity", "this", "");
        }
        String remainder = component == null || "".equals(component) ? DslToStringHelpers.fn(this.scope.toString(), new Object[0]) : DslToStringHelpers.fn(this.scope.toString(), component);
        return DslToStringHelpers.component(this.scopeComponent, remainder);
    }

    public static enum Scope {
        APPLICATIONS,
        GLOBAL,
        CHILD,
        PARENT,
        SIBLING,
        DESCENDANT,
        MEMBERS,
        MEMBERS_ONLY,
        ANCESTOR,
        ROOT,
        SCOPE_ROOT,
        THIS;

        private static Converter<String, String> converter;

        public static Scope fromString(String name) {
            Maybe<Scope> parsed = Scope.tryFromString(name);
            return (Scope)((Object)parsed.get());
        }

        public static Maybe<Scope> tryFromString(String name) {
            try {
                Scope scope = Scope.valueOf((String)converter.convert((Object)name));
                return Maybe.of((Object)((Object)scope));
            }
            catch (Exception cause) {
                return Maybe.absent((Throwable)cause);
            }
        }

        public static boolean isValid(String name) {
            Maybe<Scope> check = Scope.tryFromString(name);
            return check.isPresentAndNonNull();
        }

        public String toString() {
            return (String)converter.reverse().convert((Object)this.name());
        }

        static {
            converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
        }
    }

    public static final class DslTemplate
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = -585564936781673667L;
        private DslComponent component;
        private Object template;
        private Map<?, ?> substitutions;

        public DslTemplate(DslComponent component, Object template) {
            this(component, template, (Map<?, ?>)ImmutableMap.of());
        }

        public DslTemplate(DslComponent component, Object template, Map<?, ?> substitutions) {
            this.component = component;
            this.template = template;
            this.substitutions = substitutions;
        }

        public DslComponent getComponent() {
            return this.component;
        }

        public Object getTemplate() {
            return this.template;
        }

        public Map<?, ?> getSubstitutions() {
            return this.substitutions;
        }

        private String resolveTemplate(boolean immediately) {
            if (this.template instanceof String) {
                return (String)this.template;
            }
            return (String)Tasks.resolving((Object)this.template).as(String.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving template from " + this.template).get();
        }

        private Map<String, ?> resolveSubstitutions(boolean immediately) {
            return (Map)Tasks.resolving(this.substitutions).as(Object.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).deep().description("Resolving substitutions " + this.substitutions + " for template " + this.template).get();
        }

        @JsonIgnore
        public Maybe<Object> getImmediately() {
            String resolvedTemplate = this.resolveTemplate(true);
            Map<String, ?> resolvedSubstitutions = this.resolveSubstitutions(true);
            Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
            if (targetEntityMaybe.isAbsent()) {
                return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity is not available: " + this.component), targetEntityMaybe);
            }
            Entity targetEntity = (Entity)targetEntityMaybe.get();
            String evaluatedTemplate = TemplateProcessor.processTemplateContents((String)"$brooklyn:template", (String)resolvedTemplate, (EntityInternal)((EntityInternal)targetEntity), resolvedSubstitutions);
            return Maybe.of((Object)evaluatedTemplate);
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().displayName("evaluating template " + this.template).dynamic(false).body((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Entity targetEntity = (Entity)component.get();
                    Map resolvedSubstitutions = this.resolveSubstitutions(false);
                    return TemplateProcessor.processTemplateContents((String)"$brooklyn:template", (String)this.resolveTemplate(false), (EntityInternal)((EntityInternal)targetEntity), (Map)resolvedSubstitutions);
                }
            }).build();
        }
    }

    public static final class DslLocationSupplier
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = 5597335296158584040L;
        private final DslComponent component;
        private final Object index;

        public DslLocationSupplier(DslComponent component, Object index) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.index = index;
        }

        public Object getIndex() {
            return this.index;
        }

        public DslComponent getComponent() {
            return this.component;
        }

        @JsonIgnore
        public final Maybe<Object> getImmediately() {
            Callable<Object> job = new Callable<Object>(){

                @Override
                public Object call() {
                    Maybe<Entity> targetEntityMaybe = component.getImmediately();
                    if (targetEntityMaybe.isAbsent()) {
                        return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity not available: " + component), targetEntityMaybe);
                    }
                    Entity targetEntity = (Entity)targetEntityMaybe.get();
                    int indexI = this.resolveIndex(true);
                    Collection locations = this.getLocations(targetEntity);
                    if (locations.isEmpty()) {
                        throw new ImmediateSupplier.ImmediateValueNotAvailableException("Target entity has no locations: " + component);
                    }
                    if (locations.size() < indexI + 1) {
                        throw new IndexOutOfBoundsException("Target entity (" + component + ") has " + locations.size() + " location(s), but requested index " + index);
                    }
                    Location result = (Location)Iterables.get((Iterable)locations, (int)indexI);
                    if (result == null) {
                        throw new NullPointerException("Target entity (" + component + ") has null location at index " + index);
                    }
                    return result;
                }
            };
            return DslComponent.findExecutionContext(this).getImmediately((Object)job);
        }

        @Override
        public Task<Object> newTask() {
            final boolean immediate = false;
            Callable<Object> job = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Entity targetEntity = (Entity)component.get();
                    int indexI = this.resolveIndex(immediate);
                    String tag = "DSL:entity('" + targetEntity.getId() + "').location('" + indexI + "')";
                    this.checkAndTagForRecursiveReference(targetEntity, tag);
                    Collection locations = this.getLocations(targetEntity);
                    if (locations.size() < indexI + 1) {
                        throw new IndexOutOfBoundsException("Target entity (" + component + ") has " + locations.size() + " location(s), but requested index " + index);
                    }
                    Location result = (Location)Iterables.get((Iterable)locations, (int)indexI);
                    if (result == null) {
                        throw new NullPointerException("Target entity (" + component + ") has null location at index " + index);
                    }
                    return result;
                }
            };
            return Tasks.builder().displayName("retrieving locations[" + this.index + "] for " + this.component).tag((Object)"TRANSIENT").dynamic(false).body((Callable)job).build();
        }

        private int resolveIndex(boolean immediately) {
            if (this.index instanceof String || this.index instanceof Number) {
                return (Integer)TypeCoercions.coerce((Object)this.index, Integer.class);
            }
            Integer result = (Integer)Tasks.resolving((Object)this.index).as(Integer.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving index from " + this.index).get();
            return result;
        }

        private Collection<Location> getLocations(Entity entity) {
            Collection locations = entity.getLocations();
            locations = Locations.getLocationsCheckingAncestors((Collection)locations, (Entity)entity);
            return ImmutableList.copyOf((Collection)locations);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslLocationSupplier that = (DslLocationSupplier)DslLocationSupplier.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component) && Objects.equal((Object)this.index, (Object)that.index);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("location", this.index));
        }
    }

    public static final class DslSensorSupplier
    extends BrooklynDslDeferredSupplier<Sensor<?>> {
        private final DslComponent component;
        @XStreamConverter(value=ObjectWithDefaultStringImplConverter.class)
        private final Object sensorName;
        private static final long serialVersionUID = -4735177561947722511L;

        public DslSensorSupplier(DslComponent component, Object sensorIndicator) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.sensorName = sensorIndicator;
        }

        public Object getSensorName() {
            return this.sensorName;
        }

        public DslComponent getComponent() {
            return this.component;
        }

        @JsonIgnore
        public Maybe<Sensor<?>> getImmediately() {
            return this.getImmediately(this.sensorName, false);
        }

        protected Maybe<Sensor<?>> getImmediately(Object si, boolean resolved) {
            if (si instanceof Sensor) {
                return Maybe.of((Object)((Sensor)si));
            }
            if (si instanceof String) {
                Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
                if (targetEntityMaybe.isAbsent()) {
                    return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity is not available: " + this.component), targetEntityMaybe);
                }
                Entity targetEntity = (Entity)targetEntityMaybe.get();
                Sensor result = null;
                if (targetEntity != null) {
                    result = targetEntity.getEntityType().getSensor((String)si);
                }
                if (result != null) {
                    return Maybe.of(result);
                }
                return Maybe.of((Object)Sensors.newSensor(Object.class, (String)((String)si)));
            }
            if (!resolved) {
                ExecutionContext executionContext = DslSensorSupplier.entity().getExecutionContext();
                Maybe resolvedSi = Tasks.resolving((Object)si, Object.class).deep().immediately(true).context(executionContext).getMaybe();
                if (resolvedSi.isAbsent()) {
                    return Maybe.absent();
                }
                return this.getImmediately(resolvedSi.get(), true);
            }
            throw new IllegalStateException("Cannot resolve '" + this.sensorName + "' as a sensor (got type " + (si == null ? "null" : si.getClass().getName() + ")"));
        }

        @Override
        public Task<Sensor<?>> newTask() {
            return Tasks.builder().displayName("looking up sensor for " + this.sensorName).dynamic(false).body(new Callable<Sensor<?>>(){

                @Override
                public Sensor<?> call() throws Exception {
                    return this.resolve(sensorName, false);
                }

                public Sensor<?> resolve(Object si, boolean resolved) throws ExecutionException, InterruptedException {
                    if (si instanceof Sensor) {
                        return (Sensor)si;
                    }
                    if (si instanceof String) {
                        Entity targetEntity = (Entity)component.get();
                        Sensor result = null;
                        if (targetEntity != null) {
                            result = targetEntity.getEntityType().getSensor((String)si);
                        }
                        if (result != null) {
                            return result;
                        }
                        return Sensors.newSensor(Object.class, (String)((String)si));
                    }
                    if (!resolved) {
                        ExecutionContext executionContext = DslSensorSupplier.entity().getExecutionContext();
                        return this.resolve(Tasks.resolveDeepValueWithoutCoercion((Object)si, (ExecutionContext)executionContext), true);
                    }
                    throw new IllegalStateException("Cannot resolve '" + sensorName + "' as a sensor (got type " + (si == null ? "null" : si.getClass().getName() + ")"));
                }
            }).build();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component, this.sensorName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslSensorSupplier that = (DslSensorSupplier)DslSensorSupplier.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component) && Objects.equal((Object)this.sensorName, (Object)that.sensorName);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("sensorName", this.sensorName instanceof Sensor ? ((Sensor)this.sensorName).getName() : this.sensorName));
        }
    }

    public static final class DslConfigSupplier
    extends BrooklynDslDeferredSupplier<Object> {
        private final DslComponent component;
        @XStreamConverter(value=ObjectWithDefaultStringImplConverter.class)
        private final Object keyName;
        private static final long serialVersionUID = -4735177561947722511L;

        private DslConfigSupplier() {
            this.component = null;
            this.keyName = null;
        }

        public DslConfigSupplier(DslComponent component, Object keyName) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.keyName = keyName;
        }

        public Object getKeyName() {
            return this.keyName;
        }

        public DslComponent getComponent() {
            return this.component;
        }

        protected String resolveKeyName(boolean immediately) {
            if (this.keyName instanceof String) {
                return (String)this.keyName;
            }
            return (String)Tasks.resolving((Object)this.keyName).as(String.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving key name from " + this.keyName).get();
        }

        @JsonIgnore
        public final Maybe<Object> getImmediately() {
            Maybe maybeWrappedMaybe = DslComponent.findExecutionContext(this).getImmediately(this.newCallableReturningImmediateMaybeOrNonImmediateValue(true));
            if (maybeWrappedMaybe.isAbsent()) {
                return maybeWrappedMaybe;
            }
            return Maybe.cast((Maybe)((Maybe)maybeWrappedMaybe.get()));
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().displayName("retrieving config for " + this.keyName).tag((Object)"TRANSIENT").dynamic(false).body(this.newCallableReturningImmediateMaybeOrNonImmediateValue(false)).build();
        }

        private Callable<Object> newCallableReturningImmediateMaybeOrNonImmediateValue(final boolean immediate) {
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Entity targetEntity;
                    if (immediate) {
                        Maybe<Entity> targetEntityMaybe = component.getImmediately();
                        if (targetEntityMaybe.isAbsent()) {
                            return Maybe.cast(targetEntityMaybe);
                        }
                        targetEntity = (EntityInternal)targetEntityMaybe.get();
                    } else {
                        targetEntity = (Entity)component.get();
                    }
                    String tag = "DSL:entity('" + targetEntity.getId() + "').config('" + keyName + "')";
                    this.checkAndTagForRecursiveReference(targetEntity, tag);
                    String keyNameS = this.resolveKeyName(true);
                    ConfigKey key = targetEntity.getEntityType().getConfigKey(keyNameS);
                    if (key == null) {
                        key = ConfigKeys.newConfigKey(Object.class, (String)keyNameS);
                    }
                    if (immediate) {
                        return ((EntityInternal)targetEntity).config().getNonBlocking(key, true);
                    }
                    return targetEntity.getConfig(key);
                }
            };
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component, this.keyName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslConfigSupplier that = (DslConfigSupplier)DslConfigSupplier.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component) && Objects.equal((Object)this.keyName, (Object)that.keyName);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("config", this.keyName));
        }
    }

    public static class AttributeWhenReady
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = 1740899524088902383L;
        private final DslComponent component;
        @XStreamConverter(value=ObjectWithDefaultStringImplConverter.class)
        private final Object sensorName;

        private AttributeWhenReady() {
            this.component = null;
            this.sensorName = null;
        }

        public AttributeWhenReady(DslComponent component, Object sensorName) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
            this.sensorName = sensorName;
        }

        public Object getSensorName() {
            return this.sensorName;
        }

        public DslComponent getComponent() {
            return this.component;
        }

        protected String resolveSensorName(boolean immediately) {
            if (this.sensorName instanceof String) {
                return (String)this.sensorName;
            }
            return (String)Tasks.resolving((Object)this.sensorName).as(String.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving sensorName from " + this.sensorName).get();
        }

        @JsonIgnore
        public final Maybe<Object> getImmediately() {
            Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
            if (targetEntityMaybe.isAbsent()) {
                return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity not available: " + this.component), targetEntityMaybe);
            }
            Entity targetEntity = (Entity)targetEntityMaybe.get();
            String sensorNameS = this.resolveSensorName(true);
            AttributeSensor targetSensor = (AttributeSensor)targetEntity.getEntityType().getSensor(sensorNameS);
            if (targetSensor == null) {
                targetSensor = Sensors.newSensor(Object.class, (String)sensorNameS);
            }
            Object result = targetEntity.sensors().get(targetSensor);
            AttributeSensor ts2 = targetSensor;
            return JavaGroovyEquivalents.groovyTruth((Object)result) ? Maybe.of((Object)result) : ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWithExceptionSupplier(() -> "Sensor '" + ts2 + "' on " + targetEntity + " not immediately available");
        }

        @Override
        public Task<Object> newTask() {
            Entity targetEntity = (Entity)this.component.get();
            String sensorNameS = this.resolveSensorName(false);
            Sensor targetSensor = targetEntity.getEntityType().getSensor(sensorNameS);
            if (!(targetSensor instanceof AttributeSensor)) {
                targetSensor = Sensors.newSensor(Object.class, (String)sensorNameS);
            }
            return DependentConfiguration.attributeWhenReady((Entity)targetEntity, (AttributeSensor)((AttributeSensor)targetSensor));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component, this.sensorName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeWhenReady that = (AttributeWhenReady)AttributeWhenReady.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component) && Objects.equal((Object)this.sensorName, (Object)that.sensorName);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("attributeWhenReady", this.sensorName));
        }
    }

    protected static class EntityId
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = -419427634694971033L;
        private final DslComponent component;

        public EntityId(DslComponent component) {
            this.component = (DslComponent)Preconditions.checkNotNull((Object)component);
        }

        @JsonIgnore
        public Maybe<Object> getImmediately() {
            Maybe<Entity> targetEntityMaybe = this.component.getImmediately();
            if (targetEntityMaybe.isAbsent()) {
                return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)("Target entity is not available: " + this.component), targetEntityMaybe);
            }
            Entity targetEntity = (Entity)targetEntityMaybe.get();
            return Maybe.of((Object)targetEntity.getId());
        }

        @Override
        public Task<Object> newTask() {
            Entity targetEntity = (Entity)this.component.get();
            return Tasks.create((String)"identity", (Callable)Callables.returning((Object)targetEntity.getId()));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.component});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EntityId that = (EntityId)EntityId.class.cast(obj);
            return Objects.equal((Object)this.component, (Object)that.component);
        }

        public String toString() {
            return DslToStringHelpers.component(this.component, DslToStringHelpers.fn("entityId", new Object[0]));
        }
    }

    protected static class EntityInScopeFinder
    implements Callable<Entity>,
    ImmediateSupplier<Entity> {
        protected final DslComponent scopeComponent;
        protected final Scope scope;
        protected final String componentId;
        protected final DeferredSupplier<?> componentIdSupplier;

        public EntityInScopeFinder(DslComponent scopeComponent, Scope scope, String componentId, DeferredSupplier<?> componentIdSupplier) {
            this.scopeComponent = scopeComponent;
            this.scope = scope;
            this.componentId = componentId;
            this.componentIdSupplier = componentIdSupplier;
        }

        @JsonIgnore
        public Maybe<Entity> getImmediately() {
            try {
                return this.callImpl(true);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public Entity get() {
            try {
                return this.call();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        @Override
        public Entity call() throws Exception {
            return (Entity)this.callImpl(false).get();
        }

        protected Maybe<Entity> getEntity(boolean immediate) {
            if (this.scopeComponent != null) {
                if (immediate) {
                    return this.scopeComponent.getImmediately();
                }
                return Maybe.of(this.scopeComponent.get());
            }
            return Maybe.ofDisallowingNull((Object)DslComponent.entity()).or(Maybe.absent((String)"Context entity not available when trying to evaluate Brooklyn DSL"));
        }

        static DslEntityResolver getResolverForScope(Scope scope) {
            switch (scope) {
                case THIS: {
                    return new SingleRelativeEntityResolver(entity -> entity);
                }
                case PARENT: {
                    return new SingleRelativeEntityResolver(Entity::getParent);
                }
                case ROOT: {
                    return new SingleRelativeEntityResolver(Entity::getApplication);
                }
                case SCOPE_ROOT: {
                    return new SingleRelativeEntityResolver(Entities::catalogItemScopeRoot);
                }
                case APPLICATIONS: {
                    return new ApplicationEntityResolver();
                }
                case GLOBAL: {
                    return new AcceptableEntityResolver(entity -> {
                        if (Entities.isManaged((Entity)entity)) {
                            String appId = entity.getApplicationId();
                            return ee -> appId != null && appId.equals(ee.getApplicationId());
                        }
                        if (entity != null && entity.getApplication() != null) {
                            MutableSet toVisit = MutableSet.of((Object)entity.getApplication());
                            MutableSet visited = MutableSet.of((Object)entity.getApplication());
                            while (!toVisit.isEmpty()) {
                                MutableSet visiting = MutableSet.copyOf((Iterable)toVisit);
                                toVisit.clear();
                                visiting.forEach(arg_0 -> EntityInScopeFinder.lambda$null$3((Set)visited, (Set)toVisit, arg_0));
                            }
                            return ((Set)visited)::contains;
                        }
                        return x -> true;
                    });
                }
                case DESCENDANT: {
                    return new AcceptableEntityResolver(entity -> arg_0 -> MutableSet.copyOf((Iterable)Entities.descendantsWithoutSelf((Entity)entity)).contains(arg_0));
                }
                case MEMBERS: {
                    return new AcceptableEntityResolver(entity -> arg_0 -> MutableSet.copyOf((Iterable)Entities.descendantsAndMembersWithoutSelf((Entity)entity)).contains(arg_0));
                }
                case MEMBERS_ONLY: {
                    return new AcceptableEntityResolver(entity -> {
                        MutableSet acceptable = MutableSet.of();
                        if (entity instanceof Group) {
                            acceptable.addAll(((Group)entity).getMembers());
                        }
                        return ((Set)acceptable)::contains;
                    });
                }
                case ANCESTOR: {
                    return new AcceptableEntityResolver(entity -> arg_0 -> MutableSet.copyOf((Iterable)Entities.ancestorsWithoutSelf((Entity)entity)).contains(arg_0));
                }
                case SIBLING: {
                    return new AcceptableEntityResolver(entity -> {
                        com.google.common.base.Predicate notSelfPredicate = Predicates.not((com.google.common.base.Predicate)Predicates.equalTo((Object)entity));
                        return arg_0 -> MutableSet.copyOf((Iterable)Iterables.filter((Iterable)entity.getParent().getChildren(), (com.google.common.base.Predicate)notSelfPredicate)).contains(arg_0);
                    });
                }
                case CHILD: {
                    return new AcceptableEntityResolver(entity -> arg_0 -> MutableSet.copyOf((Iterable)entity.getChildren()).contains(arg_0));
                }
            }
            throw new IllegalStateException("Unexpected scope " + (Object)((Object)scope));
        }

        protected Maybe<Entity> callImpl(boolean immediate) throws Exception {
            DslEntityResolver resolver = EntityInScopeFinder.getResolverForScope(this.scope);
            resolver.withScope(this.scope);
            if (resolver.needsBaseEntity) {
                Maybe<Entity> entityMaybe = this.getEntity(immediate);
                if (immediate && entityMaybe.isAbsent()) {
                    return entityMaybe;
                }
                resolver.withBaseEntity((Entity)entityMaybe.get());
            }
            if (resolver.needsComponentId) {
                if (this.componentId == null) {
                    if (this.componentIdSupplier == null) {
                        throw new IllegalArgumentException("No component-id or component-id supplier, when resolving entity in scope '" + (Object)((Object)this.scope) + "' wrt " + resolver.entity);
                    }
                    Maybe maybeComponentId = Tasks.resolving(this.componentIdSupplier).as(Object.class).context(this.getExecutionContext()).immediately(immediate).description("Resolving component-id from " + this.componentIdSupplier).getMaybe();
                    if (immediate && maybeComponentId.isAbsent()) {
                        return ImmediateSupplier.ImmediateValueNotAvailableException.newAbsentWrapping((String)"Cannot find component ID", (Maybe)maybeComponentId);
                    }
                    Object candidate = maybeComponentId.get();
                    if (candidate instanceof BrooklynObject) {
                        resolver.withComponentId(((BrooklynObject)candidate).getId());
                        if (resolver.test((Entity)candidate)) {
                            return Maybe.of((Object)((Entity)candidate));
                        }
                        throw new IllegalStateException("Resolved component " + maybeComponentId.get() + " is not in scope '" + (Object)((Object)this.scope) + "' wrt " + resolver.entity);
                    }
                    resolver.withComponentId((String)TypeCoercions.coerce((Object)maybeComponentId.get(), String.class));
                    if (Strings.isBlank((CharSequence)resolver.componentId)) {
                        throw new IllegalStateException("component-id blank, from " + this.componentIdSupplier);
                    }
                } else {
                    resolver.withComponentId(this.componentId);
                }
            }
            return resolver.resolve();
        }

        private ExecutionContext getExecutionContext() {
            return DslComponent.findExecutionContext(this);
        }

        private static /* synthetic */ void lambda$null$3(Set visited, Set toVisit, Entity e) {
            e.getChildren().forEach(ec -> {
                if (visited.add(ec)) {
                    toVisit.add(ec);
                }
            });
        }

        static class AcceptableEntityResolver
        extends DslEntityResolver {
            Function<Entity, Predicate<Entity>> acceptableEntityProducer;
            Predicate<Entity> acceptableEntity;

            public AcceptableEntityResolver(Function<Entity, Predicate<Entity>> acceptableEntityProducer) {
                this.needsBaseEntity = true;
                this.needsComponentId = true;
                this.acceptableEntityProducer = acceptableEntityProducer;
            }

            @Override
            boolean test(Entity entity) {
                return this.acceptableEntity.test(entity);
            }

            @Override
            void withBaseEntity(Entity entity) {
                super.withBaseEntity(entity);
                this.acceptableEntity = this.acceptableEntityProducer.apply(entity);
            }

            @Override
            Maybe<Entity> resolve() {
                List firstGroupOfMatches = AppGroupTraverser.findFirstGroupOfMatches((Entity)this.entity, (boolean)true, arg_0 -> ((com.google.common.base.Predicate)Predicates.and((com.google.common.base.Predicate)EntityPredicates.configEqualTo(BrooklynCampConstants.PLAN_ID, (Object)this.componentId), this.acceptableEntity::test)).apply(arg_0));
                if (firstGroupOfMatches.isEmpty()) {
                    firstGroupOfMatches = AppGroupTraverser.findFirstGroupOfMatches((Entity)this.entity, (boolean)true, arg_0 -> ((com.google.common.base.Predicate)Predicates.and((com.google.common.base.Predicate)EntityPredicates.idEqualTo((String)this.componentId), this.acceptableEntity::test)).apply(arg_0));
                }
                if (!firstGroupOfMatches.isEmpty()) {
                    return Maybe.of(firstGroupOfMatches.get(0));
                }
                return Maybe.absent((Throwable)new NoSuchElementException("No entity matching id '" + this.componentId + "'" + (this.scope == Scope.GLOBAL ? " near entity " : " in scope " + (Object)((Object)this.scope) + " of ") + this.entity));
            }
        }

        static class SingleRelativeEntityResolver
        extends DslEntityResolver {
            private final Function<Entity, Maybe<Entity>> relativeFinder;

            public SingleRelativeEntityResolver(Function<Entity, Entity> relativeFinder) {
                this.needsBaseEntity = true;
                this.relativeFinder = input -> {
                    Entity result = (Entity)relativeFinder.apply((Entity)input);
                    if (result == null) {
                        return Maybe.absent((String)("No entity found for scope " + (Object)((Object)this.scope) + " realtive to " + this.entity));
                    }
                    return Maybe.of((Object)result);
                };
            }

            @Override
            boolean test(Entity entity) {
                return false;
            }

            @Override
            Maybe<Entity> resolve() {
                return this.relativeFinder.apply(this.entity);
            }
        }

        static class ApplicationEntityResolver
        extends DslEntityResolver {
            public ApplicationEntityResolver() {
                this.needsBaseEntity = false;
                this.needsComponentId = true;
            }

            @Override
            boolean test(Entity entity) {
                return entity.getParent() == null;
            }

            @Override
            Maybe<Entity> resolve() {
                MutableList allMatches;
                List appMatches;
                Entity result = DslComponent.managementContext().getEntityManager().getEntity(this.componentId);
                Entity nonAppMatch = null;
                if (result != null) {
                    if (this.test(result)) {
                        Maybe.of((Object)result);
                    }
                    nonAppMatch = result;
                }
                if (!(appMatches = (allMatches = DslComponent.managementContext().getEntityManager().getEntities().stream().filter(EntityPredicates.configEqualTo(BrooklynCampConstants.PLAN_ID, (Object)this.componentId)).collect(Collectors.toList())).stream().filter(this::test).collect(Collectors.toList())).isEmpty()) {
                    if (appMatches.size() > 1) {
                        log.warn("Multiple matches for '" + this.componentId + "', returning the first: " + appMatches);
                    }
                    return Maybe.of(appMatches.iterator().next());
                }
                if (nonAppMatch != null) {
                    allMatches = MutableList.of((Object)nonAppMatch).appendAll(allMatches);
                }
                return Maybe.absent((String)("No application entity matching ID '" + this.componentId + "'" + (allMatches.isEmpty() ? "" : "; non-application entity matches: " + allMatches)));
            }
        }

        static abstract class DslEntityResolver {
            Scope scope;
            boolean needsBaseEntity;
            boolean needsComponentId;
            Entity entity;
            String componentId;

            DslEntityResolver() {
            }

            public void withScope(Scope scope) {
                this.scope = scope;
            }

            void withBaseEntity(Entity entity) {
                this.entity = entity;
            }

            void withComponentId(String componentId) {
                this.componentId = componentId;
            }

            abstract boolean test(Entity var1);

            abstract Maybe<Entity> resolve();
        }
    }
}

