/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.access.trans.JoinTreeNode;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.commons.collections.Transformer;

public class JoinStack {
    protected JoinTreeNode rootNode = new JoinTreeNode(this);
    protected JoinTreeNode topNode;
    private QuotingStrategy strategy;
    private int aliasCounter;
    private QualifierTranslator qualifierTranslator;

    protected JoinStack(DbAdapter dbAdapter, DataMap dataMap, QueryAssembler assembler) {
        this.rootNode.setTargetTableAlias(this.newAlias());
        boolean status = dataMap != null && dataMap.isQuotingSQLIdentifiers();
        this.strategy = dbAdapter.getQuotingStrategy(status);
        this.qualifierTranslator = dbAdapter.getQualifierTranslator(assembler);
        this.resetStack();
    }

    String getCurrentAlias() {
        return this.topNode.getTargetTableAlias();
    }

    protected int size() {
        return this.rootNode.size() - 1;
    }

    void appendRoot(Appendable out, DbEntity rootEntity) throws IOException {
        out.append(rootEntity.getFullyQualifiedName());
        out.append(' ').append(this.rootNode.getTargetTableAlias());
    }

    void appendRootWithQuoteSqlIdentifiers(Appendable out, DbEntity rootEntity) throws IOException {
        if (rootEntity.getSchema() != null) {
            out.append(this.strategy.quoteString(rootEntity.getSchema()));
            out.append(".");
        }
        out.append(this.strategy.quoteString(rootEntity.getName()));
        out.append(' ');
        out.append(this.strategy.quoteString(this.rootNode.getTargetTableAlias()));
    }

    protected void appendJoins(Appendable out) throws IOException {
        for (JoinTreeNode child : this.rootNode.getChildren()) {
            this.appendJoinSubtree(out, child);
        }
    }

    protected void appendJoinSubtree(Appendable out, JoinTreeNode node) throws IOException {
        DbRelationship relationship = node.getRelationship();
        DbEntity targetEntity = (DbEntity)relationship.getTargetEntity();
        String srcAlias = node.getSourceTableAlias();
        String targetAlias = node.getTargetTableAlias();
        switch (node.getJoinType()) {
            case INNER: {
                out.append(" JOIN");
                break;
            }
            case LEFT_OUTER: {
                out.append(" LEFT JOIN");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported join type: " + (Object)((Object)node.getJoinType()));
            }
        }
        out.append(' ');
        if (targetEntity.getSchema() != null) {
            out.append(this.strategy.quoteString(targetEntity.getSchema()));
            out.append(".");
        }
        out.append(this.strategy.quoteString(targetEntity.getName()));
        out.append(' ');
        out.append(this.strategy.quoteString(targetAlias));
        out.append(" ON (");
        List<DbJoin> joins = relationship.getJoins();
        int len = joins.size();
        for (int i = 0; i < len; ++i) {
            DbJoin join = joins.get(i);
            if (i > 0) {
                out.append(" AND ");
            }
            out.append(this.strategy.quoteString(srcAlias));
            out.append('.');
            out.append(this.strategy.quoteString(join.getSourceName()));
            out.append(" = ");
            out.append(this.strategy.quoteString(targetAlias));
            out.append('.');
            out.append(this.strategy.quoteString(join.getTargetName()));
        }
        Expression dbQualifier = targetEntity.getQualifier();
        if (dbQualifier != null) {
            dbQualifier = dbQualifier.transform(new JoinedDbEntityQualifierTransformer(node));
            if (len > 0) {
                out.append(" AND ");
            }
            this.qualifierTranslator.setOut(out);
            this.qualifierTranslator.doAppendPart(dbQualifier);
        }
        out.append(')');
        for (JoinTreeNode child : node.getChildren()) {
            this.appendJoinSubtree(out, child);
        }
    }

    protected void appendQualifier(Appendable out, boolean firstQualifierElement) throws IOException {
    }

    void resetStack() {
        this.topNode = this.rootNode;
    }

    void pushJoin(DbRelationship relationship, JoinType joinType, String alias) {
        this.topNode = this.topNode.findOrCreateChild(relationship, joinType, alias);
    }

    protected String newAlias() {
        return "t" + this.aliasCounter++;
    }

    class JoinedDbEntityQualifierTransformer
    implements Transformer {
        StringBuilder pathToRoot = new StringBuilder();

        JoinedDbEntityQualifierTransformer(JoinTreeNode node) {
            while (node != null && node.getRelationship() != null) {
                String relName = node.getRelationship().getName();
                if (node.getJoinType() == JoinType.LEFT_OUTER) {
                    relName = relName + "+";
                }
                relName = relName + ".";
                this.pathToRoot.insert(0, relName);
                node = node.getParent();
            }
        }

        public Object transform(Object input) {
            if (input instanceof ASTPath) {
                return new ASTDbPath(this.pathToRoot.toString() + ((ASTPath)input).getOperand(0));
            }
            return input;
        }
    }
}

