/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.editor.EmbeddableAttributeTab;
import org.apache.cayenne.modeler.editor.EmbeddableTab;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;

public class EmbeddableTabbedView
extends JTabbedPane
implements EmbeddableAttributeDisplayListener,
EmbeddableDisplayListener {
    protected ProjectController mediator;
    protected JScrollPane embeddablePanel;
    protected EmbeddableAttributeTab attributesPanel;
    protected JPanel listenersPanel;

    public EmbeddableTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setTabPlacement(1);
        this.embeddablePanel = new JScrollPane(new EmbeddableTab(this.mediator));
        this.addTab("Embeddable", this.embeddablePanel);
        this.attributesPanel = new EmbeddableAttributeTab(this.mediator);
        this.addTab("Attributes", this.attributesPanel);
    }

    private void initController() {
        this.mediator.addEmbeddableAttributeDisplayListener(this);
        this.mediator.addEmbeddableDisplayListener(this);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EmbeddableTabbedView.this.resetRemoveButtons();
                Component selected = EmbeddableTabbedView.this.getSelectedComponent();
                while (selected instanceof JScrollPane) {
                    selected = ((JScrollPane)selected).getViewport().getView();
                }
                if (selected instanceof ExistingSelectionProcessor) {
                    ((ExistingSelectionProcessor)((Object)selected)).processExistingSelection(e);
                }
            }
        });
    }

    private void resetRemoveButtons() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        actionManager.getAction(RemoveAttributeAction.class).setEnabled(false);
        actionManager.getAction(RemoveCallbackMethodAction.class).setEnabled(false);
    }

    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        Embeddable emb = e.getEmbeddable();
        if (e.isMainTabFocus() && emb instanceof Embeddable && this.getSelectedComponent() != this.embeddablePanel) {
            this.setSelectedComponent(this.embeddablePanel);
            this.embeddablePanel.setVisible(true);
        }
        this.resetRemoveButtons();
        this.setVisible(e.getEmbeddable() != null);
    }

    public void currentEmbeddableAttributeChanged(EmbeddableAttributeDisplayEvent e) {
        if (e.getEmbeddable() == null) {
            return;
        }
        EmbeddableAttribute[] attrs = e.getEmbeddableAttributes();
        EmbeddableAttribute[] embAttrs = new EmbeddableAttribute[attrs.length];
        System.arraycopy(attrs, 0, embAttrs, 0, attrs.length);
        if (this.getSelectedComponent() != this.attributesPanel && embAttrs.length > 0) {
            this.setSelectedComponent(this.attributesPanel);
            this.attributesPanel.setVisible(true);
        }
        this.attributesPanel.selectAttributes(embAttrs);
    }
}

