/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.util.CayenneMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelerUtil {
    public static String getObjectName(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CayenneMapEntry) {
            return ((CayenneMapEntry)object).getName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return (String)PropertyUtils.getProperty(object, "name");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageIcon buildIcon(String path) {
        ClassLoader cl = ModelerUtil.class.getClassLoader();
        URL url = cl.getResource("org/apache/cayenne/modeler/images/" + path);
        return new ImageIcon(url);
    }

    public static Collection<String> getDbAttributeNames(ProjectController mediator, DbEntity entity) {
        Set<String> keys = entity.getAttributeMap().keySet();
        ArrayList<String> list = new ArrayList<String>(keys.size() + 1);
        list.add("");
        list.addAll(keys);
        return list;
    }

    public static String[] getRegisteredTypeNames() {
        HashSet<String> nonPrimitives = new HashSet<String>();
        nonPrimitives.add(String.class.getName());
        nonPrimitives.add(BigDecimal.class.getName());
        nonPrimitives.add(BigInteger.class.getName());
        nonPrimitives.add(Boolean.class.getName());
        nonPrimitives.add(Byte.class.getName());
        nonPrimitives.add(Character.class.getName());
        nonPrimitives.add(Date.class.getName());
        nonPrimitives.add(java.util.Date.class.getName());
        nonPrimitives.add(Double.class.getName());
        nonPrimitives.add(Float.class.getName());
        nonPrimitives.add(Integer.class.getName());
        nonPrimitives.add(Long.class.getName());
        nonPrimitives.add(Short.class.getName());
        nonPrimitives.add(Time.class.getName());
        nonPrimitives.add(Timestamp.class.getName());
        nonPrimitives.add(Date.class.getName());
        nonPrimitives.add(GregorianCalendar.class.getName());
        nonPrimitives.add(Calendar.class.getName());
        nonPrimitives.add(UUID.class.getName());
        nonPrimitives.add(Serializable.class.getName());
        nonPrimitives.add("java.lang.Character[]");
        nonPrimitives.add("java.lang.Byte[]");
        Object[] nonPrimitivesNames = new String[nonPrimitives.size()];
        nonPrimitives.toArray(nonPrimitivesNames);
        Arrays.sort(nonPrimitivesNames);
        String[] primitivesNames = new String[]{"boolean", "byte", "byte[]", "char", "char[]", "double", "float", "int", "long", "short"};
        String[] finalList = new String[primitivesNames.length + nonPrimitivesNames.length + 1];
        finalList[0] = "";
        System.arraycopy(primitivesNames, 0, finalList, 1, primitivesNames.length);
        System.arraycopy(nonPrimitivesNames, 0, finalList, primitivesNames.length + 1, nonPrimitivesNames.length);
        return finalList;
    }

    public static DataNodeDescriptor getNodeLinkedToMap(DataChannelDescriptor domain, DataMap map) {
        Collection<DataNodeDescriptor> nodes = domain.getNodeDescriptors();
        for (DataNodeDescriptor node : nodes) {
            if (!node.getDataMapNames().contains(map.getName())) continue;
            return node;
        }
        return null;
    }

    public static void updateActions(int numSelected, Class<? extends Action> ... actions) {
        ActionManager actionManager = Application.getInstance().getActionManager();
        for (Class<? extends Action> actionType : actions) {
            Action action = actionManager.getAction(actionType);
            if (!(action instanceof MultipleObjectsAction)) continue;
            MultipleObjectsAction multiObjectAction = (MultipleObjectsAction)action;
            multiObjectAction.setEnabled(numSelected > 0);
            ((CayenneAction)((Object)multiObjectAction)).setName(multiObjectAction.getActionName(numSelected > 1));
        }
    }

    public static String getProperty(String key) {
        ResourceBundle properties = ResourceBundle.getBundle("org.apache.cayenne.modeler.cayennemodeler-strings");
        return properties == null ? "" : properties.getString(key);
    }

    public static void centerWindow(Window parent, Window child) {
        Dimension parentSize = parent.getSize();
        Dimension childSize = child.getSize();
        Point parentLocation = new Point(0, 0);
        if (parent.isShowing()) {
            parentLocation = parent.getLocationOnScreen();
        }
        int x = parentLocation.x + parentSize.width / 2 - childSize.width / 2;
        int y = parentLocation.y + parentSize.height / 2 - childSize.height / 2;
        child.setLocation(x, y);
    }
}

