/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.combo;

import java.lang.reflect.Method;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.combo.EditorTextField;

public class CustomTypeComboBoxEditor
extends BasicComboBoxEditor {
    protected Object localOldValue;
    protected final JComboBox combo;
    protected final boolean allowsUserValues;

    public CustomTypeComboBoxEditor(JComboBox combo, boolean allowsUserValues) {
        this.editor = new EditorTextField(combo);
        this.combo = combo;
        this.allowsUserValues = allowsUserValues;
    }

    public void setItem(Object anObject) {
        this.localOldValue = anObject;
        super.setItem(anObject == null ? null : CellRenderers.asString(anObject));
    }

    public Object getItem() {
        Object newValue = this.editor.getText();
        if (this.localOldValue != null && !(this.localOldValue instanceof String)) {
            if (newValue.equals(this.localOldValue.toString())) {
                return this.localOldValue;
            }
            Class<?> cls = this.localOldValue.getClass();
            try {
                newValue = this.convert((String)newValue, cls);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.allowsUserValues && newValue != null) {
            boolean contains = false;
            for (int i = 0; i < this.combo.getItemCount(); ++i) {
                if (!newValue.equals(this.combo.getItemAt(i))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                return null;
            }
        }
        return newValue;
    }

    protected Object convert(String value, Class classTo) {
        if (classTo == String.class) {
            return value;
        }
        try {
            Method method = classTo.getMethod("valueOf", String.class);
            return method.invoke(null, value);
        }
        catch (Exception method) {
            ComboBoxModel model = this.combo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!value.equals(CellRenderers.asString(model.getElementAt(i)))) continue;
                return model.getElementAt(i);
            }
            return null;
        }
    }
}

