/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.project.upgrade.UpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseUpgradeHandler
implements UpgradeHandler {
    static final String UNKNOWN_VERSION = "0";
    protected Resource projectSource;
    protected UpgradeMetaData metaData;

    public BaseUpgradeHandler(Resource projectSource) {
        if (projectSource == null) {
            throw new NullPointerException("Null project source");
        }
        this.projectSource = projectSource;
    }

    public Resource getProjectSource() {
        return this.projectSource;
    }

    public UpgradeMetaData getUpgradeMetaData() {
        if (this.metaData == null) {
            this.metaData = this.loadMetaData();
        }
        return this.metaData;
    }

    public Resource performUpgrade() throws ConfigurationException {
        UpgradeMetaData metaData = this.getUpgradeMetaData();
        switch (metaData.getUpgradeType()) {
            case DOWNGRADE_NEEDED: {
                throw new ConfigurationException("Downgrade can not be performed", new Object[0]);
            }
            case INTERMEDIATE_UPGRADE_NEEDED: {
                throw new ConfigurationException("Upgrade can not be performed - intermediate version upgrade needed", new Object[0]);
            }
            case UPGRADE_NEEDED: {
                return this.doPerformUpgrade();
            }
        }
        return this.getProjectSource();
    }

    protected abstract Resource doPerformUpgrade() throws ConfigurationException;

    protected abstract UpgradeMetaData loadMetaData();

    protected String loadProjectVersion() {
        RootTagHandler rootHandler = new RootTagHandler();
        URL url = this.projectSource.getURL();
        InputStream in = null;
        try {
            in = url.openStream();
            XMLReader parser = Util.createXmlReader();
            parser.setContentHandler(rootHandler);
            parser.setErrorHandler(rootHandler);
            parser.parse(new InputSource(in));
        }
        catch (SAXException parser) {
        }
        catch (Exception e) {
            throw new ConfigurationException("Error reading configuration from %s", (Throwable)e, url);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return rootHandler.projectVersion != null ? rootHandler.projectVersion : UNKNOWN_VERSION;
    }

    protected int compareVersions(String v1, String v2) {
        double v2Double;
        if (v1.equals(v2)) {
            return 0;
        }
        double v1Double = this.decodeVersion(v1);
        return v1Double < (v2Double = this.decodeVersion(v2)) ? -1 : 1;
    }

    protected double decodeVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return 0.0;
        }
        StringBuilder buffer = new StringBuilder(version.length());
        boolean dotProcessed = false;
        for (int i = 0; i < version.length(); ++i) {
            char nextChar = version.charAt(i);
            if (nextChar == '.' && !dotProcessed) {
                dotProcessed = true;
                buffer.append('.');
                continue;
            }
            if (!Character.isDigit(nextChar)) continue;
            buffer.append(nextChar);
        }
        return Double.parseDouble(buffer.toString());
    }

    class RootTagHandler
    extends DefaultHandler {
        private String projectVersion;

        RootTagHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.projectVersion = attributes.getValue("", "project-version");
            throw new SAXException("finished");
        }
    }
}

