/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.wocompat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.wocompat.EOObjEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOQuery
extends SelectQuery {
    protected Map<String, ?> plistMap;
    protected Map bindings;

    public EOQuery(ObjEntity root, Map<String, ?> plistMap) {
        super(root);
        this.plistMap = plistMap;
        this.initFromPlist(plistMap);
    }

    protected void initFromPlist(Map<String, ?> plistMap) {
        List prefetches;
        Map qualifierMap;
        List orderings;
        this.setDistinct("YES".equalsIgnoreCase((String)plistMap.get("usesDistinct")));
        Object fetchLimit = plistMap.get("fetchLimit");
        if (fetchLimit != null) {
            try {
                if (fetchLimit instanceof Number) {
                    this.setFetchLimit(((Number)fetchLimit).intValue());
                } else {
                    this.setFetchLimit(Integer.parseInt(fetchLimit.toString()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((orderings = (List)plistMap.get("sortOrderings")) != null && !orderings.isEmpty()) {
            for (Map ordering : orderings) {
                boolean asc;
                boolean bl = asc = !"compareDescending:".equals(ordering.get("selectorName"));
                String key = (String)ordering.get("key");
                if (key == null) continue;
                this.addOrdering(key, asc ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            }
        }
        if ((qualifierMap = (Map)plistMap.get("qualifier")) != null && !qualifierMap.isEmpty()) {
            this.setQualifier(this.makeQualifier(qualifierMap));
        }
        if ((prefetches = (List)plistMap.get("prefetchingRelationshipKeyPaths")) != null && !prefetches.isEmpty()) {
            Iterator it = prefetches.iterator();
            while (it.hasNext()) {
                this.addPrefetch((String)it.next());
            }
        }
        if (plistMap.containsKey("rawRowKeyPaths")) {
            this.setFetchingDataRows(true);
        }
    }

    public String getEOName() {
        if (this.root instanceof EOObjEntity) {
            return ((EOObjEntity)this.root).localQueryName(this.getName());
        }
        return this.getName();
    }

    public Collection getBindingNames() {
        if (this.bindings == null) {
            this.initBindings();
        }
        return this.bindings.keySet();
    }

    public String bindingClass(String name) {
        if (this.bindings == null) {
            this.initBindings();
        }
        return (String)this.bindings.get(name);
    }

    private synchronized void initBindings() {
        if (this.bindings != null) {
            return;
        }
        this.bindings = new HashMap();
        if (!(this.root instanceof Entity)) {
            return;
        }
        Map qualifier = (Map)this.plistMap.get("qualifier");
        this.initBindings(this.bindings, (Entity)this.root, qualifier);
    }

    private void initBindings(Map bindings, Entity entity, Map qualifier) {
        if (qualifier == null) {
            return;
        }
        if ("EOKeyValueQualifier".equals(qualifier.get("class"))) {
            String key = (String)qualifier.get("key");
            if (key == null) {
                return;
            }
            Object value = qualifier.get("value");
            if (!(value instanceof Map)) {
                return;
            }
            Map valueMap = (Map)value;
            if (!"EOQualifierVariable".equals(valueMap.get("class")) || !valueMap.containsKey("_key")) {
                return;
            }
            String name = (String)valueMap.get("_key");
            String className = null;
            try {
                ObjEntity target;
                Object lastObject = new ASTObjPath(key).evaluate(entity);
                if (lastObject instanceof ObjAttribute) {
                    className = ((ObjAttribute)lastObject).getType();
                } else if (lastObject instanceof ObjRelationship && (target = (ObjEntity)((ObjRelationship)lastObject).getTargetEntity()) != null) {
                    className = target.getClassName();
                }
            }
            catch (ExpressionException ex) {
                className = "java.lang.Object";
            }
            if (className == null) {
                className = "java.lang.Object";
            }
            bindings.put(name, className);
            return;
        }
        List children = (List)qualifier.get("qualifiers");
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.initBindings(bindings, entity, (Map)it.next());
            }
        }
    }

    public synchronized Expression makeQualifier(Map<String, ?> qualifierMap) {
        if (qualifierMap == null) {
            return null;
        }
        return EOFetchSpecificationParser.makeQualifier((EOObjEntity)this.getRoot(), qualifierMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EOFetchSpecificationParser {
        static final String IS_EQUAL_TO = "isEqualTo";
        static final String IS_NOT_EQUAL_TO = "isNotEqualTo";
        static final String IS_LIKE = "isLike";
        static final String CASE_INSENSITIVE_LIKE = "isCaseInsensitiveLike";
        static final String IS_LESS_THAN = "isLessThan";
        static final String IS_LESS_THAN_OR_EQUAL_TO = "isLessThanOrEqualTo";
        static final String IS_GREATER_THAN = "isGreaterThan";
        static final String IS_GREATER_THAN_OR_EQUAL_TO = "isGreaterThanOrEqualTo";
        private static final String OBJ_C = ":";
        private static HashMap<String, Integer> selectorToExpressionBridge;

        EOFetchSpecificationParser() {
        }

        static synchronized HashMap<String, Integer> selectorToExpressionBridge() {
            if (null == selectorToExpressionBridge) {
                selectorToExpressionBridge = new HashMap();
                selectorToExpressionBridge.put(IS_EQUAL_TO, 3);
                selectorToExpressionBridge.put("isEqualTo:", 3);
                selectorToExpressionBridge.put(IS_NOT_EQUAL_TO, 4);
                selectorToExpressionBridge.put("isNotEqualTo:", 4);
                selectorToExpressionBridge.put(IS_LIKE, 11);
                selectorToExpressionBridge.put("isLike:", 11);
                selectorToExpressionBridge.put(CASE_INSENSITIVE_LIKE, 12);
                selectorToExpressionBridge.put("isCaseInsensitiveLike:", 12);
                selectorToExpressionBridge.put(IS_LESS_THAN, 5);
                selectorToExpressionBridge.put("isLessThan:", 5);
                selectorToExpressionBridge.put(IS_LESS_THAN_OR_EQUAL_TO, 7);
                selectorToExpressionBridge.put("isLessThanOrEqualTo:", 7);
                selectorToExpressionBridge.put(IS_GREATER_THAN, 6);
                selectorToExpressionBridge.put("isGreaterThan:", 6);
                selectorToExpressionBridge.put(IS_GREATER_THAN_OR_EQUAL_TO, 8);
                selectorToExpressionBridge.put("isGreaterThanOrEqualTo:", 8);
            }
            return selectorToExpressionBridge;
        }

        static boolean isAggregate(Map qualifier) {
            boolean result = true;
            String theClass = (String)qualifier.get("class");
            if (theClass == null) {
                return false;
            }
            if (theClass.equalsIgnoreCase("EOKeyValueQualifier") || theClass.equalsIgnoreCase("EOKeyComparisonQualifier")) {
                result = false;
            }
            return result;
        }

        static int expressionTypeForQualifier(Map qualifierMap) {
            String selector = (String)qualifierMap.get("selectorName");
            return EOFetchSpecificationParser.expressionTypeForSelector(selector);
        }

        static int expressionTypeForSelector(String selector) {
            Integer expType = EOFetchSpecificationParser.selectorToExpressionBridge().get(selector);
            return expType != null ? expType : -1;
        }

        static int aggregateExpressionClassForQualifier(Map qualifierMap) {
            String qualifierClass = (String)qualifierMap.get("class");
            if (qualifierClass != null) {
                if (qualifierClass.equalsIgnoreCase("EOAndQualifier")) {
                    return 0;
                }
                if (qualifierClass.equalsIgnoreCase("EOOrQualifier")) {
                    return 1;
                }
                if (qualifierClass.equalsIgnoreCase("EONotQualifier")) {
                    return 2;
                }
            }
            return -1;
        }

        static Expression makeQualifier(EOObjEntity entity, Map qualifierMap) {
            if (EOFetchSpecificationParser.isAggregate(qualifierMap)) {
                int aggregateClass = EOFetchSpecificationParser.aggregateExpressionClassForQualifier(qualifierMap);
                if (aggregateClass == 2) {
                    Map child = (Map)qualifierMap.get("qualifier");
                    Expression childExp = EOFetchSpecificationParser.makeQualifier(entity, child);
                    return childExp.notExp();
                }
                List children = (List)qualifierMap.get("qualifiers");
                if (children != null) {
                    ArrayList<Expression> childExpressions = new ArrayList<Expression>();
                    Iterator it = children.iterator();
                    while (it.hasNext()) {
                        Expression childExp = EOFetchSpecificationParser.makeQualifier(entity, (Map)it.next());
                        childExpressions.add(childExp);
                    }
                    return ExpressionFactory.joinExp(aggregateClass, childExpressions);
                }
            }
            String qualifierClass = (String)qualifierMap.get("class");
            String key = null;
            Object comparisonValue = null;
            if ("EOKeyComparisonQualifier".equals(qualifierClass)) {
                key = (String)qualifierMap.get("leftValue");
                comparisonValue = qualifierMap.get("rightValue");
                return null;
            }
            if ("EOKeyValueQualifier".equals(qualifierClass)) {
                key = (String)qualifierMap.get("key");
                Object value = qualifierMap.get("value");
                if (value instanceof Map) {
                    Map valueMap = (Map)value;
                    String objClass = (String)valueMap.get("class");
                    if ("EOQualifierVariable".equals(objClass) && valueMap.containsKey("_key")) {
                        String paramName = (String)valueMap.get("_key");
                        comparisonValue = new ExpressionParameter(paramName);
                    } else {
                        Object queryVal = valueMap.get("value");
                        comparisonValue = "NSNumber".equals(objClass) ? (Object)queryVal : ("EONull".equals(objClass) ? null : queryVal);
                    }
                } else if (value instanceof String) {
                    comparisonValue = value;
                }
            }
            Expression keyExp = Expression.fromString(key);
            try {
                entity.lastPathComponent(keyExp, Collections.emptyMap());
            }
            catch (ExpressionException e) {
                keyExp = entity.translateToDbPath(keyExp);
            }
            try {
                Expression exp = ExpressionFactory.expressionOfType(EOFetchSpecificationParser.expressionTypeForQualifier(qualifierMap));
                exp.setOperand(0, keyExp);
                exp.setOperand(1, comparisonValue);
                return exp;
            }
            catch (ExpressionException e) {
                return null;
            }
        }
    }
}

