/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/
package org.apache.cayenne.commitlog;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.commitlog.db.AuditLog;
import org.apache.cayenne.commitlog.db.Auditable2;
import org.apache.cayenne.commitlog.model.ChangeMap;
import org.apache.cayenne.commitlog.model.ObjectChange;
import org.apache.cayenne.commitlog.unit.AuditableServerCase;
import org.apache.cayenne.configuration.server.ServerRuntimeBuilder;
import org.apache.cayenne.tx.BaseTransaction;
import org.junit.Before;
import org.junit.Test;

import java.sql.SQLException;
import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

public class CommitLogFilter_TxIT extends AuditableServerCase {

	protected ObjectContext context;
	protected CommitLogListener listener;

	@Override
	protected ServerRuntimeBuilder configureCayenne() {
		this.listener = new CommitLogListener() {

			@Override
			public void onPostCommit(ObjectContext originatingContext, ChangeMap changes) {

				// assert we are inside transaction
				assertNotNull(BaseTransaction.getThreadTransaction());

				for (ObjectChange c : changes.getUniqueChanges()) {
					AuditLog log = runtime.newContext().newObject(AuditLog.class);
					log.setLog("DONE: " + c.getPostCommitId());
					log.getObjectContext().commitChanges();
				}
			}
		};
		return super.configureCayenne().addModule(
				CommitLogModule.extend().commitLogAnnotationEntitiesOnly().addListener(listener).module());
	}

	@Before
	public void before() {
		this.context = runtime.newContext();
	}

	@Test
	public void testCommitLog() throws SQLException {
		Auditable2 a1 = context.newObject(Auditable2.class);
		a1.setCharProperty1("yy");
		a1.setCharProperty2("zz");

		Auditable2 a2 = context.newObject(Auditable2.class);
		a2.setCharProperty1("yy");
		a2.setCharProperty2("zz");
		context.commitChanges();

		List<Object[]> logs = auditLog.selectAll();
		assertEquals(2, logs.size());
	}

}
