package org.apache.cayenne.testdo.testmap.auto;

import java.math.BigDecimal;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.testdo.testmap.ROArtist;

/**
 * Class _CompoundPaintingLongNames was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _CompoundPaintingLongNames extends CayenneDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String PAINTING_ID_PK_COLUMN = "PAINTING_ID";

    public static final Property<String> ARTIST_LONG_NAME = Property.create("artistLongName", String.class);
    public static final Property<BigDecimal> ESTIMATED_PRICE = Property.create("estimatedPrice", BigDecimal.class);
    public static final Property<String> GALLERY_LONG_NAME = Property.create("galleryLongName", String.class);
    public static final Property<String> PAINTING_DESCRIPTION = Property.create("paintingDescription", String.class);
    public static final Property<String> PAINTING_TITLE = Property.create("paintingTitle", String.class);
    public static final Property<String> TEXT_LONG_REVIEW = Property.create("textLongReview", String.class);
    public static final Property<Artist> TO_ARTIST = Property.create("toArtist", Artist.class);
    public static final Property<ROArtist> TO_ARTIST1 = Property.create("toArtist1", ROArtist.class);
    public static final Property<Gallery> TO_GALLERY = Property.create("toGallery", Gallery.class);
    public static final Property<PaintingInfo> TO_PAINTING_INFO = Property.create("toPaintingInfo", PaintingInfo.class);

    public void setArtistLongName(String artistLongName) {
        writeProperty("artistLongName", artistLongName);
    }
    public String getArtistLongName() {
        return (String)readProperty("artistLongName");
    }

    public void setEstimatedPrice(BigDecimal estimatedPrice) {
        writeProperty("estimatedPrice", estimatedPrice);
    }
    public BigDecimal getEstimatedPrice() {
        return (BigDecimal)readProperty("estimatedPrice");
    }

    public void setGalleryLongName(String galleryLongName) {
        writeProperty("galleryLongName", galleryLongName);
    }
    public String getGalleryLongName() {
        return (String)readProperty("galleryLongName");
    }

    public void setPaintingDescription(String paintingDescription) {
        writeProperty("paintingDescription", paintingDescription);
    }
    public String getPaintingDescription() {
        return (String)readProperty("paintingDescription");
    }

    public void setPaintingTitle(String paintingTitle) {
        writeProperty("paintingTitle", paintingTitle);
    }
    public String getPaintingTitle() {
        return (String)readProperty("paintingTitle");
    }

    public void setTextLongReview(String textLongReview) {
        writeProperty("textLongReview", textLongReview);
    }
    public String getTextLongReview() {
        return (String)readProperty("textLongReview");
    }

    public void setToArtist(Artist toArtist) {
        setToOneTarget("toArtist", toArtist, true);
    }

    public Artist getToArtist() {
        return (Artist)readProperty("toArtist");
    }


    public void setToArtist1(ROArtist toArtist1) {
        setToOneTarget("toArtist1", toArtist1, true);
    }

    public ROArtist getToArtist1() {
        return (ROArtist)readProperty("toArtist1");
    }


    public void setToGallery(Gallery toGallery) {
        setToOneTarget("toGallery", toGallery, true);
    }

    public Gallery getToGallery() {
        return (Gallery)readProperty("toGallery");
    }


    public void setToPaintingInfo(PaintingInfo toPaintingInfo) {
        setToOneTarget("toPaintingInfo", toPaintingInfo, true);
    }

    public PaintingInfo getToPaintingInfo() {
        return (PaintingInfo)readProperty("toPaintingInfo");
    }


}
