/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ImportDataMapAction
extends CayenneAction {
    private static Logger logObj = LoggerFactory.getLogger(ImportDataMapAction.class);
    private ConfigurationNameMapper nameMapper;

    public ImportDataMapAction(Application application, ConfigurationNameMapper nameMapper) {
        super(ImportDataMapAction.getActionName(), application);
        this.nameMapper = nameMapper;
    }

    public static String getActionName() {
        return "Import DataMap";
    }

    @Override
    public void performAction(ActionEvent e) {
        this.importDataMap();
    }

    protected void importDataMap() {
        File dataMapFile = this.selectDataMap(Application.getFrame());
        if (dataMapFile == null) {
            return;
        }
        try {
            DataMap newMap;
            URL url = dataMapFile.toURI().toURL();
            try (InputStream in = url.openStream();){
                InputSource inSrc = new InputSource(in);
                inSrc.setSystemId(dataMapFile.getAbsolutePath());
                newMap = new MapLoader().loadDataMap(inSrc);
            }
            ConfigurationNode root = this.getProjectController().getProject().getRootNode();
            newMap.setName(NameBuilder.builder(newMap, root).baseName(newMap.getName()).name());
            Resource baseResource = ((DataChannelDescriptor)root).getConfigurationSource();
            if (baseResource != null) {
                Resource dataMapResource = baseResource.getRelativeResource(this.nameMapper.configurationLocation(newMap));
                newMap.setConfigurationSource(dataMapResource);
            }
            this.getProjectController().addDataMap(this, newMap);
        }
        catch (Exception ex) {
            logObj.info("Error importing DataMap.", ex);
            JOptionPane.showMessageDialog(Application.getFrame(), "Error reading DataMap: " + ex.getMessage(), "Can't Open DataMap", 0);
        }
    }

    protected File selectDataMap(Frame f) {
        FSPath lastDir = this.getApplication().getFrameController().getLastDirectory();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        lastDir.updateChooser(chooser);
        chooser.addChoosableFileFilter(FileFilters.getDataMapFilter());
        int status = chooser.showDialog(f, "Select DataMap");
        if (status == 0) {
            File file = chooser.getSelectedFile();
            lastDir.updateFromChooser(chooser);
            return file;
        }
        return null;
    }
}

