/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.util.Invocation;

class DispatchQueue {
    private final ConcurrentMap<Invocation, Object> subjectInvocations = new ConcurrentHashMap<Invocation, Object>();
    private final Map<Object, ConcurrentMap<Invocation, Object>> invocationsBySender = new WeakHashMap<Object, ConcurrentMap<Invocation, Object>>();

    DispatchQueue() {
    }

    void dispatchEvent(DefaultEventManager.Dispatch dispatch) {
        this.dispatchEvent(this.subjectInvocations.keySet(), dispatch);
        Object sender = dispatch.getSender();
        ConcurrentMap<Invocation, Object> senderInvocations = this.invocationsForSender(sender, false);
        if (senderInvocations != null) {
            this.dispatchEvent(senderInvocations.keySet(), dispatch);
        }
    }

    void addInvocation(Invocation invocation, Object sender) {
        ConcurrentMap<Invocation, Object> invocations = sender == null ? this.subjectInvocations : this.invocationsForSender(sender, true);
        Iterator it = invocations.keySet().iterator();
        while (it.hasNext()) {
            Invocation i = (Invocation)it.next();
            if (i.getTarget() != null) continue;
            it.remove();
        }
        invocations.putIfAbsent(invocation, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeInvocations(Object listener, Object sender) {
        if (sender != null) {
            return this.removeInvocations(this.invocationsForSender(sender, false), listener);
        }
        boolean didRemove = this.removeInvocations(this.subjectInvocations, listener);
        Map<Object, ConcurrentMap<Invocation, Object>> map = this.invocationsBySender;
        synchronized (map) {
            for (ConcurrentMap<Invocation, Object> senderInvocations : this.invocationsBySender.values()) {
                didRemove = this.removeInvocations(senderInvocations, listener) || didRemove;
            }
        }
        return didRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<Invocation, Object> invocationsForSender(Object sender, boolean create) {
        Map<Object, ConcurrentMap<Invocation, Object>> map = this.invocationsBySender;
        synchronized (map) {
            ConcurrentMap<Invocation, Object> senderInvocations = this.invocationsBySender.get(sender);
            if (create && senderInvocations == null) {
                senderInvocations = new ConcurrentHashMap<Invocation, Object>();
                this.invocationsBySender.put(sender, senderInvocations);
            }
            return senderInvocations;
        }
    }

    private boolean removeInvocations(ConcurrentMap<Invocation, Object> invocations, Object listener) {
        if (invocations == null || invocations.isEmpty()) {
            return false;
        }
        boolean didRemove = false;
        Iterator invocationsIt = invocations.keySet().iterator();
        while (invocationsIt.hasNext()) {
            Invocation invocation = (Invocation)invocationsIt.next();
            if (invocation.getTarget() != listener) continue;
            invocationsIt.remove();
            didRemove = true;
        }
        return didRemove;
    }

    private void dispatchEvent(Collection<Invocation> invocations, DefaultEventManager.Dispatch dispatch) {
        Iterator<Invocation> it = invocations.iterator();
        while (it.hasNext()) {
            Invocation invocation = it.next();
            if (dispatch.fire(invocation)) continue;
            it.remove();
        }
    }
}

