/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.dialog.objentity.DbRelationshipTargetModel;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.scopemvc.view.swing.SAction;
import org.scopemvc.view.swing.SButton;
import org.scopemvc.view.swing.SCheckBox;
import org.scopemvc.view.swing.SComboBox;
import org.scopemvc.view.swing.SListCellRenderer;
import org.scopemvc.view.swing.SPanel;

public class DbRelationshipTargetDialog
extends SPanel {
    JRadioButton source1Button;
    JRadioButton source2Button;

    public DbRelationshipTargetDialog(DbEntity source1, DbEntity source2) {
        this.init(source1, source2);
    }

    protected void init(DbEntity source1, DbEntity source2) {
        SButton saveButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.continue.button"));
        saveButton.setEnabled(true);
        SButton cancelButton = new SButton(new SAction("cayenne.modeler.mapObjRelationship.cancel.button"));
        cancelButton.setEnabled(true);
        SComboBox targetCombo = new SComboBox();
        targetCombo.setSelector(DbRelationshipTargetModel.TARGETS_SELECTOR);
        targetCombo.setSelectionSelector(DbRelationshipTargetModel.TARGET_SELECTOR);
        SListCellRenderer renderer = (SListCellRenderer)targetCombo.getRenderer();
        renderer.setTextSelector("name");
        this.source1Button = new JRadioButton();
        this.source2Button = new JRadioButton();
        this.source2Button.setEnabled(source2 != null);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.source1Button);
        bg.add(this.source2Button);
        SCheckBox toManyCheckBox = new SCheckBox();
        toManyCheckBox.setSelector(DbRelationshipTargetModel.TO_MANY_SELECTOR);
        this.setDisplayMode(1);
        this.setTitle("Create New DbRelationship");
        this.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("right:max(100dlu;pref), 3dlu, fill:min(150dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, top:p:grow"));
        builder.setDefaultDialogBorder();
        builder.addLabel("Source: " + source1.getName(), cc.xy(1, 1));
        builder.add((Component)this.source1Button, cc.xy(3, 1));
        builder.addLabel("Source: " + (source2 == null ? "" : source2.getName()), cc.xy(1, 3));
        builder.add((Component)this.source2Button, cc.xy(3, 3));
        builder.addLabel("Target:", cc.xy(1, 5));
        builder.add((Component)targetCombo, cc.xywh(3, 5, 1, 1));
        builder.addLabel("To Many:", cc.xy(1, 7));
        builder.add((Component)toManyCheckBox, cc.xywh(3, 7, 1, 1));
        this.add((Component)builder.getPanel(), "Center");
        this.add((Component)PanelFactory.createButtonPanel(new JButton[]{saveButton, cancelButton}), "South");
    }

    JRadioButton getSource1Button() {
        return this.source1Button;
    }

    JRadioButton getSource2Button() {
        return this.source2Button;
    }
}

