/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.datanode.DataSourceEditor;
import org.apache.cayenne.modeler.editor.datanode.JDBCDataSourceView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.project.ProjectDataSource;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.ObjectBinding;

public class JDBCDataSourceEditor
extends DataSourceEditor {
    protected JDBCDataSourceView view;

    public JDBCDataSourceEditor(ProjectController parent, BindingDelegate nodeChangeProcessor) {
        super(parent, nodeChangeProcessor);
    }

    public Component getView() {
        return this.view;
    }

    protected void prepareBindings(BindingBuilder builder) {
        this.view = new JDBCDataSourceView();
        this.fieldAdapters = new ObjectBinding[6];
        this.fieldAdapters[0] = builder.bindToTextField(this.view.getUserName(), "node.dataSource.dataSourceInfo.userName");
        this.fieldAdapters[1] = builder.bindToTextField(this.view.getPassword(), "node.dataSource.dataSourceInfo.password");
        this.fieldAdapters[2] = builder.bindToTextField(this.view.getUrl(), "node.dataSource.dataSourceInfo.dataSourceUrl");
        this.fieldAdapters[3] = builder.bindToTextField(this.view.getDriver(), "node.dataSource.dataSourceInfo.jdbcDriver");
        this.fieldAdapters[4] = builder.bindToTextField(this.view.getMaxConnections(), "node.dataSource.dataSourceInfo.maxConnections");
        this.fieldAdapters[5] = builder.bindToTextField(this.view.getMinConnections(), "node.dataSource.dataSourceInfo.minConnections");
        builder.bindToAction(this.view.getSyncWithLocal(), "syncDataSourceAction()");
    }

    public void syncDataSourceAction() {
        CayenneModelerController mainController = this.getApplication().getFrameController();
        if (this.getNode() == null || this.getNode().getDataSource() == null) {
            return;
        }
        ProjectDataSource projectDS = (ProjectDataSource)this.getNode().getDataSource();
        ProjectController parent = (ProjectController)this.getParent();
        String key = parent.getDataNodePreferences().getLocalDataSource();
        if (key == null) {
            mainController.updateStatus("No Local DataSource selected for node...");
            return;
        }
        DBConnectionInfo dataSource = (DBConnectionInfo)parent.getApplicationPreferenceDomain().getDetail(key, DBConnectionInfo.class, false);
        if (dataSource != null) {
            if (dataSource.copyTo(projectDS.getDataSourceInfo())) {
                this.refreshView();
                this.nodeChangeProcessor.modelUpdated(null, null, null);
                mainController.updateStatus(null);
            } else {
                mainController.updateStatus("DataNode is up to date...");
            }
        } else {
            mainController.updateStatus("Invalid Local DataSource selected for node...");
        }
    }
}

