/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.reflect.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HierarchicalObjectResolverNode
extends ObjectResolver {
    private PrefetchProcessorNode node;

    HierarchicalObjectResolverNode(PrefetchProcessorNode node, DataContext context, ClassDescriptor descriptor, boolean refresh) {
        super(context, descriptor, refresh);
        this.node = node;
    }

    @Override
    List<Persistent> objectsFromDataRows(List<? extends DataRow> rows) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList<Persistent>(1);
        }
        ArrayList<Persistent> results = new ArrayList<Persistent>(rows.size());
        HashMap<ObjectId, Persistent> seen = new HashMap<ObjectId, Persistent>();
        for (DataRow dataRow : rows) {
            ClassDescriptor classDescriptor;
            ObjectId anId = this.createObjectId(dataRow, (classDescriptor = this.descriptorResolutionStrategy.descriptorForRow(dataRow)).getEntity(), null);
            Persistent object = (Persistent)seen.get(anId);
            if (object == null) {
                object = this.objectFromDataRow(dataRow, anId, classDescriptor);
                if (object == null) {
                    throw new CayenneRuntimeException("Can't build Object from row: " + dataRow);
                }
                seen.put(anId, object);
            }
            results.add(object);
            this.node.getParentAttachmentStrategy().linkToParent(dataRow, object);
        }
        this.cache.snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }
}

