/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.dialog.FindDialogView;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.query.Query;

public class FindDialog
extends CayenneController {
    private FindDialogView view;
    private List paths;
    private static Font font;
    private static Font fontSelected;

    public static Font getFont() {
        return font;
    }

    public static Font getFontSelected() {
        return fontSelected;
    }

    public FindDialog(CayenneController parent, List paths) {
        super(parent);
        this.paths = paths;
        HashMap<Integer, String> objEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> dbEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> attrNames = new HashMap<Integer, String>();
        HashMap<Integer, String> relatNames = new HashMap<Integer, String>();
        HashMap<Integer, String> queryNames = new HashMap<Integer, String>();
        HashMap<Integer, String> embeddableNames = new HashMap<Integer, String>();
        HashMap<Integer, String> embeddableAttributeNames = new HashMap<Integer, String>();
        Iterator it = paths.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object parentObject;
            Object[] path = (Object[])it.next();
            if (path[path.length - 1] instanceof ObjEntity) {
                objEntityNames.put(new Integer(index++), ((ObjEntity)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof DbEntity) {
                dbEntityNames.put(new Integer(index++), ((DbEntity)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof Query) {
                queryNames.put(new Integer(index++), ((Query)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof Embeddable) {
                String name = ((Embeddable)path[path.length - 1]).getClassName();
                embeddableNames.put(new Integer(index++), name);
            }
            if (path[path.length - 1] instanceof EmbeddableAttribute) {
                parentObject = ((EmbeddableAttribute)path[path.length - 1]).getEmbeddable();
                String parName = this.getParentName(path, parentObject);
                embeddableAttributeNames.put(new Integer(index++), parName + "." + ((EmbeddableAttribute)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof Attribute) {
                parentObject = ((Attribute)path[path.length - 1]).getParent();
                attrNames.put(new Integer(index++), this.getParentName(path, parentObject) + "." + ((Attribute)path[path.length - 1]).getName());
            }
            if (!(path[path.length - 1] instanceof Relationship)) continue;
            parentObject = ((Relationship)path[path.length - 1]).getParent();
            String parentName = this.getParentName(path, parentObject);
            if (!parentObject.equals(path[path.length - 2])) {
                parentName = ((ObjEntity)path[path.length - 2]).getName();
            }
            relatNames.put(new Integer(index++), parentName + "." + ((Relationship)path[path.length - 1]).getName());
        }
        this.view = new FindDialogView(objEntityNames, dbEntityNames, attrNames, relatNames, queryNames, embeddableNames, embeddableAttributeNames);
        this.initBindings();
    }

    public void startupAction() {
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.view.setVisible(true);
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.view.dispose();
            }
        });
        font = this.view.getOkButton().getFont();
        fontSelected = new Font(font.getFamily(), 1, font.getSize() + 2);
        JTable table = this.view.getTable();
        table.setRowHeight(fontSelected.getSize() + 6);
        table.setRowMargin(0);
        table.addKeyListener(new JumpToResultsKeyListener());
        table.addMouseListener(new JumpToResultActionListener());
        table.getSelectionModel().setSelectionInterval(0, 0);
    }

    public static void jumpToResult(Object[] path) {
        Object[] o;
        DataMapDisplayEvent event;
        EditorView editor = ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
        if (path[path.length - 1] instanceof Entity) {
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(path, editor));
            event = new EntityDisplayEvent((Object)editor.getProjectTreeView(), (Entity)path[path.length - 1], (DataMap)path[path.length - 2], (DataDomain)path[path.length - 3]);
            ((EntityDisplayEvent)event).setMainTabFocus(true);
            if (path[path.length - 1] instanceof ObjEntity) {
                editor.getObjDetailView().currentObjEntityChanged((EntityDisplayEvent)event);
            }
            if (path[path.length - 1] instanceof DbEntity) {
                editor.getDbDetailView().currentDbEntityChanged((EntityDisplayEvent)event);
            }
        }
        if (path[path.length - 1] instanceof Query) {
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(path, editor));
            event = new QueryDisplayEvent((Object)editor.getProjectTreeView(), (Query)path[path.length - 1], (DataMap)path[path.length - 2], (DataDomain)path[path.length - 3]);
            editor.currentQueryChanged((QueryDisplayEvent)event);
        }
        if (path[path.length - 1] instanceof Embeddable) {
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(path, editor));
            event = new EmbeddableDisplayEvent((Object)editor.getProjectTreeView(), (Embeddable)path[path.length - 1], (DataMap)path[path.length - 2], (DataDomain)path[path.length - 3]);
            ((EmbeddableDisplayEvent)event).setMainTabFocus(true);
            editor.currentEmbeddableChanged((EmbeddableDisplayEvent)event);
        }
        if (path[path.length - 1] instanceof EmbeddableAttribute) {
            o = new Object[path.length - 1];
            for (int i = 0; i < path.length - 1; ++i) {
                o[i] = path[i];
            }
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            EmbeddableAttributeDisplayEvent event2 = new EmbeddableAttributeDisplayEvent((Object)editor.getProjectTreeView(), (Embeddable)path[path.length - 2], (EmbeddableAttribute)path[path.length - 1], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
            event2.setMainTabFocus(true);
            editor.getEmbeddableView().currentEmbeddableAttributeChanged(event2);
        }
        if (path[path.length - 1] instanceof Attribute || path[path.length - 1] instanceof Relationship) {
            o = new Object[path.length - 1];
            for (int i = 0; i < path.length - 1; ++i) {
                o[i] = path[i];
            }
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            if (path[path.length - 1] instanceof DbAttribute) {
                AttributeDisplayEvent event3 = new AttributeDisplayEvent((Object)editor.getProjectTreeView(), (Attribute)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                event3.setMainTabFocus(true);
                editor.getDbDetailView().currentDbAttributeChanged(event3);
            }
            if (path[path.length - 1] instanceof ObjAttribute) {
                AttributeDisplayEvent event4 = new AttributeDisplayEvent((Object)editor.getProjectTreeView(), (Attribute)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                event4.setMainTabFocus(true);
                editor.getObjDetailView().currentObjAttributeChanged(event4);
            }
            if (path[path.length - 1] instanceof DbRelationship) {
                RelationshipDisplayEvent event5 = new RelationshipDisplayEvent((Object)editor.getProjectTreeView(), (Relationship)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                event5.setMainTabFocus(true);
                editor.getDbDetailView().currentDbRelationshipChanged(event5);
            }
        }
        if (path[path.length - 1] instanceof ObjRelationship) {
            event = new RelationshipDisplayEvent((Object)editor.getProjectTreeView(), (Relationship)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
            ((EntityDisplayEvent)event).setMainTabFocus(true);
            editor.getObjDetailView().currentObjRelationshipChanged((RelationshipDisplayEvent)event);
        }
    }

    private static TreePath buildTreePath(Object[] path, EditorView editor) {
        Object[] mutableTreeNodes = new Object[path.length];
        mutableTreeNodes[0] = ((ProjectTreeModel)editor.getProjectTreeView().getModel()).getRootNode();
        for (int i = 1; i < path.length; ++i) {
            Object[] helper = new Object[i];
            int j = 0;
            while (j < i) {
                helper[j++] = path[j];
            }
            mutableTreeNodes[i] = ((ProjectTreeModel)editor.getProjectTreeView().getModel()).getNodeForObjectPath(helper);
        }
        return new TreePath(mutableTreeNodes);
    }

    private String getParentName(Object[] path, Object parentObject) {
        String nameParent = null;
        if (parentObject instanceof ObjEntity) {
            ObjEntity objEntity = (ObjEntity)parentObject;
            nameParent = objEntity.getName();
        }
        if (parentObject instanceof DbEntity) {
            DbEntity dbEntity = (DbEntity)parentObject;
            nameParent = dbEntity.getName();
        }
        if (parentObject instanceof Embeddable) {
            Embeddable embeddable = (Embeddable)parentObject;
            nameParent = embeddable.getClassName();
        }
        return nameParent;
    }

    private class JumpToResultsKeyListener
    implements KeyListener {
        private JumpToResultsKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                JTable table = (JTable)e.getSource();
                Integer selectedLine = table.getSelectionModel().getLeadSelectionIndex();
                JLabel label = (JLabel)table.getModel().getValueAt(selectedLine, 0);
                Integer index = (Integer)FindDialogView.getLabelAndObjectIndex().get(label);
                Object[] path = (Object[])FindDialog.this.paths.get(index);
                FindDialog.jumpToResult(path);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class JumpToResultActionListener
    implements MouseListener {
        private JumpToResultActionListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Integer selectedLine = table.getSelectionModel().getLeadSelectionIndex();
            JLabel label = (JLabel)table.getModel().getValueAt(selectedLine, 0);
            Integer index = (Integer)FindDialogView.getLabelAndObjectIndex().get(label);
            Object[] path = (Object[])FindDialog.this.paths.get(index);
            FindDialog.jumpToResult(path);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

