/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.locale.converters.DecimalLocaleConverter;

public class IntegerLocaleConverter
extends DecimalLocaleConverter<Integer> {
    public static Builder builder() {
        return new Builder();
    }

    private IntegerLocaleConverter(Integer defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    @Override
    protected Integer parse(Object value, String pattern) throws ParseException {
        Object parsed = super.parse(value, pattern);
        if (((Number)parsed).longValue() != (long)((Number)parsed).intValue()) {
            throw new ConversionException("Supplied number is not of type Integer: " + ((Number)parsed).longValue());
        }
        return ((Number)parsed).intValue();
    }

    public static class Builder
    extends DecimalLocaleConverter.Builder<Builder, Integer> {
        @Override
        public IntegerLocaleConverter get() {
            return new IntegerLocaleConverter((Integer)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

