/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextHelpAppendable;
import org.apache.commons.cli.help.TextStyle;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public final class TextHelpAppendableTest {
    private StringBuilder sb;
    private TextHelpAppendable underTest;

    @BeforeEach
    public void setUp() {
        this.sb = new StringBuilder();
        this.underTest = new TextHelpAppendable((Appendable)this.sb);
    }

    @Test
    void testAdjustTableFormat() {
        TableDefinition tableDefinition = TableDefinition.from((String)"Testing", Collections.singletonList(TextStyle.builder().setMaxWidth(3).get()), Collections.singletonList("header"), Collections.singletonList(Collections.singletonList("data")));
        TableDefinition actual = this.underTest.adjustTableFormat(tableDefinition);
        Assertions.assertEquals((int)"header".length(), (int)((TextStyle)actual.columnTextStyles().get(0)).getMaxWidth());
        Assertions.assertEquals((int)"header".length(), (int)((TextStyle)actual.columnTextStyles().get(0)).getMinWidth());
    }

    @Test
    void testAppend() throws IOException {
        int c = 62541;
        this.underTest.append('\uf44d');
        Assertions.assertEquals((int)1, (int)this.sb.length());
        Assertions.assertEquals((Object)String.valueOf('\uf44d'), (Object)this.sb.toString());
        this.sb.setLength(0);
        this.underTest.append((CharSequence)"Hello");
        Assertions.assertEquals((Object)"Hello", (Object)this.sb.toString());
    }

    @Test
    void testAppendHeader() throws IOException {
        String[] expected = new String[]{" Hello World", " ===========", ""};
        this.sb.setLength(0);
        this.underTest.appendHeader(1, (CharSequence)"Hello World");
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual, (String)"header 1 failed");
        this.sb.setLength(0);
        this.underTest.appendHeader(2, (CharSequence)"Hello World");
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        expected[1] = " %%%%%%%%%%%";
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual, (String)"header 2 failed");
        this.sb.setLength(0);
        this.underTest.appendHeader(3, (CharSequence)"Hello World");
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        expected[1] = " +++++++++++";
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual, (String)"header 3 failed");
        this.sb.setLength(0);
        this.underTest.appendHeader(4, (CharSequence)"Hello World");
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        expected[1] = " ___________";
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual, (String)"header 4 failed");
        this.sb.setLength(0);
        this.underTest.appendHeader(5, (CharSequence)"Hello World");
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual, (String)"header 5 failed");
        this.sb.setLength(0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.underTest.appendHeader(0, (CharSequence)"Hello World"));
        this.sb.setLength(0);
        this.underTest.appendHeader(5, (CharSequence)"");
        Assertions.assertEquals((int)0, (int)this.sb.length(), (String)"empty string test failed");
        this.sb.setLength(0);
        this.underTest.appendHeader(5, null);
        Assertions.assertEquals((int)0, (int)this.sb.length(), (String)"null test failed");
    }

    @Test
    void testAppendList() throws IOException {
        ArrayList<String> expected = new ArrayList<String>();
        String[] entries = new String[]{"one", "two", "three"};
        for (int i = 0; i < entries.length; ++i) {
            expected.add(String.format("  %s. %s", i + 1, entries[i]));
        }
        expected.add("");
        this.sb.setLength(0);
        this.underTest.appendList(true, Arrays.asList(entries));
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"ordered list failed");
        this.sb.setLength(0);
        expected.clear();
        for (String entry : entries) {
            expected.add(String.format("  * %s", entry));
        }
        expected.add("");
        this.underTest.appendList(false, Arrays.asList(entries));
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"unordered list failed");
        this.sb.setLength(0);
        expected.clear();
        this.underTest.appendList(false, Collections.emptyList());
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"empty list failed");
        this.sb.setLength(0);
        expected.clear();
        this.underTest.appendList(false, null);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"null list failed");
    }

    @Test
    void testAppendParagraph() throws IOException {
        String[] expected = new String[]{" Hello World", ""};
        this.sb.setLength(0);
        this.underTest.appendParagraph((CharSequence)"Hello World");
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual);
        this.sb.setLength(0);
        this.underTest.appendParagraph((CharSequence)"");
        Assertions.assertEquals((int)0, (int)this.sb.length(), (String)"empty string test failed");
        this.sb.setLength(0);
        this.underTest.appendParagraph(null);
        Assertions.assertEquals((int)0, (int)this.sb.length(), (String)"null test failed");
    }

    @Test
    void testAppendParagraphFormat() throws IOException {
        String[] expected = new String[]{" Hello Joe World 309", ""};
        this.sb.setLength(0);
        this.underTest.appendParagraphFormat("Hello %s World %,d", new Object[]{"Joe", 309});
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual);
        this.sb.setLength(0);
        this.underTest.appendParagraphFormat("", new Object[0]);
        Assertions.assertEquals((int)0, (int)this.sb.length(), (String)"empty string test failed");
    }

    @Test
    void testAppendTable() throws IOException {
        TextStyle.Builder styleBuilder = TextStyle.builder();
        ArrayList<TextStyle> styles = new ArrayList<TextStyle>();
        styles.add(styleBuilder.setIndent(2).get());
        styles.add(styleBuilder.setIndent(0).setLeftPad(5).setAlignment(TextStyle.Alignment.RIGHT).get());
        String[] headers = new String[]{"fox", "time"};
        List<List> rows = Arrays.asList(Arrays.asList("The quick brown fox jumps over the lazy dog", "Now is the time for all good people to come to the aid of their country"), Arrays.asList("L\u00e9imeann an sionnach donn gasta thar an madra leisci\u00fail", "Anois an t-am do na daoine maithe go l\u00e9ir teacht i gcabhair ar a dt\u00edr"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(" Common Phrases");
        expected.add("");
        expected.add("               fox                                       time                   ");
        expected.add(" The quick brown fox jumps over           Now is the time for all good people to");
        expected.add("   the lazy dog                                 come to the aid of their country");
        expected.add(" L\u00e9imeann an sionnach donn gasta       Anois an t-am do na daoine maithe go l\u00e9ir");
        expected.add("   thar an madra leisci\u00fail                           teacht i gcabhair ar a dt\u00edr");
        expected.add("");
        TableDefinition table = TableDefinition.from((String)"Common Phrases", styles, Arrays.asList(headers), rows);
        this.sb.setLength(0);
        this.underTest.setMaxWidth(80);
        this.underTest.appendTable(table);
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"full table failed");
        table = TableDefinition.from(null, styles, Arrays.asList(headers), rows);
        expected.remove(1);
        expected.remove(0);
        this.sb.setLength(0);
        this.underTest.appendTable(table);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        table = TableDefinition.from(null, styles, Arrays.asList(headers), Collections.emptyList());
        expected = new ArrayList();
        expected.add(" fox     time");
        expected.add("");
        this.sb.setLength(0);
        this.underTest.appendTable(table);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"no rows test failed");
    }

    @Test
    void testAppendTitle() throws IOException {
        String[] expected = new String[]{" Hello World", " ###########", ""};
        this.sb.setLength(0);
        this.underTest.appendTitle((CharSequence)"Hello World");
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(Arrays.asList(expected), (Object)actual);
        this.sb.setLength(0);
        this.underTest.appendTitle((CharSequence)"");
        Assertions.assertEquals((int)0, (int)this.sb.length(), (String)"empty string test failed");
        this.sb.setLength(0);
        this.underTest.appendTitle(null);
        Assertions.assertEquals((int)0, (int)this.sb.length(), (String)"null test failed");
    }

    @Test
    void testGetStyleBuilder() {
        TextStyle.Builder builder = this.underTest.getTextStyleBuilder();
        Assertions.assertEquals((int)3, (int)builder.getIndent(), (String)"Default indent value was changed, some tests may fail");
        Assertions.assertEquals((int)1, (int)builder.getLeftPad(), (String)"Default left pad value was changed, some tests may fail");
        Assertions.assertEquals((int)74, (int)builder.getMaxWidth(), (String)"Default width value was changed, some tests may fail");
    }

    @Test
    void testindexOfWrapPos() {
        String testString = "The quick brown fox jumps over\tthe lazy dog";
        Assertions.assertEquals((int)9, (int)TextHelpAppendable.indexOfWrap((CharSequence)"The quick brown fox jumps over\tthe lazy dog", (int)10, (int)0), (String)"did not find end of word");
        Assertions.assertEquals((int)9, (int)TextHelpAppendable.indexOfWrap((CharSequence)"The quick brown fox jumps over\tthe lazy dog", (int)14, (int)0), (String)"did not backup to end of word");
        Assertions.assertEquals((int)15, (int)TextHelpAppendable.indexOfWrap((CharSequence)"The quick brown fox jumps over\tthe lazy dog", (int)15, (int)0), (String)"did not find word at 15");
        Assertions.assertEquals((int)15, (int)TextHelpAppendable.indexOfWrap((CharSequence)"The quick brown fox jumps over\tthe lazy dog", (int)16, (int)0));
        Assertions.assertEquals((int)30, (int)TextHelpAppendable.indexOfWrap((CharSequence)"The quick brown fox jumps over\tthe lazy dog", (int)15, (int)20), (String)"did not find break character");
        Assertions.assertEquals((int)30, (int)TextHelpAppendable.indexOfWrap((CharSequence)"The quick brown fox jumps over\tthe lazy dog", (int)150, (int)0), (String)"did not handle text shorter than width");
        Assertions.assertThrows(IllegalArgumentException.class, () -> TextHelpAppendable.indexOfWrap((CharSequence)"", (int)0, (int)0));
        Assertions.assertEquals((int)3, (int)TextHelpAppendable.indexOfWrap((CharSequence)"Hello", (int)4, (int)0));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.cli.help.UtilTest#charArgs"})
    void testindexOfWrapPosWithWhitespace(Character c, boolean isWhitespace) {
        String text = String.format("Hello%cWorld", c);
        Assertions.assertEquals((int)(isWhitespace ? 5 : 6), (int)TextHelpAppendable.indexOfWrap((CharSequence)text, (int)7, (int)0));
    }

    @Test
    void testMakeColumnQueue() {
        String text = "The quick brown fox jumps over the lazy dog";
        TextStyle.Builder styleBuilder = TextStyle.builder().setMaxWidth(10).setIndent(0).setLeftPad(0);
        LinkedList<String> expected = new LinkedList<String>();
        expected.add("The quick ");
        expected.add("brown fox ");
        expected.add("jumps over");
        expected.add("the lazy  ");
        expected.add("dog       ");
        Queue result = this.underTest.makeColumnQueue((CharSequence)"The quick brown fox jumps over the lazy dog", styleBuilder.get());
        Assertions.assertEquals(expected, (Object)result, (String)"left aligned failed");
        expected.clear();
        expected.add(" The quick");
        expected.add(" brown fox");
        expected.add("jumps over");
        expected.add("  the lazy");
        expected.add("       dog");
        styleBuilder.setAlignment(TextStyle.Alignment.RIGHT);
        result = this.underTest.makeColumnQueue((CharSequence)"The quick brown fox jumps over the lazy dog", styleBuilder.get());
        Assertions.assertEquals(expected, (Object)result, (String)"right aligned failed");
        expected.clear();
        expected.add("The quick ");
        expected.add("brown fox ");
        expected.add("jumps over");
        expected.add(" the lazy ");
        expected.add("   dog    ");
        styleBuilder.setAlignment(TextStyle.Alignment.CENTER);
        result = this.underTest.makeColumnQueue((CharSequence)"The quick brown fox jumps over the lazy dog", styleBuilder.get());
        Assertions.assertEquals(expected, (Object)result, (String)"center aligned failed");
        expected = new LinkedList();
        expected.add("      The quick");
        expected.add("          brown");
        expected.add("            fox");
        expected.add("          jumps");
        expected.add("       over the");
        expected.add("       lazy dog");
        styleBuilder.setAlignment(TextStyle.Alignment.RIGHT).setLeftPad(5).setIndent(2);
        result = this.underTest.makeColumnQueue((CharSequence)"The quick brown fox jumps over the lazy dog", styleBuilder.get());
        Assertions.assertEquals(expected, (Object)result, (String)"right aligned failed");
    }

    @Test
    void testMakeColumnQueueWithMultipleTrailingLineBreaks() {
        String text = "Header\t\u000e";
        TextStyle.Builder styleBuilder = TextStyle.builder().setMaxWidth(10).setIndent(0).setLeftPad(0);
        LinkedList<String> expected = new LinkedList<String>();
        expected.add("Header    ");
        expected.add("          ");
        Queue result = this.underTest.makeColumnQueue((CharSequence)"Header\t\u000e", styleBuilder.get());
        Assertions.assertEquals(expected, (Object)result, (String)"left aligned failed");
    }

    @Test
    void testPrintWrapped() throws IOException {
        String text = "The quick brown fox jumps over the lazy dog";
        TextStyle.Builder styleBuilder = TextStyle.builder().setMaxWidth(10).setIndent(0).setLeftPad(0);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("The quick");
        expected.add("brown fox");
        expected.add("jumps over");
        expected.add("the lazy");
        expected.add("dog");
        this.underTest.printWrapped(text, styleBuilder.get());
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"left aligned failed");
        this.sb.setLength(0);
        expected.clear();
        expected.add(" The quick");
        expected.add(" brown fox");
        expected.add("jumps over");
        expected.add("  the lazy");
        expected.add("       dog");
        styleBuilder.setAlignment(TextStyle.Alignment.RIGHT);
        this.underTest.printWrapped(text, styleBuilder.get());
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"right aligned failed");
        this.sb.setLength(0);
        expected.clear();
        expected.add("The quick");
        expected.add("brown fox");
        expected.add("jumps over");
        expected.add(" the lazy");
        expected.add("   dog");
        styleBuilder.setAlignment(TextStyle.Alignment.CENTER);
        this.underTest.printWrapped(text, styleBuilder.get());
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"center aligned failed");
        this.sb.setLength(0);
        expected.clear();
        expected.add(" The quick brown fox jumps over the lazy dog");
        Assertions.assertEquals((int)1, (int)this.underTest.getLeftPad(), (String)"unexpected page left pad");
        Assertions.assertEquals((int)3, (int)this.underTest.getIndent(), (String)"unexpected page indent");
        Assertions.assertEquals((int)74, (int)this.underTest.getMaxWidth(), (String)"unexpected page width");
        this.underTest.printWrapped(text);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"default format aligned failed");
        this.sb.setLength(0);
        text = text + ".\nNow is the time for all good people to come to the aid of their country.";
        expected.clear();
        expected.add(" The quick brown fox jumps over the lazy dog.");
        expected.add("    Now is the time for all good people to come to the aid of their");
        expected.add("    country.");
        this.underTest.printWrapped(text);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"default format aligned failed");
    }

    @Test
    void testResize() {
        TextStyle.Builder tsBuilder = TextStyle.builder().setIndent(2).setMaxWidth(3);
        this.underTest.resize(tsBuilder, 0.5);
        Assertions.assertEquals((int)0, (int)tsBuilder.getIndent());
        tsBuilder = TextStyle.builder().setIndent(4).setMaxWidth(6);
        this.underTest.resize(tsBuilder, 0.5);
        Assertions.assertEquals((int)1, (int)tsBuilder.getIndent());
    }

    @Test
    void testResizeTableFormat() {
        this.underTest.setMaxWidth(150);
        TableDefinition tableDefinition = TableDefinition.from((String)"Caption", Collections.singletonList(TextStyle.builder().setMinWidth(20).setMaxWidth(100).get()), Collections.singletonList("header"), Collections.singletonList(Collections.singletonList("one")));
        TableDefinition result = this.underTest.adjustTableFormat(tableDefinition);
        Assertions.assertEquals((int)20, (int)((TextStyle)result.columnTextStyles().get(0)).getMinWidth(), (String)"Minimum width should not be reset");
        Assertions.assertEquals((int)100, (int)((TextStyle)result.columnTextStyles().get(0)).getMaxWidth(), (String)"Maximum width should not be reset");
    }

    @Test
    void testSetIndent() {
        Assertions.assertEquals((int)3, (int)this.underTest.getIndent(), (String)"Default indent value was changed, some tests may fail");
        this.underTest.setIndent(5);
        Assertions.assertEquals((int)this.underTest.getIndent(), (int)5);
    }

    @Test
    void testWriteColumnQueues() throws IOException {
        ArrayList queues = new ArrayList();
        LinkedList<String> queue = new LinkedList<String>();
        queue.add("The quick ");
        queue.add("brown fox ");
        queue.add("jumps over");
        queue.add("the lazy  ");
        queue.add("dog       ");
        queues.add(queue);
        queue = new LinkedList();
        queue.add("     Now is the");
        queue.add("     time for  ");
        queue.add("     all good  ");
        queue.add("     people to ");
        queue.add("     come to   ");
        queue.add("     the aid of");
        queue.add("     their     ");
        queue.add("     country   ");
        queues.add(queue);
        TextStyle.Builder styleBuilder = TextStyle.builder().setMaxWidth(10).setIndent(0).setLeftPad(0);
        ArrayList<TextStyle> columns = new ArrayList<TextStyle>();
        columns.add(styleBuilder.get());
        columns.add(styleBuilder.setLeftPad(5).get());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(" The quick      Now is the");
        expected.add(" brown fox      time for  ");
        expected.add(" jumps over     all good  ");
        expected.add(" the lazy       people to ");
        expected.add(" dog            come to   ");
        expected.add("                the aid of");
        expected.add("                their     ");
        expected.add("                country   ");
        this.sb.setLength(0);
        this.underTest.writeColumnQueues(queues, columns);
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
    }
}

