/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.pack200.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.harmony.pack200.Codec;
import org.apache.harmony.pack200.Pack200Exception;
import org.apache.harmony.pack200.PopulationCodec;

/*
 * Exception performing whole class analysis ignored.
 */
public class PopulationCodecTest
extends TestCase {
    public void testPopulationCodec() throws IOException, Pack200Exception {
        byte[] byArray = new byte[9];
        byArray[0] = 4;
        byArray[1] = 5;
        byArray[2] = 6;
        byArray[3] = 4;
        byArray[4] = 2;
        byArray[5] = 1;
        byArray[6] = 3;
        byArray[8] = 7;
        this.checkDecode(byArray, new long[]{5L, 4L, 6L, 7L}, (Codec)Codec.BYTE1);
        byte[] byArray2 = new byte[9];
        byArray2[0] = 8;
        byArray2[1] = 7;
        byArray2[2] = 12;
        byArray2[3] = 8;
        byArray2[4] = 4;
        byArray2[5] = 2;
        byArray2[6] = 6;
        byArray2[8] = 14;
        this.checkDecode(byArray2, new long[]{-4L, 4L, 6L, 7L}, (Codec)Codec.SIGNED5);
        byte[] byArray3 = new byte[9];
        byArray3[0] = 7;
        byArray3[1] = 8;
        byArray3[2] = 12;
        byArray3[3] = 8;
        byArray3[4] = 4;
        byArray3[5] = 2;
        byArray3[6] = 6;
        byArray3[8] = 14;
        this.checkDecode(byArray3, new long[]{4L, -4L, 6L, 7L}, (Codec)Codec.SIGNED5);
        this.checkDecode(new byte[]{1, 1, 1}, new long[]{1L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{2, 2, 1}, new long[]{2L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{1, 1, 2}, new long[]{-1L}, (Codec)Codec.SIGNED5);
        byte[] byArray4 = new byte[5];
        byArray4[0] = 2;
        byArray4[1] = 2;
        byArray4[3] = 1;
        byArray4[4] = 3;
        this.checkDecode(byArray4, new long[]{3L, 2L}, (Codec)Codec.BYTE1);
        byte[] byArray5 = new byte[10];
        byArray5[0] = 1;
        byArray5[1] = 2;
        byArray5[2] = 3;
        byArray5[3] = 4;
        byArray5[4] = 4;
        byArray5[5] = 2;
        byArray5[6] = 3;
        byArray5[7] = 4;
        byArray5[9] = 1;
        this.checkDecode(byArray5, new long[]{2L, 3L, 4L, 1L}, (Codec)Codec.BYTE1);
        byte[] byArray6 = new byte[10];
        byArray6[0] = 3;
        byArray6[1] = 2;
        byArray6[2] = 1;
        byArray6[3] = 4;
        byArray6[4] = 4;
        byArray6[5] = 2;
        byArray6[6] = 3;
        byArray6[7] = 4;
        byArray6[9] = 1;
        this.checkDecode(byArray6, new long[]{2L, 1L, 4L, 1L}, (Codec)Codec.BYTE1);
        byte[] byArray7 = new byte[10];
        byArray7[0] = 3;
        byArray7[1] = 2;
        byArray7[2] = 1;
        byArray7[3] = 4;
        byArray7[4] = 1;
        byArray7[5] = 2;
        byArray7[6] = 3;
        byArray7[7] = 4;
        byArray7[9] = 1;
        this.checkDecode(byArray7, new long[]{2L, 1L, 4L, 1L}, (Codec)Codec.BYTE1);
    }

    private void checkDecode(byte[] data, long[] expectedResult, Codec codec) throws IOException, Pack200Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        long[] result = new PopulationCodec(codec, codec, codec).decode(expectedResult.length, (InputStream)in);
        PopulationCodecTest.assertEquals((int)expectedResult.length, (int)result.length);
        int i = 0;
        while (i < expectedResult.length) {
            PopulationCodecTest.assertEquals((long)expectedResult[i], (long)result[i]);
            ++i;
        }
        PopulationCodecTest.assertEquals((int)0, (int)((InputStream)in).available());
    }
}

